/*
 * Decompiled with CFR 0.152.
 */
package ifc.text;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.text.XAutoTextGroup;
import com.sun.star.text.XTextRange;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueComparer;

public class _XAutoTextGroup
extends MultiMethodTest {
    public XAutoTextGroup oObj = null;
    protected static int uniq = 0;
    protected String str = null;
    protected static final String pref = "XAutoTextGroup";
    protected XTextRange oRange = null;

    @Override
    public void before() {
        this.str = pref + uniq++;
        String[] names = this.oObj.getElementNames();
        for (int i = 0; i < names.length; ++i) {
            this.log.println("  " + names[i]);
            if (names[i].toUpperCase().indexOf(pref.toUpperCase()) <= 0) continue;
            try {
                this.log.println("  ... removing ...");
                this.oObj.removeByName(names[i]);
                continue;
            }
            catch (NoSuchElementException e) {
                this.log.println("Element '" + names[i] + "' not found.");
            }
        }
        this.oRange = (XTextRange)this.tEnv.getObjRelation("TextRange");
        if (this.oRange == null) {
            throw new StatusException(Status.failed("No relation found"));
        }
    }

    public void _getTitles() {
        String[] titles = this.oObj.getTitles();
        this.tRes.tested("getTitles()", titles != null);
    }

    public void _insertNewByName() {
        boolean result = false;
        try {
            String[] before = this.oObj.getTitles();
            this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
            String[] after = this.oObj.getTitles();
            result = !ValueComparer.equalValue(before, after);
        }
        catch (ElementExistException ex) {
            this.log.println("Exception occured while testing insertNewByName");
            ex.printStackTrace(this.log);
            result = false;
        }
        try {
            this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
            this.log.println("com::sun::star::container::ElementExistsException wasn't thrown");
            this.oObj.removeByName(this.str);
            result &= false;
        }
        catch (ElementExistException ex) {
            result &= true;
        }
        catch (NoSuchElementException ex) {
            this.log.println("Wrong exception was thrown :");
            ex.printStackTrace(this.log);
            result &= false;
        }
        this.tRes.tested("insertNewByName()", result);
    }

    public void _removeByName() {
        this.requiredMethod("insertNewByName()");
        try {
            String[] before = this.oObj.getTitles();
            this.oObj.removeByName(this.str);
            String[] after = this.oObj.getTitles();
            this.tRes.tested("removeByName()", !ValueComparer.equalValue(before, after));
        }
        catch (NoSuchElementException ex) {
            this.log.println("Exception occured while testing removeByName");
            ex.printStackTrace(this.log);
            this.tRes.tested("removeByName()", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _renameByName() {
        boolean result;
        block94: {
            result = false;
            try {
                String[] tit = this.oObj.getTitles();
                String[] names = this.oObj.getElementNames();
                this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
                this.oObj.insertNewByName(this.str + "dup", "For " + this.str, this.oRange);
                tit = this.oObj.getTitles();
                names = this.oObj.getElementNames();
                result = true;
            }
            catch (ElementExistException e) {
                this.log.println("Unexpected exception occured :");
                e.printStackTrace(this.log);
            }
            finally {
                if (result) break block94;
                try {
                    this.oObj.removeByName(this.str);
                }
                catch (NoSuchElementException e) {}
                try {
                    this.oObj.removeByName(this.str + "dup");
                }
                catch (NoSuchElementException e) {}
                this.tRes.tested("renameByName()", false);
                return;
            }
        }
        try {
            this.oObj.renameByName(this.str, this.str + "dup", "For " + this.str);
            this.log.println("com::sun::star::container::ElementExistsException wasn't thrown");
            result = false;
        }
        catch (ElementExistException e) {
            result = true;
        }
        catch (IOException e) {
            this.log.println("Wrong exception was thrown :");
            e.printStackTrace(this.log);
            result = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("Wrong exception was thrown :");
            e.printStackTrace(this.log);
            result = false;
        }
        finally {
            try {
                this.oObj.removeByName(this.str);
            }
            catch (NoSuchElementException e) {}
            try {
                this.oObj.removeByName(this.str + "dup");
            }
            catch (NoSuchElementException e) {}
        }
        try {
            this.oObj.renameByName("~" + this.str, this.str, this.str);
            this.log.println("com::sun::star::lang::IllegalArgumentException wasn't thrown");
            result &= false;
        }
        catch (IllegalArgumentException ex) {
            result &= true;
        }
        catch (ElementExistException e) {
            this.log.println("Unexpected exception :");
            e.printStackTrace(this.log);
            result = false;
        }
        catch (IOException e) {
            this.log.println("Unexpected exception :");
            e.printStackTrace(this.log);
            result = false;
        }
        finally {
            try {
                this.oObj.removeByName(this.str);
            }
            catch (NoSuchElementException e) {}
        }
        try {
            this.oObj.insertNewByName(this.str, "For " + this.str, this.oRange);
            this.oObj.renameByName(this.str, this.str + "a", this.str + "b");
            result &= this.oObj.hasByName(this.str + "a");
        }
        catch (ElementExistException ex) {
            this.log.println("Exception occured while testing renameByName");
            ex.printStackTrace(this.log);
            result &= false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("Exception occured while testing renameByName");
            ex.printStackTrace(this.log);
            result &= false;
        }
        catch (IOException ex) {
            this.log.println("Exception occured while testing renameByName");
            ex.printStackTrace(this.log);
            result &= false;
        }
        finally {
            try {
                this.oObj.removeByName(this.str);
            }
            catch (NoSuchElementException e) {}
            try {
                this.oObj.removeByName(this.str + "a");
            }
            catch (NoSuchElementException e) {}
        }
        this.tRes.tested("renameByName()", result);
    }
}

