/*
 * Decompiled with CFR 0.152.
 */
package ifc.table;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableRows;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XTableRows
extends MultiMethodTest {
    public XTableRows oObj = null;
    public XCellRange range = null;

    @Override
    public void before() {
        this.range = (XCellRange)this.tEnv.getObjRelation("XTableRows.XCellRange");
        if (this.range == null) {
            throw new StatusException(Status.failed("ObjectRelation missing"));
        }
        try {
            this.range.getCellByPosition(0, 0).setValue(17.0);
            this.range.getCellByPosition(0, 1).setValue(15.0);
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Couldn't set value for Cell A1");
        }
    }

    public void _insertByIndex() {
        boolean result = true;
        this.requiredMethod("removeByIndex()");
        int origCnt = this.oObj.getCount();
        this.log.println("Inserting row before first row");
        this.oObj.insertByIndex(0, 1);
        result &= this.checkCell(1, 15.0);
        if (this.checkCell(1, 15.0)) {
            this.log.println("... successful");
        }
        try {
            this.oObj.insertByIndex(-1, 1);
            this.log.println("No Exception occurred while inserting row at -1");
            result &= false;
        }
        catch (Exception e) {
            this.log.println("Inserting row at Index -1 ... OK");
            result &= true;
        }
        this.tRes.tested("insertByIndex()", result);
    }

    public void _removeByIndex() {
        boolean result = true;
        this.oObj.removeByIndex(0, 1);
        this.log.println("Removing first row");
        result &= this.checkCell(0, 15.0);
        if (this.checkCell(0, 15.0)) {
            this.log.println("... successful");
        }
        try {
            this.oObj.removeByIndex(-1, 1);
            this.log.println("No Exception occurred while Removing row at -1");
            result &= false;
        }
        catch (Exception e) {
            this.log.println("Removing row at Index -1 ... OK");
            result &= true;
        }
        this.tRes.tested("removeByIndex()", result);
    }

    public boolean checkCell(int row, double expected) {
        boolean res;
        double getting = 0.0;
        try {
            getting = this.range.getCellByPosition(0, row).getValue();
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Couldn't set value for Cell A1");
        }
        boolean bl = res = getting == expected;
        if (!res) {
            this.log.println("Expected for row " + row + " was " + expected);
            this.log.println("Getting for row " + row + " - " + getting);
            this.log.println("=> FAILED");
        }
        return res;
    }
}

