/*
 * Decompiled with CFR 0.152.
 */
package ifc.table;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XSimpleText;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XTableColumns
extends MultiMethodTest {
    public XTableColumns oObj = null;
    private XCellRange xCellRange = null;
    private int lastColumn = 0;

    @Override
    public void before() {
        this.xCellRange = (XCellRange)this.tEnv.getObjRelation("XTableColumns.XCellRange");
        if (this.xCellRange == null) {
            throw new StatusException(Status.failed("Relation missing"));
        }
        this.lastColumn = this.oObj.getCount() - 1;
    }

    public void _insertByIndex() {
        boolean result = true;
        int origCnt = this.oObj.getCount();
        try {
            this.log.println("Filling range ... ");
            this.fillRange(this.xCellRange);
            this.log.println("Inserting 1 column at position 1 ...");
            this.oObj.insertByIndex(1, 1);
            result &= this.checkColumn(0, 0);
            result &= this.checkColumnEmpty(1);
            result &= this.checkColumn(2, 1);
            result &= this.checkColumn(3, 2);
            result &= this.checkColumnEmpty(4);
            if (this.lastColumn < 200) {
                result &= this.checkColumn(this.lastColumn + 1, this.lastColumn);
                result &= this.oObj.getCount() == origCnt + 1;
            } else {
                result &= this.checkColumnEmpty(this.lastColumn);
            }
            this.log.println("Inserting 1 column at position 0 ...");
            this.oObj.insertByIndex(0, 1);
            result &= this.checkColumnEmpty(0);
            result &= this.checkColumn(1, 0);
            result &= this.checkColumnEmpty(2);
            result &= this.checkColumn(3, 1);
            result &= this.checkColumn(4, 2);
            result &= this.checkColumnEmpty(5);
            if (this.lastColumn < 200) {
                result &= this.checkColumn(this.lastColumn + 2, this.lastColumn);
                result &= this.oObj.getCount() == origCnt + 2;
            }
            this.log.println("Inserting 2 columns at position 0 ...");
            this.oObj.insertByIndex(0, 2);
            result &= this.checkColumnEmpty(0);
            result &= this.checkColumnEmpty(1);
            result &= this.checkColumnEmpty(2);
            result &= this.checkColumn(3, 0);
            result &= this.checkColumnEmpty(4);
            result &= this.checkColumn(5, 1);
            result &= this.checkColumn(6, 2);
            result &= this.checkColumnEmpty(7);
            if (this.lastColumn < 200) {
                result &= this.checkColumn(this.lastColumn + 4, this.lastColumn);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        if (origCnt < 200) {
            this.log.println("Checking that number of column increased.");
            result &= this.oObj.getCount() == origCnt + 4;
            this.log.println("Before: " + origCnt + ", After: " + this.oObj.getCount());
        } else {
            this.log.println("Number of columns is " + origCnt + ",");
            this.log.println("supposing that this is the whole spreadsheet and ");
            this.log.println("number of columns should not change.");
        }
        try {
            this.oObj.insertByIndex(-1, 1);
            this.log.println("No Exception occurred while inserting column at -1");
            result &= false;
        }
        catch (Exception e) {
            this.log.println("Inserting column at Index -1 ... OK");
            result &= true;
        }
        int cnt = this.oObj.getCount();
        try {
            this.oObj.insertByIndex(cnt, 1);
            this.log.println("No Exception occurred while inserting column at " + cnt);
            result &= false;
        }
        catch (Exception e) {
            this.log.println("Inserting column at Index " + cnt + " ... OK");
            result &= true;
        }
        if (this.tEnv.getTestCase().getObjectName().equals("ScTableColumnsObj")) {
            try {
                this.oObj.insertByIndex(0, 0);
                this.log.println("No Exception occurred while inserting 0 columns");
                result &= false;
            }
            catch (Exception e) {
                this.log.println("Inserting 0 columns ... OK");
                result &= true;
            }
        }
        this.tRes.tested("insertByIndex()", result);
    }

    public void _removeByIndex() {
        this.executeMethod("insertByIndex()");
        boolean result = true;
        int origCnt = this.oObj.getCount();
        try {
            this.log.println("Filling range ... ");
            this.log.println("Removing 2 columns at position 0 ...");
            this.oObj.removeByIndex(0, 2);
            result &= this.checkColumnEmpty(0);
            result &= this.checkColumn(1, 0);
            result &= this.checkColumnEmpty(2);
            result &= this.checkColumn(3, 1);
            result &= this.checkColumn(4, 2);
            result &= this.checkColumnEmpty(5);
            if (this.lastColumn < 200) {
                result &= this.checkColumn(this.lastColumn + 2, this.lastColumn);
                result &= this.oObj.getCount() == origCnt - 2;
            }
            this.log.println("Removing 1 column at position 0 ...");
            this.oObj.removeByIndex(0, 1);
            result &= this.checkColumn(0, 0);
            result &= this.checkColumnEmpty(1);
            result &= this.checkColumn(2, 1);
            result &= this.checkColumn(3, 2);
            result &= this.checkColumnEmpty(4);
            if (this.lastColumn < 200) {
                result &= this.checkColumn(this.lastColumn + 1, this.lastColumn);
                result &= this.oObj.getCount() == origCnt - 3;
            }
            this.log.println("Removing 1 column at position 1 ...");
            this.oObj.removeByIndex(1, 1);
            result &= this.checkColumn(0, 0);
            result &= this.checkColumn(1, 1);
            result &= this.checkColumn(2, 2);
            result &= this.checkColumnEmpty(3);
            if (this.lastColumn < 200) {
                result &= this.checkColumn(this.lastColumn, this.lastColumn);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        if (origCnt < 200) {
            this.log.println("Checking that number of column increased.");
            result &= this.oObj.getCount() == origCnt - 4;
            this.log.println("Before: " + origCnt + ", After: " + this.oObj.getCount());
        } else {
            this.log.println("Number of columns is " + origCnt + ",");
            this.log.println("supposing that this is the whole spreadsheet and ");
            this.log.println("number of columns should not change.");
        }
        try {
            this.oObj.removeByIndex(-1, 1);
            this.log.println("No Exception occurred while removing column at -1");
            result &= false;
        }
        catch (Exception e) {
            this.log.println("removing column at Index -1 ... OK");
            result &= true;
        }
        int cnt = this.oObj.getCount();
        try {
            this.oObj.removeByIndex(cnt, 1);
            this.log.println("No Exception occurred while removing column at " + cnt);
            result &= false;
        }
        catch (Exception e) {
            this.log.println("Removing column at Index " + cnt + " ... OK");
            result &= true;
        }
        if (this.tEnv.getTestCase().getObjectName().equals("ScTableColumnsObj")) {
            try {
                this.oObj.removeByIndex(0, 0);
                this.log.println("No Exception occurred while removing 0 columns");
                result &= false;
            }
            catch (Exception e) {
                this.log.println("removing 0 columns ... OK");
                result &= true;
            }
        }
        this.tRes.tested("removeByIndex()", result);
    }

    private void setCellText(XCell cell, String text) {
        XSimpleText xText = UnoRuntime.queryInterface(XSimpleText.class, (Object)cell);
        xText.setString(text);
    }

    private String getCellText(XCell cell) {
        XSimpleText xText = UnoRuntime.queryInterface(XSimpleText.class, (Object)cell);
        return xText.getString();
    }

    private void fillRange(XCellRange xRange) throws IndexOutOfBoundsException {
        int i;
        for (i = 0; i <= this.lastColumn && i < 3; ++i) {
            this.setCellText(xRange.getCellByPosition(i, 0), "" + i + "a");
            this.setCellText(xRange.getCellByPosition(i, 1), "" + i + "b");
        }
        for (i = 3; i <= this.lastColumn && i < 10; ++i) {
            this.setCellText(xRange.getCellByPosition(i, 0), "");
            this.setCellText(xRange.getCellByPosition(i, 1), "");
        }
    }

    private boolean checkColumn(int col, int idx) throws IndexOutOfBoundsException {
        if (col >= this.oObj.getCount()) {
            return true;
        }
        String c1 = this.getCellText(this.xCellRange.getCellByPosition(col, 0));
        String c2 = this.getCellText(this.xCellRange.getCellByPosition(col, 1));
        if (!("" + idx + "a").equals(c1) || !("" + idx + "b").equals(c2)) {
            this.log.println("FAILED for column " + col + " and index " + idx + "(" + c1 + "," + c2 + ")");
            return false;
        }
        return true;
    }

    private boolean checkColumnEmpty(int col) throws IndexOutOfBoundsException {
        if (col >= this.oObj.getCount()) {
            return true;
        }
        String c1 = this.getCellText(this.xCellRange.getCellByPosition(col, 0));
        String c2 = this.getCellText(this.xCellRange.getCellByPosition(col, 1));
        if (!"".equals(c1) || !"".equals(c2)) {
            this.log.println("FAILED for column " + col + " is not empty (" + c1 + "," + c2 + ")");
            return false;
        }
        return true;
    }
}

