/*
 * Decompiled with CFR 0.152.
 */
package ifc.system;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.system.SystemShellExecuteException;
import com.sun.star.system.XSystemShellExecute;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import util.utils;

public class _XSystemShellExecute
extends MultiMethodTest {
    public XSystemShellExecute oObj = null;

    public void _execute() {
        int i;
        String cClassPath = System.getProperty("DOCPTH");
        String cResFile = utils.getOfficeTempDirSys((XMultiServiceFactory)this.tParam.getMSF()) + "SystemShellExecute.txt";
        String cResURL = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF()) + "SystemShellExecute.txt";
        String cArgs = "-classpath " + cClassPath + " SystemShellExecute " + cResFile;
        String jh = System.getProperty("java.home");
        String fs = System.getProperty("file.separator");
        String cmd = jh + fs + "bin" + fs + "java";
        this.log.println("Executing : '" + cmd + " " + cArgs + "'");
        try {
            this.oObj.execute(cmd, cArgs, 1);
        }
        catch (SystemShellExecuteException e) {
            this.log.println("Exception during execute: " + e);
            this.log.println("This has been implemented due to security reasons");
            this.tRes.tested("execute()", true);
            return;
        }
        catch (IllegalArgumentException e) {
            this.log.println("Exception during execute: " + e);
            this.tRes.tested("execute()", false);
            return;
        }
        XSimpleFileAccess xFileAccess = null;
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)this.tParam.getMSF();
            Object fa = xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            xFileAccess = UnoRuntime.queryInterface(XSimpleFileAccess.class, fa);
        }
        catch (Exception e) {
            this.log.println("Couldn't create SimpleFileAccess:" + e);
            this.tRes.tested("execute()", false);
        }
        this.log.println("Waiting while the file will be created or timeout reached ...");
        boolean bExist = false;
        for (i = 0; i < 20 && !bExist; ++i) {
            try {
                bExist = xFileAccess.exists(cResURL);
            }
            catch (Exception e) {
                this.log.println("Exception:" + e);
            }
            this.shortWait();
        }
        if (bExist) {
            this.log.println("The command was executed and file created in " + i + " sec.");
        } else {
            this.log.println("File was not created");
        }
        this.tRes.tested("execute()", bExist);
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

