/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.GeneralFunction;
import com.sun.star.sheet.SubTotalColumn;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSubTotalCalculatable;
import com.sun.star.sheet.XSubTotalDescriptor;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XSubTotalCalculatable
extends MultiMethodTest {
    public XSubTotalCalculatable oObj;
    protected XSubTotalDescriptor desc;
    protected XSpreadsheet oSheet;

    @Override
    protected void before() {
        this.oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (this.oSheet == null) {
            this.log.println("Object relation oSheet is missing");
            this.log.println("Trying to query the needed Interface");
            this.oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.tEnv.getTestObject());
            if (this.oSheet == null) {
                throw new StatusException(Status.failed("Object relation oSheet is missing"));
            }
        }
    }

    public void _applySubTotals() {
        this.requiredMethod("createSubTotalDescriptor()");
        boolean res = true;
        try {
            this.oSheet.getCellByPosition(0, 0).setFormula("first");
            this.oSheet.getCellByPosition(1, 0).setFormula("second");
            this.oSheet.getCellByPosition(0, 3).setFormula("");
            this.oSheet.getCellByPosition(0, 1).setValue(5.0);
            this.oSheet.getCellByPosition(0, 2).setValue(5.0);
            this.oSheet.getCellByPosition(1, 1).setValue(17.0);
            this.oSheet.getCellByPosition(1, 2).setValue(25.0);
            this.oObj.applySubTotals(this.desc, true);
            String formula = this.oSheet.getCellByPosition(0, 3).getFormula();
            String expected = "=SUBTOTAL(9;$A$2:$A$3)";
            res = formula.equals(expected);
            if (!res) {
                this.log.println("getting: " + formula);
                this.log.println("expected: " + expected);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Couldn't fill cells" + e.getLocalizedMessage());
            res = false;
        }
        this.tRes.tested("applySubTotals()", res);
    }

    public void _createSubTotalDescriptor() {
        this.desc = this.oObj.createSubTotalDescriptor(true);
        SubTotalColumn[] columns = new SubTotalColumn[]{new SubTotalColumn()};
        columns[0].Column = 0;
        columns[0].Function = GeneralFunction.SUM;
        this.desc.addNew(columns, 0);
        this.tRes.tested("createSubTotalDescriptor()", true);
    }

    public void _removeSubTotals() {
        this.requiredMethod("applySubTotals()");
        boolean res = true;
        try {
            this.oObj.removeSubTotals();
            String formula = this.oSheet.getCellByPosition(0, 3).getFormula();
            String expected = "";
            res = formula.equals(expected);
            if (!res) {
                this.log.println("getting: " + formula);
                this.log.println("expected: " + expected);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Couldn't get cell" + e.getLocalizedMessage());
        }
        this.tRes.tested("removeSubTotals()", res);
    }
}

