/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.RuntimeException;
import lib.MultiMethodTest;

public class _XSpreadsheets
extends MultiMethodTest {
    protected static int uniqCount = 0;
    public XSpreadsheets oObj = null;
    protected int uniqNumber = 0;

    @Override
    protected synchronized void before() {
        this.uniqNumber = uniqCount++;
    }

    public void _copyByName() {
        boolean result = true;
        String iS = this.newName("copyFrom");
        this.log.println("Inserting sheet '" + iS + "'");
        this.oObj.insertNewByName(iS, (short)0);
        String[] eNames = this.oObj.getElementNames();
        String NewSheet = this.newName("copyTo");
        this.log.println("Try to copy " + eNames[0] + " to " + NewSheet);
        this.oObj.copyByName(eNames[0], NewSheet, (short)0);
        result = this.oObj.hasByName(NewSheet);
        try {
            this.oObj.removeByName(NewSheet);
            this.oObj.removeByName(iS);
        }
        catch (WrappedTargetException e) {
            this.log.print("Can't remove sheet by name");
            e.printStackTrace(this.log);
            result = false;
        }
        catch (NoSuchElementException e) {
            this.log.print("Can't remove sheet by name");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("copyByName()", result);
    }

    public void _moveByName() {
        String iS = this.newName("move");
        this.oObj.insertNewByName(iS, (short)0);
        String[] eNames = this.oObj.getElementNames();
        String sheetToMove = eNames[0];
        this.log.println("Try to move " + sheetToMove);
        this.oObj.moveByName(sheetToMove, (short)2);
        eNames = this.oObj.getElementNames();
        this.tRes.tested("moveByName()", sheetToMove.equals(eNames[1]));
    }

    public void _insertNewByName() {
        boolean result = false;
        String NewSheet = this.newName("insert");
        this.log.println("Try to insert " + NewSheet);
        this.oObj.insertNewByName(NewSheet, (short)0);
        result = this.oObj.hasByName(NewSheet);
        try {
            this.oObj.removeByName(NewSheet);
        }
        catch (WrappedTargetException e) {
            this.log.print("Can't remove sheet '" + NewSheet + "':");
            e.printStackTrace(this.log);
            result = false;
        }
        catch (NoSuchElementException e) {
            this.log.print("Can't remove sheet '" + NewSheet + "':");
            e.printStackTrace(this.log);
            result = false;
        }
        try {
            NewSheet = this.badName();
            this.log.println("Try to insert " + NewSheet);
            this.oObj.insertNewByName(NewSheet, (short)0);
            this.log.println("No Exception thrown while inserting sheet with invalid name");
            result &= false;
            this.oObj.removeByName(NewSheet);
        }
        catch (RuntimeException e) {
            this.log.println("Expected exception occured during testing 'insertNewByName'");
            result &= true;
        }
        catch (WrappedTargetException e) {
            this.log.print("Can't remove sheet '" + NewSheet + "':");
            e.printStackTrace(this.log);
            result = false;
        }
        catch (NoSuchElementException e) {
            this.log.print("Can't remove sheet '" + NewSheet + "':");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("insertNewByName()", result);
    }

    public String newName(String prefix) {
        return prefix + this.uniqNumber;
    }

    public String badName() {
        return "$%#/?\\";
    }
}

