/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.sheet.XCellRangesQuery;
import com.sun.star.sheet.XSheetCellRanges;
import com.sun.star.sheet.XSheetOutline;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.TableOrientation;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XSheetOutline
extends MultiMethodTest {
    public XSheetOutline oObj = null;
    CellRangeAddress address = null;
    CellRangeAddress subaddress = null;

    @Override
    public void before() {
        this.address = (CellRangeAddress)this.tEnv.getObjRelation("CellRangeAddress");
        this.subaddress = (CellRangeAddress)this.tEnv.getObjRelation("CellRangeSubAddress");
        if (this.address == null) {
            throw new StatusException(Status.failed("Object relation CellRangeAddress not found"));
        }
        if (this.subaddress == null) {
            throw new StatusException(Status.failed("Object relation CellRangeSubAddress not found"));
        }
    }

    public void _autoOutline() {
        this.executeMethod("ungroup()");
        boolean result = false;
        this.oObj.autoOutline(this.address);
        result = this.isCellShown(this.subaddress);
        this.oObj.hideDetail(this.address);
        this.tRes.tested("autoOutline()", result &= !this.isCellShown(this.subaddress));
    }

    public void _clearOutline() {
        this.executeMethod("autoOutline()");
        boolean result = false;
        this.oObj.clearOutline();
        result = this.isCellShown(this.subaddress);
        this.oObj.hideDetail(this.address);
        this.tRes.tested("clearOutline()", result &= this.isCellShown(this.subaddress));
    }

    public void _group() {
        this.oObj.group(this.address, TableOrientation.COLUMNS);
        this.oObj.group(this.address, TableOrientation.ROWS);
        this.tRes.tested("group()", true);
    }

    public void _ungroup() {
        this.executeMethod("showDetail()");
        this.oObj.ungroup(this.address, TableOrientation.COLUMNS);
        this.oObj.ungroup(this.address, TableOrientation.ROWS);
        this.oObj.hideDetail(this.address);
        this.tRes.tested("ungroup()", this.isCellShown(this.address));
    }

    public void _hideDetail() {
        this.requiredMethod("group()");
        this.oObj.hideDetail(this.address);
        this.tRes.tested("hideDetail()", !this.isCellShown(this.address));
    }

    public void _showDetail() {
        this.executeMethod("showLevel()");
        this.oObj.showDetail(this.address);
        this.tRes.tested("showDetail()", this.isCellShown(this.address));
    }

    public void _showLevel() {
        this.executeMethod("hideDetail()");
        boolean result = false;
        this.oObj.showLevel((short)2, TableOrientation.COLUMNS);
        this.oObj.showLevel((short)2, TableOrientation.ROWS);
        result = this.isCellShown(this.address);
        this.oObj.showLevel((short)0, TableOrientation.COLUMNS);
        this.oObj.showLevel((short)0, TableOrientation.ROWS);
        this.tRes.tested("showLevel()", result &= !this.isCellShown(this.address));
    }

    private boolean isCellShown(CellRangeAddress range) {
        boolean isNotShown = true;
        XCellRangesQuery xCellRangesQuery = UnoRuntime.queryInterface(XCellRangesQuery.class, (Object)this.oObj);
        if (xCellRangesQuery != null) {
            XSheetCellRanges xRanges = xCellRangesQuery.queryVisibleCells();
            CellRangeAddress[] visibleRanges = xRanges.getRangeAddresses();
            for (int i = 0; i < visibleRanges.length; ++i) {
                isNotShown &= this.dotIsOutsideRange(range.StartRow, range.StartColumn, visibleRanges[i]);
                isNotShown &= this.dotIsOutsideRange(range.StartRow, range.EndColumn, visibleRanges[i]);
                isNotShown &= this.dotIsOutsideRange(range.EndRow, range.StartColumn, visibleRanges[i]);
                this.log.println((isNotShown &= this.dotIsOutsideRange(range.EndRow, range.EndColumn, visibleRanges[i])) ? "\tisOutSide" : "\tisInside");
            }
        }
        return !isNotShown;
    }

    private boolean dotIsOutsideRange(int dotRow, int dotColumn, CellRangeAddress range) {
        this.log.println("Checking dot(" + dotRow + "," + dotColumn + ") against row[" + range.StartRow + ":" + range.EndRow + "]  column[" + range.StartColumn + ":" + range.EndColumn + "]");
        boolean isInside = true;
        if (dotRow >= range.StartRow && dotRow <= range.EndRow && dotColumn >= range.StartColumn && dotColumn <= range.EndColumn) {
            isInside = false;
        }
        return isInside;
    }
}

