/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.FilterOperator;
import com.sun.star.sheet.TableFilterField;
import com.sun.star.sheet.XSheetFilterDescriptor;
import com.sun.star.sheet.XSheetFilterable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.table.XTableRows;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XSheetFilterable
extends MultiMethodTest {
    public XSheetFilterable oObj;
    protected XSpreadsheet oSheet;
    protected XSheetFilterDescriptor desc;

    @Override
    protected void before() {
        this.oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (this.oSheet == null) {
            this.log.println("Object relation oSheet is missing");
            this.log.println("Trying to query the needed Interface");
            this.oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.tEnv.getTestObject());
            if (this.oSheet == null) {
                throw new StatusException(Status.failed("Object relation oSheet is missing"));
            }
        }
    }

    public void _createFilterDescriptor() {
        this.desc = this.oObj.createFilterDescriptor(true);
        TableFilterField[] tff = new TableFilterField[2];
        tff[0] = new TableFilterField();
        tff[0].IsNumeric = true;
        tff[0].Field = 0;
        tff[0].NumericValue = 2.0;
        tff[0].Operator = FilterOperator.GREATER_EQUAL;
        tff[1] = new TableFilterField();
        tff[1].IsNumeric = false;
        tff[1].Field = 1;
        tff[1].StringValue = "C";
        tff[1].Operator = FilterOperator.LESS;
        this.desc.setFilterFields(tff);
        this.tRes.tested("createFilterDescriptor()", true);
    }

    public void _filter() {
        boolean res = true;
        try {
            this.oSheet.getCellByPosition(0, 0).setValue(1.0);
            this.oSheet.getCellByPosition(0, 1).setValue(2.0);
            this.oSheet.getCellByPosition(0, 2).setValue(3.0);
            this.oSheet.getCellByPosition(1, 0).setFormula("A");
            this.oSheet.getCellByPosition(1, 1).setFormula("D");
            this.oSheet.getCellByPosition(1, 2).setFormula("B");
            this.oObj.filter(this.desc);
            XColumnRowRange oColumnRowRange = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oSheet);
            XTableRows oRows = oColumnRowRange.getRows();
            XPropertySet rowProp = UnoRuntime.queryInterface(XPropertySet.class, oRows.getByIndex(0));
            boolean locRes = (Boolean)rowProp.getPropertyValue("IsVisible");
            if (locRes) {
                this.log.println("Row 1 should be invisible after filter()");
                res &= false;
            } else {
                res &= true;
            }
            rowProp = UnoRuntime.queryInterface(XPropertySet.class, oRows.getByIndex(1));
            locRes = (Boolean)rowProp.getPropertyValue("IsVisible");
            if (locRes) {
                this.log.println("Row 2 should be invisible after filter()");
                res &= false;
            } else {
                res &= true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("couldn't fill cells " + e.getLocalizedMessage());
            res = false;
        }
        catch (WrappedTargetException e) {
            this.log.println("problems geting Property 'isVisible' " + e.getLocalizedMessage());
            res = false;
        }
        catch (UnknownPropertyException e) {
            this.log.println("problems geting Property 'isVisible' " + e.getLocalizedMessage());
            res = false;
        }
        this.tRes.tested("filter()", res);
    }
}

