/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.sheet.XSheetCellRangeContainer;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.uno.Exception;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XSheetCellRangeContainer
extends MultiMethodTest {
    public XSheetCellRangeContainer oObj = null;
    public CellRangeAddress[] rAddr = new CellRangeAddress[3];

    @Override
    public void before() {
        for (int i = 0; i <= 2; i = (int)((short)(i + 1))) {
            this.rAddr[i] = new CellRangeAddress();
            this.rAddr[i].Sheet = (short)i;
            this.rAddr[i].StartColumn = i;
            this.rAddr[i].StartRow = i;
            this.rAddr[i].EndColumn = i + 3;
            this.rAddr[i].EndRow = i + 3;
            try {
                this.oObj.removeRangeAddresses(this.oObj.getRangeAddresses());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
                throw new StatusException("Error: Cannot remove range addresses.", e);
            }
        }
    }

    public void _addRangeAddress() {
        boolean result = true;
        this.log.println("Elements before adding: " + this.oObj.getCount());
        this.oObj.addRangeAddress(this.rAddr[0], false);
        this.log.println("Elements after adding: " + this.oObj.getCount());
        CellRangeAddress[] addr = this.oObj.getRangeAddresses();
        boolean exist = false;
        for (int i = 0; i <= this.oObj.getCount() - 1; ++i) {
            if (addr[i].Sheet != this.rAddr[0].Sheet || addr[i].StartColumn != this.rAddr[0].StartColumn || addr[i].StartRow != this.rAddr[0].StartRow || addr[i].EndColumn != this.rAddr[0].EndColumn || addr[i].EndRow != this.rAddr[0].EndRow) continue;
            exist = true;
        }
        this.tRes.tested("addRangeAddress()", result &= exist);
    }

    public void _removeRangeAddress() {
        boolean result = true;
        this.log.println("Elements before removing: " + this.oObj.getCount());
        try {
            this.oObj.removeRangeAddress(this.rAddr[0]);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.log.println("Elements after removing: " + this.oObj.getCount());
        CellRangeAddress[] addr = this.oObj.getRangeAddresses();
        for (int i = 0; i <= this.oObj.getCount() - 1; ++i) {
            if (addr[i].Sheet != this.rAddr[0].Sheet || addr[i].StartColumn != this.rAddr[0].StartColumn || addr[i].StartRow != this.rAddr[0].StartRow || addr[i].EndColumn != this.rAddr[0].EndColumn || addr[i].EndRow != this.rAddr[0].EndRow) continue;
            result = false;
        }
        this.tRes.tested("removeRangeAddress()", result);
    }

    public void _addRangeAddresses() {
        this.executeMethod("addRangeAddress()");
        boolean result = true;
        int cntBefore = this.oObj.getCount();
        this.log.println("Elements before adding: " + cntBefore);
        this.oObj.addRangeAddresses(this.rAddr, false);
        this.log.println("Elements after adding: " + this.oObj.getCount());
        CellRangeAddress[] addr = this.oObj.getRangeAddresses();
        result &= cntBefore + this.rAddr.length == this.oObj.getCount();
        for (int j = 0; j < this.rAddr.length; ++j) {
            boolean exist = false;
            for (int i = 0; i < this.oObj.getCount(); ++i) {
                if (addr[i].Sheet != this.rAddr[j].Sheet || addr[i].StartColumn != this.rAddr[j].StartColumn || addr[i].StartRow != this.rAddr[j].StartRow || addr[i].EndColumn != this.rAddr[j].EndColumn || addr[i].EndRow != this.rAddr[j].EndRow) continue;
                exist = true;
                break;
            }
            result &= exist;
        }
        this.tRes.tested("addRangeAddresses()", result);
    }

    public void _removeRangeAddresses() {
        boolean result = false;
        this.log.println("Elements before removing: " + this.oObj.getCount());
        try {
            this.oObj.removeRangeAddresses(this.oObj.getRangeAddresses());
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        int cnt = this.oObj.getCount();
        if (cnt == 0) {
            result = true;
        }
        this.log.println("Elements after removing: " + cnt);
        this.tRes.tested("removeRangeAddresses()", result);
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

