/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.XArrayFormulaRange;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSheetCellCursor;
import com.sun.star.sheet.XSheetOperation;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XMergeable;
import lib.MultiMethodTest;

public class _XSheetCellCursor
extends MultiMethodTest {
    public XSheetCellCursor oObj = null;

    public void _collapseToCurrentArray() {
        boolean bResult = false;
        XCellRangeAddressable crAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)this.oObj);
        CellRangeAddress addr = crAddr.getRangeAddress();
        int leftCol = addr.StartColumn;
        int topRow = addr.StartRow;
        int width = addr.EndColumn - addr.StartColumn + 1;
        int height = addr.EndRow - addr.StartRow + 1;
        this.log.println("Object area is ((" + leftCol + "," + topRow + "),(" + (leftCol + width - 1) + "," + (topRow + height - 1) + ")");
        XCellRange new_range = null;
        try {
            new_range = this.oObj.getCellRangeByPosition(0, 0, 0, height - 1);
        }
        catch (IndexOutOfBoundsException e) {
            this.log.print("Get cell range by position failed: ");
            e.printStackTrace(this.log);
            this.tRes.tested("collapseToCurrentArray()", false);
        }
        this.log.println("DB: Successfully new range created");
        XArrayFormulaRange arrFormulaRange = UnoRuntime.queryInterface(XArrayFormulaRange.class, (Object)new_range);
        arrFormulaRange.setArrayFormula("A1:A" + height);
        this.oObj.collapseToSize(1, 1);
        this.oObj.collapseToCurrentArray();
        int cols = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getColumns().getCount();
        int rows = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getRows().getCount();
        if (cols == 1 && rows == height) {
            bResult = true;
        } else {
            bResult = false;
            this.log.println("The size of cell range must be 1x" + height + ", but after method call it was " + cols + "x" + rows);
        }
        arrFormulaRange.setArrayFormula("");
        try {
            new_range.getCellByPosition(0, 0).setValue(111.0);
        }
        catch (IndexOutOfBoundsException e) {
            bResult = false;
            this.log.println("Array formula hasn't been cleared with setArrayFormula(\"\")");
            XSheetOperation clearRange = UnoRuntime.queryInterface(XSheetOperation.class, (Object)new_range);
            int allFlags = 266;
            allFlags = allFlags | 0x20 | 0x80 | 4;
            allFlags = allFlags | 1 | 0x10 | 0x40;
            clearRange.clearContents(allFlags);
        }
        this.tRes.tested("collapseToCurrentArray()", bResult);
    }

    public void _collapseToCurrentRegion() {
        boolean bResult = true;
        int width = 4;
        int height = 4;
        int leftCol = -1;
        int topRow = -1;
        XSpreadsheet oSheet = this.oObj.getSpreadsheet();
        UnoRuntime.queryInterface(XSheetOperation.class, (Object)oSheet).clearContents(65535);
        this.oObj.collapseToCurrentRegion();
        int cols = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getColumns().getCount();
        int rows = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getRows().getCount();
        if (cols != width || rows != height) {
            bResult = false;
            this.log.println("After collapseToCurrentRegion() call Region must have size " + width + "x" + height + " but it is " + cols + "x" + rows);
        }
        if (bResult && leftCol != -1 && topRow != -1) {
            try {
                oSheet.getCellByPosition(leftCol + width, topRow + height).setValue(1.0);
            }
            catch (IndexOutOfBoundsException e) {
                this.log.print("Can't get cell by position:");
                e.printStackTrace(this.log);
                bResult = false;
            }
            this.oObj.collapseToCurrentRegion();
            cols = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getColumns().getCount();
            rows = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getRows().getCount();
            if (cols == width + 1 && rows == height + 1) {
                bResult &= true;
            } else {
                bResult = false;
                this.log.println("After collapseToCurrentRegion() call [2] region must have size " + (width + 1) + "x" + (height + 1) + " but it is " + cols + "x" + rows);
            }
        }
        this.tRes.tested("collapseToCurrentRegion()", bResult);
        this.oObj.collapseToSize(width, height);
    }

    public void _collapseToMergedArea() {
        int width = 1;
        int height = 1;
        int leftCol = 0;
        int topRow = 0;
        boolean bResult = true;
        this.log.println("DB: Starting collapseToMergedArea() method test ...");
        XSpreadsheet oSheet = this.oObj.getSpreadsheet();
        this.log.println("DB: got Spreadsheet.");
        XCellRange newRange = null;
        try {
            newRange = oSheet.getCellRangeByPosition(leftCol + width - 1, topRow + height - 1, leftCol + width, topRow + height);
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Can't get cell range by position");
            e.printStackTrace(this.log);
            bResult = false;
        }
        XMergeable mergeRange = UnoRuntime.queryInterface(XMergeable.class, newRange);
        if (mergeRange == null) {
            this.log.println("DB: newRange doesn't implement XMergeable interface");
        } else {
            this.log.println("DB: XMergeable interface successfully queried.");
        }
        mergeRange.merge(true);
        this.log.println("DB: Successfuly merged.");
        this.oObj.collapseToMergedArea();
        this.log.println("DB: Succesfully collapseToMergedArea() method called");
        mergeRange.merge(false);
        this.log.println("DB: Successfully unmerged.");
        int cols = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getColumns().getCount();
        int rows = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getRows().getCount();
        this.log.println("DB: Column and row numbers succesfully get");
        if (cols == width + 1 && rows == height + 3) {
            bResult &= true;
        } else {
            bResult = false;
            this.log.println("After collapseToMergedArea() call region must have size " + (width + 1) + "x" + (height + 1) + " but it is " + cols + "x" + rows);
        }
        this.tRes.tested("collapseToMergedArea()", bResult);
        this.oObj.collapseToSize(width, height);
    }

    public void _collapseToSize() {
        boolean bResult = false;
        int width = 1;
        int height = 1;
        this.oObj.collapseToSize(width + 3, height + 3);
        int cols = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getColumns().getCount();
        int rows = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getRows().getCount();
        if (cols == width + 3 && rows == height + 3) {
            bResult = true;
        } else {
            bResult = false;
            this.log.println("After collapseToSize() call region must have size " + (width + 3) + "x" + (height + 3) + " but it is " + cols + "x" + rows);
        }
        this.tRes.tested("collapseToSize()", bResult);
        this.oObj.collapseToSize(width, height);
    }

    public void _expandToEntireColumns() {
        boolean bResult = false;
        int width = 1;
        int height = 1;
        this.oObj.expandToEntireColumns();
        int cols = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getColumns().getCount();
        int rows = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getRows().getCount();
        if (cols == width && rows >= 32000) {
            bResult = true;
        } else {
            bResult = false;
            this.log.println("After expandToEntireColumns() call region must have size " + width + "x(>=32000) but it is " + cols + "x" + rows);
        }
        this.tRes.tested("expandToEntireColumns()", bResult);
        this.oObj.collapseToSize(width, height);
    }

    public void _expandToEntireRows() {
        boolean bResult = false;
        int width = 1;
        int height = 1;
        this.oObj.expandToEntireRows();
        int cols = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getColumns().getCount();
        int rows = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oObj).getRows().getCount();
        if (cols >= 256 && rows == height) {
            bResult = true;
        } else {
            bResult = false;
            this.log.println("After expandToEntireRows() call region must have size (>=256)x" + height + " but it is " + cols + "x" + rows);
        }
        this.tRes.tested("expandToEntireRows()", bResult);
        this.oObj.collapseToSize(width, height);
    }
}

