/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.ValidationType;
import com.sun.star.sheet.XSheetAuditing;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellAddress;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XSheetAuditing
extends MultiMethodTest {
    public XSheetAuditing oObj = null;
    CellAddress address = null;
    CellAddress precedentAddress = null;
    CellAddress dependentAddress = null;
    XCell xAddress = null;
    XCell xPrecedentAddress = null;
    XCell xDependentAddress = null;
    XDrawPage xDrawPage = null;
    int elementCount = 0;

    @Override
    public void before() {
        XSpreadsheet xSheet;
        this.address = (CellAddress)this.tEnv.getObjRelation("XSheetAuditing.CellAddress");
        this.precedentAddress = (CellAddress)this.tEnv.getObjRelation("XSheetAuditing.PrecedentCellAddress");
        this.dependentAddress = (CellAddress)this.tEnv.getObjRelation("XSheetAuditing.DependentCellAddress");
        if (this.address == null || this.precedentAddress == null || this.dependentAddress == null) {
            throw new StatusException(Status.failed("Necessary CellAddress object relations not found."));
        }
        this.xDrawPage = (XDrawPage)this.tEnv.getObjRelation("XSheetAuditing.DrawPage");
        if (this.xDrawPage == null) {
            XDrawPageSupplier oDPS = UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.oObj);
            this.xDrawPage = oDPS.getDrawPage();
        }
        if (this.xDrawPage == null) {
            throw new StatusException(Status.failed("'XSheetAuditing.DrawPage' object relation not found."));
        }
        if (this.xDrawPage.hasElements()) {
            this.elementCount = this.xDrawPage.getCount();
        }
        if ((xSheet = (XSpreadsheet)this.tEnv.getObjRelation("XSheetAuditing.Spreadsheet")) == null) {
            xSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.oObj);
        }
        if (xSheet == null) {
            throw new StatusException(Status.failed("'XSheetAuditing.Spreadsheet' object relation not found."));
        }
        try {
            this.xAddress = xSheet.getCellByPosition(this.address.Column, this.address.Row);
            this.xDependentAddress = xSheet.getCellByPosition(this.dependentAddress.Column, this.dependentAddress.Row);
            this.xPrecedentAddress = xSheet.getCellByPosition(this.precedentAddress.Column, this.precedentAddress.Row);
        }
        catch (IndexOutOfBoundsException e) {
            throw new StatusException(Status.failed("Invalid cell addresses in object relations."));
        }
    }

    public void _clearArrows() {
        this.requiredMethod("hideDependents()");
        boolean erg = false;
        this.oObj.showDependents(this.address);
        this.oObj.showPrecedents(this.address);
        erg = this.hasRightAmountOfShapes(3);
        this.oObj.clearArrows();
        this.tRes.tested("clearArrows()", erg &= this.hasRightAmountOfShapes(0));
    }

    public void _hideDependents() {
        this.requiredMethod("showDependents()");
        this.oObj.hideDependents(this.address);
        this.tRes.tested("hideDependents()", this.hasRightAmountOfShapes(0));
    }

    public void _hidePrecedents() {
        this.requiredMethod("showPrecedents()");
        this.oObj.hidePrecedents(this.address);
        this.tRes.tested("hidePrecedents()", this.hasRightAmountOfShapes(0));
    }

    public void _showDependents() {
        this.requiredMethod("hidePrecedents()");
        this.oObj.showDependents(this.address);
        this.tRes.tested("showDependents()", this.hasRightAmountOfShapes(1));
    }

    public void _showErrors() {
        this.requiredMethod("clearArrows()");
        this.xPrecedentAddress.setValue(-9.0);
        String cellAddress = new String(new byte[]{(byte)(this.precedentAddress.Column + 65)}) + (this.precedentAddress.Row + 1);
        this.xAddress.setFormula("=SQRT(" + cellAddress + ")");
        XText xText = UnoRuntime.queryInterface(XText.class, (Object)this.xAddress);
        String error = xText.getString();
        boolean erg = error.equals("Err:502");
        this.log.println("Content: " + error);
        this.oObj.showErrors(this.dependentAddress);
        this.tRes.tested("showErrors()", erg &= this.hasRightAmountOfShapes(2));
    }

    public void _showInvalid() {
        this.requiredMethod("showErrors()");
        boolean result = true;
        this.xAddress.setValue(2.5);
        try {
            XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xAddress);
            Object o = xPropertySet.getPropertyValue("Validation");
            XPropertySet xValidation = UnoRuntime.queryInterface(XPropertySet.class, o);
            xValidation.setPropertyValue("Type", ValidationType.WHOLE);
            xPropertySet.setPropertyValue("Validation", xValidation);
            this.oObj.showInvalid();
            result = this.hasRightAmountOfShapes(1);
            this.oObj.clearArrows();
            result &= this.hasRightAmountOfShapes(0);
            xValidation.setPropertyValue("Type", ValidationType.ANY);
            xPropertySet.setPropertyValue("Validation", xValidation);
            this.oObj.showInvalid();
            result &= this.hasRightAmountOfShapes(0);
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("showInvalid()", result);
    }

    public void _showPrecedents() {
        this.oObj.showPrecedents(this.address);
        this.tRes.tested("showPrecedents()", this.hasRightAmountOfShapes(2));
    }

    private boolean hasRightAmountOfShapes(int desiredValue) {
        int newCount = this.xDrawPage.getCount();
        if (newCount != this.elementCount + desiredValue) {
            return false;
        }
        if (desiredValue >= 0) {
            for (int i = this.elementCount; i < newCount; ++i) {
                try {
                    Object o = this.xDrawPage.getByIndex(i);
                    XShape xShape = UnoRuntime.queryInterface(XShape.class, o);
                    System.out.println("Shape Type: " + xShape.getShapeType());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

