/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.RangeSelectionEvent;
import com.sun.star.sheet.XRangeSelection;
import com.sun.star.sheet.XRangeSelectionChangeListener;
import com.sun.star.sheet.XRangeSelectionListener;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.AccessibilityTools;
import util.utils;

public class _XRangeSelection
extends MultiMethodTest {
    public XRangeSelection oObj = null;
    MyRangeSelectionListener aListener = null;

    @Override
    public void before() {
        this.aListener = new MyRangeSelectionListener(this.log);
        XModel xModel = (XModel)this.tEnv.getObjRelation("FirstModel");
        if (xModel == null) {
            throw new StatusException(Status.failed("Object relation FirstModel' not set."));
        }
        XWindow xWindow = xModel.getCurrentController().getFrame().getContainerWindow();
        XTopWindow xTopWindow = UnoRuntime.queryInterface(XTopWindow.class, (Object)xWindow);
        xTopWindow.toFront();
        utils.shortWait(500);
    }

    public void _abortRangeSelection() {
        this.requiredMethod("removeRangeSelectionChangeListener()");
        this.requiredMethod("removeRangeSelectionListener()");
        this.oObj.abortRangeSelection();
        this.tRes.tested("abortRangeSelection()", true);
    }

    public void _addRangeSelectionChangeListener() {
        this.oObj.addRangeSelectionChangeListener(this.aListener);
        this.tRes.tested("addRangeSelectionChangeListener()", true);
    }

    public void _addRangeSelectionListener() {
        this.oObj.addRangeSelectionListener(this.aListener);
        this.tRes.tested("addRangeSelectionListener()", true);
    }

    public void _removeRangeSelectionChangeListener() {
        this.oObj.removeRangeSelectionChangeListener(this.aListener);
        this.tRes.tested("removeRangeSelectionChangeListener()", true);
    }

    public void _removeRangeSelectionListener() {
        this.oObj.removeRangeSelectionListener(this.aListener);
        this.tRes.tested("removeRangeSelectionListener()", true);
    }

    public void _startRangeSelection() {
        this.requiredMethod("addRangeSelectionChangeListener()");
        this.requiredMethod("addRangeSelectionListener()");
        Point center = this.getSheetCenter();
        if (center == null) {
            throw new StatusException(Status.failed("Couldn't get the sheet center."));
        }
        PropertyValue[] props = new PropertyValue[3];
        props[0] = new PropertyValue();
        props[0].Name = "InitialValue";
        props[0].Value = "B3:D5";
        props[1] = new PropertyValue();
        props[1].Name = "Title";
        props[1].Value = "the title";
        props[2] = new PropertyValue();
        props[2].Name = "CloseOnMouseRelease";
        props[2].Value = Boolean.FALSE;
        this.oObj.startRangeSelection(props);
        utils.shortWait(1000);
        Point closer = this.getCloser(center);
        if (closer == null) {
            throw new StatusException(Status.failed("Couldn't get the close Button."));
        }
        this.clickOnSheet(center);
        utils.shortWait(5000);
        this.clickOnSheet(closer);
        utils.shortWait(5000);
        props[0].Value = "C4:E6";
        this.oObj.startRangeSelection(props);
        utils.shortWait(1000);
        props[0].Value = "C2:E3";
        this.oObj.startRangeSelection(props);
        utils.shortWait(1000);
        this.oObj.startRangeSelection(props);
        utils.shortWait(1000);
        this.oObj.abortRangeSelection();
        this.aListener.reset();
        System.out.println("Listener called: " + this.aListener.bAbortCalled);
        this.tRes.tested("startRangeSelection()", this.aListener.listenerCalled());
    }

    protected Point getSheetCenter() {
        this.log.println("Trying to get AccessibleSpreadsheet");
        AccessibilityTools at = new AccessibilityTools();
        XComponent xSheetDoc = (XComponent)this.tEnv.getObjRelation("DOCUMENT");
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)xSheetDoc);
        System.out.println("Name: " + xModel.getCurrentController().getFrame().getName());
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)this.tParam.getMSF(), xModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)58);
        XAccessibleComponent AccessibleSpreadsheet = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)AccessibilityTools.SearchedContext);
        this.log.println("Got " + utils.getImplName(AccessibleSpreadsheet));
        Object toolkit = null;
        try {
            toolkit = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            this.log.println("Couldn't get toolkit");
            e.printStackTrace(this.log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, toolkit);
        XTopWindow tw = null;
        int k = tk.getTopWindowCount();
        for (int i = 0; i < k; ++i) {
            try {
                XTopWindow tw_temp = tk.getTopWindow(i);
                XAccessible xacc = UnoRuntime.queryInterface(XAccessible.class, (Object)tw_temp);
                if (xacc != null) {
                    if (xacc.getAccessibleContext().getAccessibleName().indexOf("d2") <= 0) continue;
                    tw = tw_temp;
                    continue;
                }
                this.log.println("\t unknown window");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (tw == null) {
            System.out.println("No TopWindow :-(");
            return null;
        }
        Point point = AccessibleSpreadsheet.getLocationOnScreen();
        Rectangle rect = AccessibleSpreadsheet.getBounds();
        Point retPoint = new Point();
        retPoint.X = point.X + rect.Width / 2;
        retPoint.Y = point.Y + rect.Height / 2;
        return retPoint;
    }

    private Point getCloser(Point center) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)this.tParam.getMSF();
        Object aToolkit = null;
        try {
            aToolkit = xMSF.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            throw new StatusException("Could not create 'com.sun.star.awt.Toolkit'.", e);
        }
        XExtendedToolkit xExtendedToolkit = UnoRuntime.queryInterface(XExtendedToolkit.class, aToolkit);
        AccessibilityTools accTools = new AccessibilityTools();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)xExtendedToolkit.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        XTopWindow tw = null;
        XAccessibleComponent xAccessibleComponent = null;
        int k = xExtendedToolkit.getTopWindowCount();
        for (int i = 0; i < k; ++i) {
            try {
                XTopWindow tw_temp = xExtendedToolkit.getTopWindow(i);
                XAccessible xacc = UnoRuntime.queryInterface(XAccessible.class, (Object)tw_temp);
                if (xacc != null) {
                    System.out.println("Name: " + xacc.getAccessibleContext().getAccessibleName());
                    if (!xacc.getAccessibleContext().getAccessibleName().startsWith("the title")) continue;
                    tw = tw_temp;
                    XAccessibleContext xContext = xacc.getAccessibleContext();
                    xAccessibleComponent = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xContext);
                    if (xAccessibleComponent == null) {
                        System.out.println("!!!! MIST !!!!");
                        continue;
                    }
                    System.out.println("########## KLAPPT ########## ");
                    continue;
                }
                this.log.println("\t unknown window");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (tw == null) {
            System.out.println("No TopWindow :-(");
            return null;
        }
        xWindow = UnoRuntime.queryInterface(XWindow.class, tw);
        Rectangle posSize = xWindow.getPosSize();
        boolean windowOK = false;
        while (!windowOK) {
            if (posSize.X <= center.X && center.X <= posSize.X + posSize.Width) {
                if (posSize.Y <= center.Y && center.Y <= posSize.Y + posSize.Height) {
                    posSize.X += 10;
                    posSize.Y += 10;
                    xWindow.setPosSize(posSize.X, posSize.Y, posSize.Width, posSize.Height, (short)3);
                    continue;
                }
                windowOK = true;
                continue;
            }
            windowOK = true;
        }
        Point p = xAccessibleComponent.getLocationOnScreen();
        Point closer = new Point();
        closer.X = p.X + posSize.Width - 2;
        closer.Y = p.Y + 5;
        System.out.println("Closer: " + closer.X + "   " + closer.Y);
        return closer;
    }

    protected boolean clickOnSheet(Point point) {
        this.log.println("Clicking in the center of the AccessibleSpreadsheet");
        try {
            Robot rob = new Robot();
            rob.mouseMove(point.X, point.Y);
            rob.mousePress(16);
            utils.shortWait(1000);
            rob.mouseRelease(16);
            utils.shortWait(1000);
        }
        catch (AWTException e) {
            this.log.println("couldn't press mouse button");
        }
        return true;
    }

    public static class MyRangeSelectionListener
    implements XRangeSelectionListener,
    XRangeSelectionChangeListener {
        boolean bAbortCalled = false;
        boolean bChangeCalled = false;
        boolean bDoneCalled = false;
        PrintWriter log = null;

        public MyRangeSelectionListener(PrintWriter log) {
            this.log = log;
        }

        @Override
        public void aborted(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'aborted' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bAbortCalled = true;
        }

        @Override
        public void descriptorChanged(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'descriptorChanged' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bChangeCalled = true;
        }

        @Override
        public void done(RangeSelectionEvent rangeSelectionEvent) {
            this.log.println("Called 'done' with: " + rangeSelectionEvent.RangeDescriptor);
            this.bDoneCalled = true;
        }

        public boolean listenerCalled() {
            return this.bAbortCalled & this.bChangeCalled & this.bDoneCalled;
        }

        public void reset() {
            this.bAbortCalled = false;
            this.bChangeCalled = false;
            this.bDoneCalled = false;
        }

        @Override
        public void disposing(EventObject eventObject) {
        }
    }
}

