/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.Border;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XCellRangeReferrer;
import com.sun.star.sheet.XNamedRanges;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.util.Random;
import java.util.StringTokenizer;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XNamedRanges
extends MultiMethodTest {
    public XNamedRanges oObj = null;
    String name = "_XNamedRanges";
    XSpreadsheet oSheet = null;

    @Override
    protected void before() {
        this.oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (this.oSheet == null) {
            throw new StatusException(Status.failed("Relation 'SHEET' not found"));
        }
    }

    public void _addNewByName() {
        boolean bResult = true;
        CellAddress aPosition = new CellAddress(0, 2, 2);
        int nType = this.getRandomType();
        String sContent = this.getRandomContent("D3;A6:B9;=F12");
        this.name = this.name + sContent;
        this.log.println("Adding new range with name=\"" + this.name + "\", sContent = \"" + sContent + "\", aPosition = (" + aPosition.Sheet + ", " + aPosition.Column + ", " + aPosition.Row + "), Type = " + nType + ".");
        this.oObj.addNewByName(this.name, sContent, aPosition, nType);
        CellAddress listOutputPosition = new CellAddress(0, 1, 1);
        this.oObj.outputList(listOutputPosition);
        String s = null;
        String s1 = null;
        try {
            s = this.oSheet.getCellByPosition(1, 1).getFormula();
            s1 = this.oSheet.getCellByPosition(2, 1).getFormula();
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Can't get cell by position: " + e);
            bResult = false;
        }
        this.log.println("Outputlist returns: " + s + " " + s1);
        this.tRes.tested("addNewByName()", bResult &= this.oObj.hasByName(this.name));
    }

    public void _addNewFromTitles() {
        boolean bResult = true;
        this.log.println("Creating a small table.");
        try {
            CellRangeAddress objCRA;
            XCellRangeAddressable xCRA;
            XCellRange CR;
            XCellRangeReferrer CRR;
            Object range;
            int i;
            int i2;
            XCell cell = null;
            XTextRange textrange = null;
            for (i2 = 1; i2 < 4; ++i2) {
                cell = this.oSheet.getCellByPosition(0, i2);
                textrange = UnoRuntime.queryInterface(XTextRange.class, (Object)cell);
                textrange.setString("Row" + i2);
                cell = this.oSheet.getCellByPosition(i2, 0);
                textrange = UnoRuntime.queryInterface(XTextRange.class, (Object)cell);
                textrange.setString("Column" + i2);
            }
            for (i2 = 1; i2 < 4; ++i2) {
                for (int j = 1; j < 4; ++j) {
                    cell = this.oSheet.getCellByPosition(i2, j);
                    textrange = UnoRuntime.queryInterface(XTextRange.class, (Object)cell);
                    textrange.setString("Val" + ((j - 1) * 3 + i2));
                }
            }
            this.log.println("Finished creating table.");
            this.log.println("Creating new ranges from titles");
            CellRangeAddress CRA = new CellRangeAddress(0, 0, 0, 3, 3);
            Border border = Border.TOP;
            this.oObj.addNewFromTitles(CRA, border);
            for (i = 1; i < 4; ++i) {
                bResult &= this.oObj.hasByName("Column" + i);
                range = this.oObj.getByName("Column" + i);
                CRR = UnoRuntime.queryInterface(XCellRangeReferrer.class, range);
                CR = CRR.getReferredCells();
                xCRA = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)CR);
                objCRA = xCRA.getRangeAddress();
                bResult &= objCRA.EndColumn == i && objCRA.StartColumn == i;
                bResult &= objCRA.StartRow == 1;
                bResult &= objCRA.EndRow == 3;
                bResult &= objCRA.Sheet == 0;
            }
            border = Border.LEFT;
            this.oObj.addNewFromTitles(CRA, border);
            for (i = 1; i < 4; ++i) {
                bResult &= this.oObj.hasByName("Row" + i);
                range = this.oObj.getByName("Row" + i);
                CRR = UnoRuntime.queryInterface(XCellRangeReferrer.class, range);
                CR = CRR.getReferredCells();
                xCRA = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)CR);
                objCRA = xCRA.getRangeAddress();
                bResult &= objCRA.EndRow == i && objCRA.StartRow == i;
                bResult &= objCRA.StartColumn == 1;
                bResult &= objCRA.EndColumn == 3;
                bResult &= objCRA.Sheet == 0;
            }
            this.oObj.outputList(new CellAddress(0, 5, 5));
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            bResult = false;
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(this.log);
            bResult = false;
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(this.log);
            bResult = false;
        }
        this.tRes.tested("addNewFromTitles()", bResult);
    }

    public void _outputList() {
        boolean bResult = true;
        CellAddress CA = new CellAddress(0, 0, 0);
        XIndexAccess IA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.oObj);
        int elementsCount = IA.getCount();
        this.oObj.outputList(CA);
        try {
            for (int i = 0; i < elementsCount; ++i) {
                XCell cell = this.oSheet.getCellByPosition(0, i);
                XTextRange textrange = UnoRuntime.queryInterface(XTextRange.class, (Object)cell);
                String str = textrange.getString();
                bResult &= this.oObj.hasByName(str);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            bResult = false;
        }
        this.tRes.tested("outputList()", bResult);
    }

    public void _removeByName() {
        this.requiredMethod("addNewByName()");
        boolean bResult = true;
        XIndexAccess IA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.oObj);
        int elementsCount = IA.getCount();
        this.oObj.removeByName(this.name);
        bResult = elementsCount == IA.getCount() + 1;
        try {
            this.oObj.removeByName(this.name);
            this.log.println("Exception expected when removed unexistent element!");
            bResult = false;
        }
        catch (RuntimeException e) {
            this.log.println("Expected exception occured while testingremoveByName() when removed unexistent element.");
        }
        this.tRes.tested("removeByName()", bResult);
    }

    String getRandomContent(String str) {
        String gRS = "none";
        Random rnd = new Random();
        StringTokenizer ST = new StringTokenizer(str, ";");
        int nr = rnd.nextInt(ST.countTokens());
        if (nr < 1) {
            ++nr;
        }
        for (int i = 1; i < nr + 1; ++i) {
            gRS = ST.nextToken();
        }
        return gRS;
    }

    int getRandomType() {
        int[] types = new int[]{0, 4, 1, 2, 8};
        Random rnd = new Random();
        return types[rnd.nextInt(5)];
    }
}

