/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.awt.Point;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.TableOperationMode;
import com.sun.star.sheet.XCellAddressable;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XMultipleOperation;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XMultipleOperation
extends MultiMethodTest {
    public XMultipleOperation oObj = null;
    protected XSpreadsheet oSheet = null;
    boolean both = true;

    @Override
    protected void before() {
        this.oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (this.oSheet == null) {
            throw new StatusException(Status.failed("Object relation oSheet is missing"));
        }
        if (UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.tEnv.getTestObject()) != null) {
            this.log.println("We have a sheet and won't do TableOperationMode.BOTH");
            this.both = false;
        }
    }

    public void _setTableOperation() {
        boolean res = true;
        XCellRange cellRange = this.oSheet.getCellRangeByName("$A$17:$A$17");
        XCellRangeAddressable CRA = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)cellRange);
        XCell cell = null;
        XCell cell2 = null;
        try {
            cell = this.oSheet.getCellByPosition(0, 16);
            cell.setFormula("=a15+a16");
            cell = this.oSheet.getCellByPosition(0, 14);
            cell2 = this.oSheet.getCellByPosition(0, 15);
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Exception while getting Cell " + e.getMessage());
        }
        XCellAddressable CA = UnoRuntime.queryInterface(XCellAddressable.class, (Object)cell);
        XCellAddressable CA2 = UnoRuntime.queryInterface(XCellAddressable.class, (Object)cell2);
        Point[] cellCoords = new Point[3];
        double[] cellValues = new double[3];
        this.log.println("filling cells");
        this.fillCells();
        this.log.println("setting TableOperation with parameter ROW");
        this.oObj.setTableOperation(CRA.getRangeAddress(), TableOperationMode.ROW, CA.getCellAddress(), CA2.getCellAddress());
        this.log.println("checking values");
        cellCoords = new Point[]{new Point(1, 1), new Point(2, 1), new Point(3, 1)};
        cellValues = new double[]{5.0, 10.0, 15.0};
        res &= this.checkValues(cellCoords, cellValues);
        this.log.println("filling cells");
        this.fillCells();
        this.log.println("setting TableOperation with parameter COLUMN");
        this.oObj.setTableOperation(CRA.getRangeAddress(), TableOperationMode.COLUMN, CA.getCellAddress(), CA2.getCellAddress());
        this.log.println("checking values");
        cellCoords = new Point[]{new Point(1, 1), new Point(1, 2), new Point(1, 3)};
        cellValues = new double[]{12.0, 24.0, 36.0};
        res &= this.checkValues(cellCoords, cellValues);
        if (this.both) {
            this.log.println("filling cells");
            this.fillCells();
            this.log.println("setting TableOperation with parameter BOTH");
            this.oObj.setTableOperation(CRA.getRangeAddress(), TableOperationMode.BOTH, CA.getCellAddress(), CA2.getCellAddress());
            this.log.println("checking values");
            cellCoords = new Point[]{new Point(1, 1), new Point(2, 2), new Point(3, 3)};
            cellValues = new double[]{17.0, 34.0, 51.0};
            res &= this.checkValues(cellCoords, cellValues);
        }
        this.tRes.tested("setTableOperation()", res);
    }

    protected void fillCells() {
        XCell cell = null;
        try {
            for (int k = 1; k < 5; ++k) {
                cell = this.oSheet.getCellByPosition(0, k);
                cell.setValue(k * 12);
                cell = this.oSheet.getCellByPosition(k, 0);
                cell.setValue(k * 5);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Exception while filling Cells " + e.getMessage());
        }
    }

    protected boolean checkValues(Point[] cellCoords, double[] cellValues) {
        boolean res = true;
        for (int i = 0; i < cellValues.length; ++i) {
            try {
                boolean locres = this.oSheet.getCellByPosition(cellCoords[i].X, cellCoords[i].Y).getValue() == cellValues[i];
                res &= locres;
                if (locres) continue;
                this.log.println("Result differs for cell (" + cellCoords[i].X + "," + cellCoords[i].Y + ")");
                this.log.println("Expected: " + cellValues[i]);
                this.log.println("Getting: " + this.oSheet.getCellByPosition(cellCoords[i].X, cellCoords[i].Y).getValue());
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Exception while checking Values " + e.getMessage());
                res &= false;
            }
        }
        return res;
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

