/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.GoalResult;
import com.sun.star.sheet.XGoalSeek;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XGoalSeek
extends MultiMethodTest {
    public XGoalSeek oObj = null;
    XSpreadsheet xSheet = null;
    CellAddress aFormula = null;
    CellAddress aValue = null;

    @Override
    public void before() {
        Exception ex = null;
        try {
            XSpreadsheetDocument xSpreadsheetDocument = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)this.oObj);
            XSpreadsheets oSheets = xSpreadsheetDocument.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            this.xSheet = UnoRuntime.queryInterface(XSpreadsheet.class, oIndexSheets.getByIndex(1));
        }
        catch (IndexOutOfBoundsException e) {
            ex = e;
        }
        catch (WrappedTargetException e) {
            ex = e;
        }
        catch (NullPointerException e) {
            ex = e;
        }
        if (ex != null) {
            throw new StatusException("Could not get a sheet.", ex);
        }
        try {
            this.xSheet.getCellByPosition(3, 4).setValue(9.0);
            this.xSheet.getCellByPosition(3, 5).setFormula("= SQRT(D5)");
            this.aValue = new CellAddress(1, 3, 4);
            this.aFormula = new CellAddress(1, 3, 5);
        }
        catch (Exception e) {
            throw new StatusException("Could not get set formulas on the sheet.", e);
        }
    }

    public void _seekGoal() {
        boolean result = true;
        double divergence = 0.01;
        GoalResult goal = this.oObj.seekGoal(this.aFormula, this.aValue, "4");
        this.log.println("Goal Result: " + goal.Result + "   Divergence: " + goal.Divergence);
        result &= goal.Divergence < divergence;
        result &= goal.Result > 16.0 - divergence || goal.Result < 16.0 + divergence;
        goal = this.oObj.seekGoal(this.aFormula, this.aValue, "-4");
        this.log.println("Goal Result: " + goal.Result + "   Divergence: " + goal.Divergence);
        result &= goal.Divergence > 1.0 / divergence;
        result &= goal.Result < divergence || goal.Result > -divergence;
        try {
            this.xSheet.getCellByPosition(3, 4).setValue(0.8);
            this.xSheet.getCellByPosition(3, 5).setFormula("= (D5 ^ 2 - 1) / (D5 - 1)");
        }
        catch (Exception e) {
            // empty catch block
        }
        goal = this.oObj.seekGoal(this.aFormula, this.aValue, "2");
        this.log.println("Goal Result: " + goal.Result + "   Divergence: " + goal.Divergence);
        result &= goal.Divergence < divergence;
        this.tRes.tested("seekGoal()", result &= goal.Result > 16.0 - divergence || goal.Result < 16.0 + divergence);
    }
}

