/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.XFormulaQuery;
import com.sun.star.sheet.XSheetCellRanges;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XFormulaQuery
extends MultiMethodTest {
    public XFormulaQuery oObj;
    protected XSpreadsheet oSheet = null;
    private XCell mxCell;
    private int miQueryThisDependentRange = 1;
    private int miQueryThisPrecedentRange = 1;
    private int[] miExpectedDependentValues;
    private int[] miExpectedPrecedentValues;

    @Override
    protected void before() {
        Object o;
        this.oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (this.oSheet == null) {
            this.log.println("Object relation oSheet is missing");
            this.log.println("Trying to query the needed Interface");
            this.oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.tEnv.getTestObject());
            if (this.oSheet == null) {
                throw new StatusException(Status.failed("Object relation oSheet is missing"));
            }
        }
        if ((o = this.tEnv.getObjRelation("MAKEENTRYINCELL")) != null) {
            this.mxCell = (XCell)o;
        } else {
            try {
                this.mxCell = this.oSheet.getCellByPosition(15, 15);
            }
            catch (IndexOutOfBoundsException e) {
                throw new StatusException(Status.failed("Couldn't get initial cell"));
            }
        }
        o = this.tEnv.getObjRelation("RANGEINDICES");
        if (o != null) {
            int[] index = (int[])o;
            this.miQueryThisDependentRange = index[0];
            this.miQueryThisPrecedentRange = index[1];
        }
        if ((o = this.tEnv.getObjRelation("EXPECTEDDEPENDENTVALUES")) != null) {
            this.miExpectedDependentValues = (int[])o;
        } else {
            this.miExpectedDependentValues = new int[4];
            this.miExpectedDependentValues[0] = 15;
            this.miExpectedDependentValues[1] = 15;
            this.miExpectedDependentValues[2] = 15;
            this.miExpectedDependentValues[3] = 15;
        }
        o = this.tEnv.getObjRelation("EXPECTEDPRECEDENTVALUES");
        if (o != null) {
            this.miExpectedPrecedentValues = (int[])o;
        } else {
            this.miExpectedPrecedentValues = new int[4];
            this.miExpectedPrecedentValues[0] = 0;
            this.miExpectedPrecedentValues[1] = 0;
            this.miExpectedPrecedentValues[2] = 15;
            this.miExpectedPrecedentValues[3] = 15;
        }
    }

    public void _queryDependents() {
        boolean res = true;
        try {
            this.mxCell.setFormula("=sum(A1:D1)");
            this.oSheet.getCellByPosition(0, 0).setValue(1.0);
            this.oSheet.getCellByPosition(1, 0).setValue(1.0);
            this.oSheet.getCellByPosition(2, 0).setValue(1.0);
            this.oSheet.getCellByPosition(3, 0).setValue(1.0);
            this.log.println("calling oObj.queryDependents(false)");
            XSheetCellRanges getting = this.oObj.queryDependents(false);
            CellRangeAddress[] range = getting.getRangeAddresses();
            boolean bl = res = range[this.miQueryThisDependentRange].StartColumn == this.miExpectedDependentValues[0] && range[this.miQueryThisDependentRange].EndColumn == this.miExpectedDependentValues[1] && range[this.miQueryThisDependentRange].StartRow == this.miExpectedDependentValues[2] && range[this.miQueryThisDependentRange].EndRow == this.miExpectedDependentValues[3];
            if (!res) {
                this.log.println("Getting (" + range[this.miQueryThisDependentRange].StartColumn + "," + range[this.miQueryThisDependentRange].EndColumn + "," + range[this.miQueryThisDependentRange].StartRow + "," + range[this.miQueryThisDependentRange].EndRow + ")");
                this.log.println("Expected (" + this.miExpectedDependentValues[0] + "," + this.miExpectedDependentValues[1] + "," + this.miExpectedDependentValues[2] + "," + this.miExpectedDependentValues[3] + ")");
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Couldn't set initial version to cell");
            res = false;
        }
        this.tRes.tested("queryDependents()", res);
    }

    public void _queryPrecedents() {
        boolean res = true;
        try {
            this.mxCell.setFormula("=sum(A1:D1)");
            this.oSheet.getCellByPosition(0, 0).setValue(1.0);
            this.oSheet.getCellByPosition(1, 0).setValue(1.0);
            this.oSheet.getCellByPosition(2, 0).setValue(1.0);
            this.oSheet.getCellByPosition(3, 0).setValue(1.0);
            this.oSheet.getCellByPosition(1, 2).setFormula("=A16*2");
            this.log.println("calling oObj.queryPrecedents(false)");
            XSheetCellRanges getting = this.oObj.queryPrecedents(false);
            CellRangeAddress[] range = getting.getRangeAddresses();
            boolean bl = res = range[this.miQueryThisPrecedentRange].StartColumn == this.miExpectedPrecedentValues[0] && range[this.miQueryThisPrecedentRange].EndColumn == this.miExpectedPrecedentValues[1] && range[this.miQueryThisPrecedentRange].StartRow == this.miExpectedPrecedentValues[2] && range[this.miQueryThisPrecedentRange].EndRow == this.miExpectedPrecedentValues[3];
            if (!res) {
                this.log.println("Getting (" + range[this.miQueryThisPrecedentRange].StartColumn + "," + range[this.miQueryThisPrecedentRange].EndColumn + "," + range[this.miQueryThisPrecedentRange].StartRow + "," + range[this.miQueryThisPrecedentRange].EndRow + ")");
                this.log.println("Expected (" + this.miExpectedPrecedentValues[0] + "," + this.miExpectedPrecedentValues[1] + "," + this.miExpectedPrecedentValues[2] + "," + this.miExpectedPrecedentValues[3] + ")");
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Couldn't set initial version to cell");
            res = false;
        }
        this.tRes.tested("queryPrecedents()", res);
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

