/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.EnhancedMouseEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XEnhancedMouseClickHandler;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XEnhancedMouseClickBroadcaster;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import util.AccessibilityTools;
import util.DesktopTools;

public class _XEnhancedMouseClickBroadcaster
extends MultiMethodTest {
    public XEnhancedMouseClickBroadcaster oObj;
    protected boolean mousePressed = false;
    protected boolean mouseReleased = false;
    protected XEnhancedMouseClickHandler listener = new MyListener();
    private XModel docModel = null;

    @Override
    public void before() {
        this.docModel = UnoRuntime.queryInterface(XModel.class, this.tEnv.getObjRelation("FirstModel"));
        DesktopTools.bringWindowToFront(this.docModel);
    }

    public void _addEnhancedMouseClickHandler() {
        this.oObj.addEnhancedMouseClickHandler(this.listener);
        this.clickOnSheet();
        if (!this.mousePressed || !this.mouseReleased) {
            this.oObj.removeEnhancedMouseClickHandler(this.listener);
        }
        this.tRes.tested("addEnhancedMouseClickHandler()", this.mousePressed && this.mouseReleased);
    }

    public void _removeEnhancedMouseClickHandler() {
        this.requiredMethod("addEnhancedMouseClickHandler()");
        this.mousePressed = false;
        this.mouseReleased = false;
        this.oObj.removeEnhancedMouseClickHandler(this.listener);
        this.clickOnSheet();
        this.tRes.tested("removeEnhancedMouseClickHandler()", !this.mousePressed && !this.mouseReleased);
    }

    protected boolean clickOnSheet() {
        this.log.println("try to open contex menu...");
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)this.tParam.getMSF(), this.docModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        XAccessibleContext oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)40);
        XAccessibleComponent window = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        Point point = window.getLocationOnScreen();
        Rectangle rect = window.getBounds();
        this.log.println("klick mouse button...");
        try {
            Robot rob = new Robot();
            int x = point.X + rect.Width / 2 + 50;
            int y = point.Y + rect.Height / 2 + 50;
            rob.mouseMove(x, y);
            System.out.println("Press Button");
            rob.mousePress(4);
            System.out.println("Release Button");
            rob.mouseRelease(4);
            System.out.println("done");
            System.out.println("warte");
            this.shortWait();
            System.out.println("Press Button");
            rob.mousePress(16);
            System.out.println("Release Button");
            rob.mouseRelease(16);
            System.out.println("done " + rob.getAutoDelay());
        }
        catch (AWTException e) {
            this.log.println("couldn't press mouse button");
        }
        return true;
    }

    private void shortWait() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }

    protected class MyListener
    implements XEnhancedMouseClickHandler {
        protected MyListener() {
        }

        @Override
        public void disposing(EventObject eventObject) {
        }

        @Override
        public boolean mousePressed(EnhancedMouseEvent enhancedMouseEvent) {
            _XEnhancedMouseClickBroadcaster.this.log.println("mousePressed");
            _XEnhancedMouseClickBroadcaster.this.mousePressed = true;
            return true;
        }

        @Override
        public boolean mouseReleased(EnhancedMouseEvent enhancedMouseEvent) {
            _XEnhancedMouseClickBroadcaster.this.log.println("mouseReleased");
            _XEnhancedMouseClickBroadcaster.this.mouseReleased = true;
            return true;
        }
    }
}

