/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.awt.Point;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XDocumentAuditing;
import com.sun.star.sheet.XSheetAuditing;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDocumentAuditing
extends MultiMethodTest {
    public XDocumentAuditing oObj = null;
    XDrawPage xDrawPage = null;
    XSpreadsheet[] xSheet = null;
    int elementCount = 0;
    String sheetName = null;
    Point pos = null;

    @Override
    public void before() {
        Exception ex = null;
        this.xSheet = new XSpreadsheet[2];
        try {
            XSpreadsheet oSheet;
            XSpreadsheetDocument xSpreadsheetDocument = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)this.oObj);
            XSpreadsheets oSheets = xSpreadsheetDocument.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            this.xSheet[0] = oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, oIndexSheets.getByIndex(0));
            this.xSheet[1] = oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, oIndexSheets.getByIndex(1));
        }
        catch (IndexOutOfBoundsException e) {
            ex = e;
        }
        catch (WrappedTargetException e) {
            ex = e;
        }
        catch (NullPointerException e) {
            ex = e;
        }
        if (ex != null) {
            throw new StatusException("Could not get two sheets.", ex);
        }
        this.xDrawPage = (XDrawPage)this.tEnv.getObjRelation("XDocumentAuditing.DrawPage");
        if (this.xDrawPage == null) {
            try {
                XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.oObj);
                Object o = oDPS.getDrawPages().getByIndex(1);
                this.xDrawPage = UnoRuntime.queryInterface(XDrawPage.class, o);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (WrappedTargetException e) {
                // empty catch block
            }
        }
        if (this.xDrawPage == null) {
            throw new StatusException(Status.failed("'XSheetAuditing.DrawPage' object relation not found."));
        }
        if (this.xDrawPage.hasElements()) {
            this.elementCount = this.xDrawPage.getCount();
        }
        PropertyValue[] props = new PropertyValue[]{new PropertyValue()};
        props[0].Name = "AutoRefreshArrows";
        props[0].Value = Boolean.FALSE;
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)this.oObj);
        this.dispatch(xModel.getCurrentController().getFrame(), (XMultiServiceFactory)this.tParam.getMSF(), ".uno:AutoRefreshArrows", props);
        try {
            this.xSheet[0].getCellByPosition(6, 6).setValue(9.0);
            XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, (Object)this.xSheet[0]);
            this.sheetName = xNamed.getName();
            this.xSheet[1].getCellByPosition(6, 6).setValue(16.0);
            this.xSheet[1].getCellByPosition(6, 7).setFormula("= SQRT(G7)");
            XSheetAuditing xSheetAuditing = UnoRuntime.queryInterface(XSheetAuditing.class, (Object)this.xSheet[1]);
            CellAddress add = new CellAddress(1, 6, 7);
            xSheetAuditing.showPrecedents(add);
            boolean ok = this.hasRightAmountOfShapes(1);
            if (!ok) {
                throw new StatusException(Status.failed("Wrong amount of shapes on page."));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new StatusException("Could not set formulas on sheets.", e);
        }
    }

    @Override
    public void after() {
        PropertyValue[] props = new PropertyValue[]{new PropertyValue()};
        props[0].Name = "AutoRefreshArrows";
        props[0].Value = Boolean.TRUE;
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)this.oObj);
        this.dispatch(xModel.getCurrentController().getFrame(), (XMultiServiceFactory)this.tParam.getMSF(), ".uno:AutoRefreshArrows", props);
    }

    public void _refreshArrows() {
        boolean result = true;
        Point p0 = this.pos;
        try {
            result &= this.xSheet[1].getCellByPosition(6, 7).getValue() == 4.0;
            this.xSheet[1].getCellByPosition(6, 7).setFormula("= SQRT(" + this.sheetName + ".G7)");
            result &= this.xSheet[1].getCellByPosition(6, 7).getValue() == 3.0;
        }
        catch (IndexOutOfBoundsException e) {
            throw new StatusException("Could not set formulas on sheets.", e);
        }
        result &= this.hasRightAmountOfShapes(1);
        Point p1 = this.pos;
        boolean res = p0.X == p1.X && p0.Y == p1.Y;
        result &= res;
        if (!res) {
            this.log.println("Arrow has been refreshed, but this should have been switched off.");
        }
        this.oObj.refreshArrows();
        result &= this.hasRightAmountOfShapes(1);
        Point p2 = this.pos;
        res = p1.X != p2.X || p1.Y != p2.Y;
        result &= res;
        if (!res) {
            this.log.println("Arrow has not been refreshed.");
        }
        this.tRes.tested("refreshArrows()", result);
    }

    private boolean hasRightAmountOfShapes(int desiredValue) {
        int newCount = this.xDrawPage.getCount();
        if (newCount != this.elementCount + desiredValue) {
            return false;
        }
        if (desiredValue >= 0) {
            for (int i = this.elementCount; i < newCount; ++i) {
                try {
                    Object o = this.xDrawPage.getByIndex(i);
                    XShape xShape = UnoRuntime.queryInterface(XShape.class, o);
                    this.pos = xShape.getPosition();
                    System.out.println("Shape Type: " + xShape.getShapeType());
                    continue;
                }
                catch (com.sun.star.uno.Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private void dispatch(Object oProvider, XMultiServiceFactory xMSF, String url, PropertyValue[] prop) {
        XDispatchProvider xDispatchProvider = UnoRuntime.queryInterface(XDispatchProvider.class, oProvider);
        Object dispatcher = null;
        try {
            dispatcher = xMSF.createInstance("com.sun.star.frame.DispatchHelper");
        }
        catch (com.sun.star.uno.Exception e) {
            // empty catch block
        }
        XDispatchHelper xDispatchHelper = UnoRuntime.queryInterface(XDispatchHelper.class, dispatcher);
        xDispatchHelper.executeDispatch(xDispatchProvider, url, "", 0, prop);
    }
}

