/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.GeneralFunction;
import com.sun.star.sheet.SubTotalColumn;
import com.sun.star.sheet.XDatabaseRange;
import com.sun.star.sheet.XSheetFilterDescriptor;
import com.sun.star.sheet.XSubTotalDescriptor;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDatabaseRange
extends MultiMethodTest {
    public XDatabaseRange oObj = null;
    CellRangeAddress oldCRA = null;
    XCellRange xCellRange = null;
    XSubTotalDescriptor STD = null;
    final short COL = 0;
    final short STARTROW = 0;
    final short ENDROW = (short)5;

    @Override
    protected void before() {
        this.oldCRA = (CellRangeAddress)this.tEnv.getObjRelation("DATAAREA");
        if (this.oldCRA == null) {
            throw new StatusException(Status.failed("Relation 'DATAAREA' not found"));
        }
        this.xCellRange = (XCellRange)this.tEnv.getObjRelation("XCELLRANGE");
        if (this.xCellRange == null) {
            throw new StatusException(Status.failed("Relation 'XCELLRANGE' not found"));
        }
    }

    public void _getDataArea() {
        boolean bResult = true;
        CellRangeAddress objCRA = this.oObj.getDataArea();
        bResult &= objCRA.EndColumn == this.oldCRA.EndColumn;
        bResult &= objCRA.EndRow == this.oldCRA.EndRow;
        bResult &= objCRA.Sheet == this.oldCRA.Sheet;
        bResult &= objCRA.StartColumn == this.oldCRA.StartColumn;
        this.tRes.tested("getDataArea()", bResult &= objCRA.StartRow == this.oldCRA.StartRow);
    }

    public void _getFilterDescriptor() {
        XSheetFilterDescriptor FD = this.oObj.getFilterDescriptor();
        this.tRes.tested("getFilterDescriptor()", FD != null);
    }

    public void _getImportDescriptor() {
        PropertyValue[] pva = this.oObj.getImportDescriptor();
        this.tRes.tested("getImportDescriptor()", pva != null);
    }

    public void _getSortDescriptor() {
        PropertyValue[] pva = this.oObj.getSortDescriptor();
        this.tRes.tested("getSortDescriptor()", pva != null);
    }

    public void _getSubTotalDescriptor() {
        this.STD = this.oObj.getSubTotalDescriptor();
        this.tRes.tested("getSubTotalDescriptor()", this.STD != null);
    }

    public void _refresh() {
        this.requiredMethod("getSubTotalDescriptor()");
        this.requiredMethod("setDataArea()");
        for (int i = 0; i < 6; ++i) {
            try {
                XCell cell = this.xCellRange.getCellByPosition(0, i);
                cell.setValue(i);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                this.tRes.tested("refresh()", false);
            }
        }
        SubTotalColumn[] STC = new SubTotalColumn[]{new SubTotalColumn()};
        STC[0].Column = 0;
        STC[0].Function = GeneralFunction.SUM;
        double oldVal = 0.0;
        try {
            XCell checkCell = this.xCellRange.getCellByPosition(0, 5);
            oldVal = checkCell.getValue();
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            this.tRes.tested("refresh()", false);
        }
        this.log.println("Value of the cell (0, 5) : " + oldVal);
        this.log.println("Set new SubTotal descriptor...");
        this.STD.clear();
        this.STD.addNew(STC, 1);
        double valBeforeRefresh = 0.0;
        try {
            XCell checkCell = this.xCellRange.getCellByPosition(0, 5);
            valBeforeRefresh = checkCell.getValue();
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            this.tRes.tested("refresh()", false);
        }
        this.log.println("Value of the cell (0, 5) : " + valBeforeRefresh);
        this.log.println("Now call refresh()...");
        this.oObj.refresh();
        double valAfterRefresh = 0.0;
        try {
            XCell checkCell = this.xCellRange.getCellByPosition(0, 5);
            valAfterRefresh = checkCell.getValue();
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            this.tRes.tested("refresh()", false);
        }
        this.log.println("Value of the cell (0, 5) : " + valAfterRefresh);
        this.tRes.tested("refresh()", oldVal != valAfterRefresh && oldVal == valBeforeRefresh);
    }

    public void _setDataArea() {
        this.executeMethod("getDataArea()");
        CellRangeAddress newCRA = new CellRangeAddress();
        newCRA.Sheet = this.oldCRA.Sheet;
        newCRA.StartColumn = 0;
        newCRA.EndColumn = 0;
        newCRA.StartRow = 0;
        newCRA.EndRow = 5;
        this.oObj.setDataArea(newCRA);
        this.tRes.tested("setDataArea()", true);
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

