/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.DataPilotFieldFilter;
import com.sun.star.sheet.DataPilotFieldOrientation;
import com.sun.star.sheet.DataPilotTableHeaderData;
import com.sun.star.sheet.DataPilotTablePositionData;
import com.sun.star.sheet.DataPilotTableResultData;
import com.sun.star.sheet.DataResult;
import com.sun.star.sheet.XCellAddressable;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.sheet.XDataPilotDescriptor;
import com.sun.star.sheet.XDataPilotTable2;
import com.sun.star.sheet.XSheetCellCursor;
import com.sun.star.sheet.XSheetCellRange;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellCursor;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDataPilotTable2
extends MultiMethodTest {
    private XSpreadsheetDocument xSheetDoc = null;
    private XDataPilotTable2 xDPTab2 = null;
    private CellRangeAddress mRangeWhole = null;
    private CellRangeAddress mRangeTable = null;
    private CellRangeAddress mRangeResult = null;
    private ArrayList mDataFieldDims = null;
    private ArrayList mResultCells = null;

    @Override
    protected void before() {
        Object o = this.tEnv.getObjRelation("DATAPILOTTABLE2");
        this.xDPTab2 = UnoRuntime.queryInterface(XDataPilotTable2.class, o);
        if (this.xDPTab2 == null) {
            throw new StatusException(Status.failed("Relation not found"));
        }
        this.xSheetDoc = (XSpreadsheetDocument)this.tEnv.getObjRelation("SHEETDOCUMENT");
        this.getOutputRanges();
        this.buildDataFields();
        try {
            this.buildResultCells();
        }
        catch (ResultCellFailure e) {
            e.printStackTrace(this.log);
            throw new StatusException("Failed to build result cells.", e);
        }
    }

    public void _getDrillDownData() {
        boolean testResult = true;
        int cellCount = this.mResultCells.size();
        for (int i = 0; i < cellCount; ++i) {
            CellAddress addr = (CellAddress)this.mResultCells.get(i);
            DataPilotTablePositionData posData = this.xDPTab2.getPositionData(addr);
            DataPilotTableResultData resData = (DataPilotTableResultData)posData.PositionData;
            int dim = (Integer)this.mDataFieldDims.get(resData.DataFieldIndex);
            DataResult res = resData.Result;
            double val = res.Value;
            Object[][] data = this.xDPTab2.getDrillDownData(addr);
            double sum = 0.0;
            if (data.length > 1) {
                for (int row = 1; row < data.length; ++row) {
                    Object o = data[row][dim];
                    if (!AnyConverter.isDouble((Object)o)) continue;
                    sum += ((Double)o).doubleValue();
                }
            }
            this.log.println(this.formatCell(addr) + ": " + data.length + " rows (" + (data.length - 1) + " records)");
            if (val == sum) continue;
            testResult = false;
        }
        this.tRes.tested("getDrillDownData()", testResult);
    }

    public void _getPositionData() {
        boolean testResult = false;
        CellAddress addr = new CellAddress();
        addr.Sheet = this.mRangeTable.Sheet;
        boolean rangeGood = true;
        for (int x = this.mRangeTable.StartColumn; x <= this.mRangeTable.EndColumn && rangeGood; ++x) {
            block8: for (int y = this.mRangeTable.StartRow; y <= this.mRangeTable.EndRow && rangeGood; ++y) {
                addr.Column = x;
                addr.Row = y;
                this.log.println("checking " + this.formatCell(addr));
                DataPilotTablePositionData posData = this.xDPTab2.getPositionData(addr);
                if (posData.PositionType == 0) {
                    this.log.println("specified cell address not in table: " + this.formatCell(addr));
                    rangeGood = false;
                    continue;
                }
                switch (posData.PositionType) {
                    case 0: {
                        continue block8;
                    }
                    case 3: {
                        this.printHeaderData(posData);
                        continue block8;
                    }
                    case 2: {
                        this.printHeaderData(posData);
                        continue block8;
                    }
                    case 1: {
                        this.printResultData(posData);
                        continue block8;
                    }
                    case 4: {
                        continue block8;
                    }
                    default: {
                        this.log.println("unknown position");
                    }
                }
            }
        }
        if (!rangeGood) {
            this.log.println("table range check failed");
        } else {
            testResult = true;
        }
        this.tRes.tested("getPositionData()", testResult);
    }

    public void _insertDrillDownSheet() {
        boolean testResult = true;
        int cellCount = this.mResultCells.size();
        XSpreadsheets xSheets = this.xSheetDoc.getSheets();
        XIndexAccess xIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSheets);
        int sheetCount = xIA.getCount();
        for (int i = 0; i < cellCount && testResult; ++i) {
            CellAddress addr = (CellAddress)this.mResultCells.get(i);
            Object[][] data = this.xDPTab2.getDrillDownData(addr);
            this.xDPTab2.insertDrillDownSheet(addr);
            int newSheetCount = xIA.getCount();
            if (newSheetCount == sheetCount + 1) {
                this.log.println("drill-down sheet for " + this.formatCell(addr) + " inserted");
                if (data.length < 2) {
                    this.log.println("new sheet inserted; however, there is no data for this result");
                    testResult = false;
                    continue;
                }
                XSpreadsheet xSheet = null;
                try {
                    xSheet = UnoRuntime.queryInterface(XSpreadsheet.class, xIA.getByIndex(addr.Sheet));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new StatusException("Failed to get the spreadsheet object.", e);
                }
                if (!this.checkDrillDownSheetContent(xSheet, data)) {
                    this.log.println("dataintegrity check on the inserted sheet failed");
                    testResult = false;
                    continue;
                }
                this.log.println("  sheet data integrity check passed");
                XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, (Object)xSheet);
                String name = xNamed.getName();
                try {
                    xSheets.removeByName(name);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new StatusException("Failed to removed the inserted sheet named " + name + ".", e);
                }
            }
            if (newSheetCount == sheetCount) {
                if (data.length <= 1) continue;
                this.log.println("no new sheet is inserted, despite the data being present.");
                testResult = false;
                continue;
            }
            this.log.println("what just happened!?");
            testResult = false;
        }
        this.tRes.tested("insertDrillDownSheet()", testResult);
    }

    public void _getOutputRangeByType() {
        boolean testResult;
        block6: {
            testResult = false;
            try {
                CellRangeAddress rangeOutOfBound = this.xDPTab2.getOutputRangeByType(-1);
                this.log.println("exception not raised");
            }
            catch (IllegalArgumentException e) {
                this.log.println("exception raised on invalid range type (good)");
                try {
                    CellRangeAddress rangeOutOfBound = this.xDPTab2.getOutputRangeByType(100);
                    this.log.println("exception not raised");
                }
                catch (IllegalArgumentException e2) {
                    this.log.println("exception raised on invalid range type (good)");
                    if (this.mRangeWhole.EndColumn - this.mRangeWhole.StartColumn <= 0 || this.mRangeWhole.EndRow - this.mRangeWhole.EndColumn <= 0) {
                        this.log.println("whole range is empty");
                        break block6;
                    }
                    this.log.println("whole range is not empty (good)");
                    if (this.mRangeTable.Sheet != this.mRangeWhole.Sheet || this.mRangeTable.StartColumn != this.mRangeWhole.StartColumn || this.mRangeTable.EndColumn != this.mRangeWhole.EndColumn || this.mRangeTable.EndRow != this.mRangeWhole.EndRow) {
                        this.log.println("table range is incorrect");
                        break block6;
                    }
                    this.log.println("table range is correct");
                    if (this.mRangeResult.Sheet != this.mRangeTable.Sheet || this.mRangeResult.StartColumn < this.mRangeTable.StartColumn || this.mRangeResult.StartRow < this.mRangeTable.StartRow || this.mRangeResult.EndColumn != this.mRangeTable.EndColumn || this.mRangeResult.EndRow != this.mRangeTable.EndRow) break block6;
                    this.log.println("result range is correct");
                    testResult = true;
                }
            }
        }
        this.tRes.tested("getOutputRangeByType()", testResult);
    }

    private void printHeaderData(DataPilotTablePositionData posData) {
        DataPilotTableHeaderData header = (DataPilotTableHeaderData)posData.PositionData;
        String posType = "";
        if (posData.PositionType == 3) {
            posType = "column header";
        } else if (posData.PositionType == 2) {
            posType = "row header";
        }
        this.log.println(posType + "; member name: " + header.MemberName + "; dimension: " + header.Dimension + "; hierarchy: " + header.Hierarchy + "; level: " + header.Level);
    }

    private void printResultData(DataPilotTablePositionData posData) {
        DataPilotTableResultData resultData = (DataPilotTableResultData)posData.PositionData;
        int dataId = resultData.DataFieldIndex;
        DataResult res = resultData.Result;
        double val = res.Value;
        int flags = res.Flags;
        int filterCount = resultData.FieldFilters.length;
        this.log.println("result; data field index: " + dataId + "; value: " + val + "; flags: " + flags + "; filter count: " + filterCount);
        for (int i = 0; i < filterCount; ++i) {
            DataPilotFieldFilter fil = resultData.FieldFilters[i];
            this.log.println("  field name: " + fil.FieldName + "; match value: " + fil.MatchValue);
        }
    }

    private String formatCell(CellAddress addr) {
        String str = "(" + addr.Column + "," + addr.Row + ")";
        return str;
    }

    private void printRange(String text, CellRangeAddress rangeAddr) {
        this.log.println(text + ": (" + rangeAddr.StartColumn + "," + rangeAddr.StartRow + ") - (" + rangeAddr.EndColumn + "," + rangeAddr.EndRow + ")");
    }

    private void buildResultCells() throws ResultCellFailure {
        if (this.mResultCells != null) {
            return;
        }
        this.getOutputRanges();
        this.mResultCells = new ArrayList();
        for (int x = this.mRangeResult.StartColumn; x <= this.mRangeResult.EndColumn; ++x) {
            int y = this.mRangeResult.StartRow;
            while (y <= this.mRangeResult.EndRow) {
                CellAddress addr = new CellAddress();
                addr.Sheet = this.mRangeResult.Sheet;
                addr.Column = x;
                addr.Row = y++;
                DataPilotTablePositionData posData = this.xDPTab2.getPositionData(addr);
                if (posData.PositionType != 1) {
                    this.log.println(this.formatCell(addr) + ": this is not a result cell");
                    throw new ResultCellFailure();
                }
                this.mResultCells.add(addr);
            }
        }
    }

    private void buildDataFields() {
        this.mDataFieldDims = new ArrayList();
        XDataPilotDescriptor xDesc = UnoRuntime.queryInterface(XDataPilotDescriptor.class, (Object)this.xDPTab2);
        XIndexAccess xFields = xDesc.getDataPilotFields();
        int fieldCount = xFields.getCount();
        for (int i = 0; i < fieldCount; ++i) {
            try {
                Object field = xFields.getByIndex(i);
                XPropertySet propSet = UnoRuntime.queryInterface(XPropertySet.class, field);
                DataPilotFieldOrientation orient = (DataPilotFieldOrientation)propSet.getPropertyValue("Orientation");
                if (orient != DataPilotFieldOrientation.DATA) continue;
                Integer item = new Integer(i);
                this.mDataFieldDims.add(item);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
                throw new StatusException("Failed to get a field.", e);
            }
        }
    }

    private void getOutputRanges() {
        if (this.mRangeWhole != null && this.mRangeTable != null && this.mRangeResult != null) {
            return;
        }
        try {
            this.mRangeWhole = this.xDPTab2.getOutputRangeByType(0);
            this.printRange("whole range ", this.mRangeWhole);
            this.mRangeTable = this.xDPTab2.getOutputRangeByType(1);
            this.printRange("table range ", this.mRangeTable);
            this.mRangeResult = this.xDPTab2.getOutputRangeByType(2);
            this.printRange("result range", this.mRangeResult);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Failed to get output range by type.", e);
        }
    }

    private boolean checkDrillDownSheetContent(XSpreadsheet xSheet, Object[][] data) {
        CellAddress lastCell = this.getLastUsedCellAddress(xSheet, 0, 0);
        if (data.length <= 0 || lastCell.Row == 0 || lastCell.Column == 0) {
            this.log.println("empty data condition");
            return false;
        }
        if (data.length != lastCell.Row + 1 || data[0].length != lastCell.Column + 1) {
            this.log.println("data size differs");
            return false;
        }
        XCellRange xCR = null;
        try {
            xCR = xSheet.getCellRangeByPosition(0, 0, lastCell.Column, lastCell.Row);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        XCellRangeData xCRD = UnoRuntime.queryInterface(XCellRangeData.class, (Object)xCR);
        Object[][] sheetData = xCRD.getDataArray();
        for (int x = 0; x < sheetData.length; ++x) {
            for (int y = 0; y < sheetData[x].length; ++y) {
                Object cell1 = sheetData[x][y];
                Object cell2 = data[x][y];
                if (AnyConverter.isString((Object)cell1) && AnyConverter.isString((Object)cell2)) {
                    String s1 = (String)cell1;
                    String s2 = (String)cell2;
                    if (s1.equals(s2)) continue;
                    this.log.println("string cell values differ");
                    return false;
                }
                if (AnyConverter.isDouble((Object)cell1) && AnyConverter.isDouble((Object)cell2)) {
                    double f1 = 0.0;
                    double f2 = 0.0;
                    try {
                        f1 = AnyConverter.toDouble((Object)cell1);
                        f2 = AnyConverter.toDouble((Object)cell2);
                    }
                    catch (IllegalArgumentException e) {
                        this.log.println("failed to convert cells to double");
                        return false;
                    }
                    if (f1 == f2) continue;
                    this.log.println("numerical cell values differ");
                    return false;
                }
                this.log.println("cell types differ");
                return false;
            }
        }
        return true;
    }

    private CellAddress getLastUsedCellAddress(XSpreadsheet xSheet, int nCol, int nRow) {
        try {
            XCellRange xRng = xSheet.getCellRangeByPosition(nCol, nRow, nCol, nRow);
            XSheetCellRange xSCR = UnoRuntime.queryInterface(XSheetCellRange.class, (Object)xRng);
            XSheetCellCursor xCursor = xSheet.createCursorByRange(xSCR);
            XCellCursor xCellCursor = UnoRuntime.queryInterface(XCellCursor.class, (Object)xCursor);
            xCellCursor.gotoEnd();
            XCell xCell = xCursor.getCellByPosition(0, 0);
            XCellAddressable xCellAddr = UnoRuntime.queryInterface(XCellAddressable.class, (Object)xCell);
            return xCellAddr.getCellAddress();
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private class ResultCellFailure
    extends Exception {
        private ResultCellFailure() {
        }
    }
}

