/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.DataPilotFieldOrientation;
import com.sun.star.sheet.XDataPilotDescriptor;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDataPilotDescriptor
extends MultiMethodTest {
    public XDataPilotDescriptor oObj = null;
    CellRangeAddress CRA = new CellRangeAddress(1, 1, 1, 5, 5);
    CellRangeAddress oldCRA = null;
    String sTag = new String("XDataPilotDescriptor_Tag");
    String[] fieldsNames;
    int fieldsAmount = 0;
    int tEnvFieldsAmount = 0;

    @Override
    protected void before() {
        Integer amount = (Integer)this.tEnv.getObjRelation("FIELDSAMOUNT");
        if (amount == null) {
            throw new StatusException(Status.failed("Relation 'FIELDSAMOUNT' not found"));
        }
        this.tEnvFieldsAmount = amount;
    }

    public void _getSourceRange() {
        this.requiredMethod("setSourceRange()");
        boolean bResult = true;
        CellRangeAddress objRA = this.oObj.getSourceRange();
        bResult &= objRA.Sheet == this.CRA.Sheet;
        bResult &= objRA.StartRow == this.CRA.StartRow;
        bResult &= objRA.StartColumn == this.CRA.StartColumn;
        bResult &= objRA.EndRow == this.CRA.EndRow;
        this.tRes.tested("getSourceRange()", bResult &= objRA.EndColumn == this.CRA.EndColumn);
    }

    public void _setSourceRange() {
        this.executeMethod("getColumnFields()");
        this.executeMethod("getRowFields()");
        this.executeMethod("getDataFields()");
        this.executeMethod("getHiddenFields()");
        this.executeMethod("getPageFields()");
        this.oldCRA = this.oObj.getSourceRange();
        this.oObj.setSourceRange(this.CRA);
        this.tRes.tested("setSourceRange()", true);
    }

    public void _getTag() {
        this.requiredMethod("setTag()");
        boolean bResult = true;
        String objTag = this.oObj.getTag();
        this.tRes.tested("getTag()", bResult &= objTag.equals(this.sTag));
    }

    public void _setTag() {
        this.oObj.setTag(this.sTag);
        this.tRes.tested("setTag()", true);
    }

    public void _getDataPilotFields() {
        boolean bResult = true;
        XIndexAccess IA = null;
        IA = this.oObj.getDataPilotFields();
        if (IA == null) {
            this.log.println("Returned value is null.");
            this.tRes.tested("getDataPilotFields()", false);
            return;
        }
        this.log.println("getDataPilotFields returned not Null value -- OK");
        this.fieldsAmount = IA.getCount();
        if (this.fieldsAmount < this.tEnvFieldsAmount) {
            this.log.println("Number of fields is less than number goten by relation.");
            this.tRes.tested("getDataPilotFields()", false);
            return;
        }
        this.log.println("count of returned fields -- OK");
        this.fieldsNames = new String[this.tEnvFieldsAmount];
        int i = -1;
        int cnt = 0;
        while (++i < this.fieldsAmount) {
            Object field;
            try {
                field = IA.getByIndex(i);
            }
            catch (WrappedTargetException e) {
                e.printStackTrace(this.log);
                this.tRes.tested("getDataPilotFields()", false);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace(this.log);
                this.tRes.tested("getDataPilotFields()", false);
                return;
            }
            XNamed named = UnoRuntime.queryInterface(XNamed.class, field);
            String name = named.getName();
            this.log.print("Field : '" + name + "' ... ");
            if (!name.equals("Data")) {
                this.fieldsNames[cnt] = name;
                XPropertySet props = UnoRuntime.queryInterface(XPropertySet.class, field);
                try {
                    switch (cnt % 5) {
                        case 0: {
                            props.setPropertyValue("Orientation", DataPilotFieldOrientation.COLUMN);
                            this.log.println("  Column");
                            break;
                        }
                        case 1: {
                            props.setPropertyValue("Orientation", DataPilotFieldOrientation.ROW);
                            this.log.println("  Row");
                            break;
                        }
                        case 2: {
                            props.setPropertyValue("Orientation", DataPilotFieldOrientation.DATA);
                            this.log.println("  Data");
                            break;
                        }
                        case 3: {
                            props.setPropertyValue("Orientation", DataPilotFieldOrientation.HIDDEN);
                            this.log.println("  Hidden");
                            break;
                        }
                        case 4: {
                            props.setPropertyValue("Orientation", DataPilotFieldOrientation.PAGE);
                            this.log.println("  Page");
                        }
                    }
                }
                catch (WrappedTargetException e) {
                    e.printStackTrace(this.log);
                    this.tRes.tested("getDataPilotFields()", false);
                    return;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(this.log);
                    this.tRes.tested("getDataPilotFields()", false);
                    return;
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace(this.log);
                    this.tRes.tested("getDataPilotFields()", false);
                    return;
                }
                catch (UnknownPropertyException e) {
                    e.printStackTrace(this.log);
                    this.tRes.tested("getDataPilotFields()", false);
                    return;
                }
                if (++cnt <= 4) continue;
                break;
            }
            this.tRes.tested("getDataPilotFields()", false);
            return;
        }
        this.tRes.tested("getDataPilotFields()", bResult);
    }

    public void _getColumnFields() {
        this.requiredMethod("getDataPilotFields()");
        XIndexAccess IA = this.oObj.getColumnFields();
        boolean bResult = this.CheckNames(IA, 0);
        this.tRes.tested("getColumnFields()", bResult);
    }

    public void _getDataFields() {
        this.requiredMethod("getDataPilotFields()");
        XIndexAccess IA = this.oObj.getDataFields();
        boolean bResult = this.CheckNames(IA, 2);
        this.tRes.tested("getDataFields()", bResult);
    }

    public void _getHiddenFields() {
        this.requiredMethod("getDataPilotFields()");
        XIndexAccess IA = this.oObj.getHiddenFields();
        boolean bResult = this.CheckNames(IA, 3);
        this.tRes.tested("getHiddenFields()", bResult);
    }

    public void _getRowFields() {
        this.requiredMethod("getDataPilotFields()");
        XIndexAccess IA = this.oObj.getRowFields();
        boolean bResult = this.CheckNames(IA, 1);
        this.tRes.tested("getRowFields()", bResult);
    }

    public void _getPageFields() {
        this.requiredMethod("getDataPilotFields()");
        XIndexAccess IA = this.oObj.getPageFields();
        boolean bResult = IA != null;
        this.tRes.tested("getPageFields()", bResult);
    }

    public void _getFilterDescriptor() {
        boolean bResult = this.oObj.getFilterDescriptor() != null;
        this.tRes.tested("getFilterDescriptor()", bResult);
    }

    boolean CheckNames(XIndexAccess IA, int rem) {
        String name = null;
        if (IA == null) {
            this.log.println("Null retruned.");
            return false;
        }
        if (this.fieldsNames[rem] == null) {
            this.log.println("No fields were set to this orientation - cann't check result");
            return true;
        }
        if (IA.getCount() == 0) {
            this.log.println("No fields found. Must be at least '" + this.fieldsNames[rem] + "'");
            return false;
        }
        try {
            this.log.print("Fields returned ");
            for (int i = 0; i < IA.getCount(); ++i) {
                Object field = IA.getByIndex(i);
                XNamed named = UnoRuntime.queryInterface(XNamed.class, field);
                name = named.getName();
                this.log.print(" " + name);
                if (!this.fieldsNames[rem].equals(name)) continue;
                this.log.println(" - OK");
                return true;
            }
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(this.log);
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            return false;
        }
        this.log.println(" - FAILED (field " + this.fieldsNames[rem] + " was not found.");
        return false;
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

