/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.XCellRangesQuery;
import com.sun.star.sheet.XSheetCellRanges;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.table.XTableRows;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XCellRangesQuery
extends MultiMethodTest {
    public XCellRangesQuery oObj;
    protected XSpreadsheet oSheet;
    protected XTableRows oRows;
    protected XTableColumns oColumns;
    protected String[] mExpectedResults = null;
    protected boolean bMakeEntriesAndDispose = false;
    String getting = "";
    String expected = "";
    public static final int QUERYCOLUMNDIFFERENCES = 0;
    public static final int QUERYCONTENTCELLS = 1;
    public static final int QUERYEMPTYCELLS = 2;
    public static final int QUERYFORMULACELLS = 3;
    public static final int QUERYINTERSECTION = 4;
    public static final int QUERYROWDIFFERENCES = 5;
    public static final int QUERYVISIBLECELLS = 6;

    @Override
    protected void before() {
        this.oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (this.oSheet == null) {
            this.log.println("Object relation oSheet is missing");
            this.log.println("Trying to query the needed Interface");
            this.oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.tEnv.getTestObject());
            if (this.oSheet == null) {
                throw new StatusException(Status.failed("Object relation oSheet is missing"));
            }
        }
        this.mExpectedResults = (String[])this.tEnv.getObjRelation("XCellRangesQuery.EXPECTEDRESULTS");
        XColumnRowRange oColumnRowRange = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)this.oSheet);
        this.oRows = oColumnRowRange.getRows();
        this.oColumns = oColumnRowRange.getColumns();
        Object o = this.tEnv.getObjRelation("XCellRangesQuery.CREATEENTRIES");
        if (o != null && o instanceof Boolean) {
            this.bMakeEntriesAndDispose = (Boolean)o;
        }
        if (this.bMakeEntriesAndDispose) {
            this.oRows.removeByIndex(4, this.oRows.getCount() - 4);
            this.oColumns.removeByIndex(4, this.oColumns.getCount() - 4);
            try {
                this.oSheet.getCellByPosition(1, 1).setValue(5.0);
                this.oSheet.getCellByPosition(1, 2).setValue(15.0);
                this.oSheet.getCellByPosition(2, 1).setFormula("=B2+B3");
                this.oSheet.getCellByPosition(1, 3).setFormula("=B2+B4");
                this.oSheet.getCellByPosition(3, 2).setFormula("");
                this.oSheet.getCellByPosition(3, 3).setFormula("");
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Couldn't fill cells " + e.getLocalizedMessage());
            }
        }
    }

    public void _queryColumnDifferences() {
        boolean res = true;
        XSheetCellRanges ranges = this.oObj.queryColumnDifferences(new CellAddress(0, 1, 1));
        this.getting = ranges.getRangeAddressesAsString();
        this.expected = this.mExpectedResults[0];
        if (!this.getting.startsWith(this.expected)) {
            this.log.println("Getting: " + this.getting);
            this.log.println("Should have started with: " + this.expected);
            res = false;
        }
        this.tRes.tested("queryColumnDifferences()", res);
    }

    public void _queryContentCells() {
        boolean res = true;
        XSheetCellRanges ranges = this.oObj.queryContentCells((short)1);
        this.getting = ranges.getRangeAddressesAsString();
        this.expected = this.mExpectedResults[1];
        if (!this.getting.startsWith(this.expected)) {
            this.log.println("Getting: " + this.getting);
            this.log.println("Should have started with: " + this.expected);
            res = false;
        }
        this.tRes.tested("queryContentCells()", res);
    }

    public void _queryEmptyCells() {
        boolean res = true;
        XSheetCellRanges ranges = this.oObj.queryEmptyCells();
        this.getting = ranges.getRangeAddressesAsString();
        this.expected = this.mExpectedResults[2];
        int startIndex = 0;
        int endIndex = -5;
        String checkString = null;
        while (endIndex != -1) {
            startIndex = endIndex + 5;
            checkString = (endIndex = this.expected.indexOf(" ... ", startIndex)) == -1 ? this.expected.substring(startIndex) : this.expected.substring(startIndex, endIndex);
            res &= this.getting.indexOf(checkString) > -1;
        }
        if (!res) {
            this.log.println("Getting: " + this.getting);
            this.log.println("Should have contained: " + this.expected);
        }
        this.tRes.tested("queryEmptyCells()", res);
    }

    public void _queryFormulaCells() {
        boolean res = true;
        XSheetCellRanges ranges = this.oObj.queryFormulaCells(1);
        this.getting = ranges.getRangeAddressesAsString();
        this.expected = this.mExpectedResults[3];
        if (!this.getting.equals(this.expected)) {
            this.log.println("Getting: " + this.getting);
            this.log.println("Expected: " + this.expected);
            res = false;
        }
        this.tRes.tested("queryFormulaCells()", res);
    }

    public void _queryIntersection() {
        boolean res = true;
        XSheetCellRanges ranges = this.oObj.queryIntersection(new CellRangeAddress(0, 3, 3, 7, 7));
        this.getting = ranges.getRangeAddressesAsString();
        this.expected = this.mExpectedResults[4];
        if (!this.getting.startsWith(this.expected)) {
            this.log.println("Getting: " + this.getting);
            this.log.println("Should have started with: " + this.expected);
            res = false;
        }
        this.tRes.tested("queryIntersection()", res);
    }

    public void _queryRowDifferences() {
        boolean res = true;
        XSheetCellRanges ranges = this.oObj.queryRowDifferences(new CellAddress(0, 1, 1));
        this.getting = ranges.getRangeAddressesAsString();
        this.expected = this.mExpectedResults[5];
        if (!this.getting.startsWith(this.expected)) {
            this.log.println("Getting: " + this.getting);
            this.log.println("Should have started with: " + this.expected);
            res = false;
        }
        this.tRes.tested("queryRowDifferences()", res);
    }

    public void _queryVisibleCells() {
        this.setRowVisible(false);
        boolean res = true;
        XSheetCellRanges ranges = this.oObj.queryVisibleCells();
        this.getting = ranges.getRangeAddressesAsString();
        this.expected = this.mExpectedResults[6];
        if (!this.getting.startsWith(this.expected)) {
            this.log.println("Getting: " + this.getting);
            this.log.println("Should have started with: " + this.expected);
            res = false;
        }
        this.setRowVisible(true);
        this.tRes.tested("queryVisibleCells()", res);
    }

    protected void setRowVisible(boolean vis) {
        try {
            XPropertySet rowProp = UnoRuntime.queryInterface(XPropertySet.class, this.oRows.getByIndex(0));
            rowProp.setPropertyValue("IsVisible", new Boolean(vis));
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("couldn't get Row " + e.getLocalizedMessage());
        }
        catch (WrappedTargetException e) {
            this.log.println("problems setting Property 'isVisible' " + e.getLocalizedMessage());
        }
        catch (UnknownPropertyException e) {
            this.log.println("problems setting Property 'isVisible' " + e.getLocalizedMessage());
        }
        catch (PropertyVetoException e) {
            this.log.println("problems setting Property 'isVisible' " + e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            this.log.println("problems setting Property 'isVisible' " + e.getLocalizedMessage());
        }
    }

    @Override
    protected void after() {
        if (this.bMakeEntriesAndDispose) {
            this.disposeEnvironment();
        }
    }
}

