/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.CellDeleteMode;
import com.sun.star.sheet.CellInsertMode;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XCellRangeMovement;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.table.XTableRows;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;

public class _XCellRangeMovement
extends MultiMethodTest {
    public XCellRangeMovement oObj = null;

    public void _copyRange() {
        this.log.println("Prepare cells before test methods.");
        XSpreadsheet oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.oObj);
        try {
            oSheet.getCellByPosition(1, 1).setValue(100.0);
            oSheet.getCellByPosition(1, 2).setValue(200.0);
            oSheet.getCellByPosition(2, 1).setValue(300.0);
            oSheet.getCellByPosition(2, 2).setValue(400.0);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            this.tRes.tested("copyRange()", false);
        }
        XCellRangeAddressable oAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)this.oObj);
        short iSheet = oAddr.getRangeAddress().Sheet;
        CellRangeAddress sSrc = new CellRangeAddress(iSheet, 1, 1, 2, 2);
        CellAddress sDest = new CellAddress(iSheet, 1, 10);
        boolean result = true;
        boolean loc_result = true;
        this.oObj.copyRange(sDest, sSrc);
        try {
            loc_result = oSheet.getCellByPosition(1, 10).getValue() == 100.0;
            loc_result &= oSheet.getCellByPosition(1, 11).getValue() == 200.0;
            loc_result &= oSheet.getCellByPosition(2, 10).getValue() == 300.0;
            loc_result &= oSheet.getCellByPosition(2, 11).getValue() == 400.0;
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            this.tRes.tested("copyRange()", false);
        }
        this.tRes.tested("copyRange()", result &= loc_result);
    }

    public void _insertCells() {
        boolean result = false;
        XSpreadsheet oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.oObj);
        XCellRangeAddressable oAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)this.oObj);
        short iSheet = oAddr.getRangeAddress().Sheet;
        try {
            oSheet.getCellByPosition(0, 20).setValue(100.0);
            oSheet.getCellByPosition(1, 20).setValue(100.0);
            oSheet.getCellByPosition(2, 20).setValue(100.0);
            oSheet.getCellByPosition(3, 20).setValue(100.0);
            oSheet.getCellByPosition(0, 21).setValue(200.0);
            oSheet.getCellByPosition(1, 21).setValue(200.0);
            oSheet.getCellByPosition(2, 21).setValue(200.0);
            oSheet.getCellByPosition(3, 21).setValue(200.0);
            if (oSheet.getCellByPosition(1, 21).getValue() != 200.0) {
                this.log.println("Cells were already inserted. Delete old cells now");
                XColumnRowRange oColumnRowRange = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)oSheet);
                XTableRows oRows = oColumnRowRange.getRows();
                oRows.removeByIndex(21, 1);
            }
            CellRangeAddress sSrc = new CellRangeAddress(iSheet, 0, 21, 5, 21);
            this.oObj.insertCells(sSrc, CellInsertMode.DOWN);
            double res = oSheet.getCellByPosition(1, 21).getValue();
            if (res == 0.0) {
                result = true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("insertCells()", result);
    }

    public void _moveRange() {
        boolean result = false;
        XSpreadsheet oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.oObj);
        XCellRangeAddressable oAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)this.oObj);
        short iSheet = oAddr.getRangeAddress().Sheet;
        try {
            oSheet.getCellByPosition(4, 0).setValue(111.0);
            oSheet.getCellByPosition(4, 1).setValue(222.0);
            CellRangeAddress sSrc = new CellRangeAddress(iSheet, 4, 0, 4, 1);
            CellAddress sDest = new CellAddress(iSheet, 4, 4);
            this.oObj.moveRange(sDest, sSrc);
            double cntA = 0.0;
            double cntB = 0.0;
            cntA = oSheet.getCellByPosition(4, 4).getValue();
            cntB = oSheet.getCellByPosition(4, 5).getValue();
            if (cntA + cntB == 333.0) {
                result = true;
            }
            oSheet.getCellByPosition(4, 4).setValue(0.0);
            oSheet.getCellByPosition(4, 5).setValue(0.0);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("moveRange()", result);
    }

    public void _removeRange() {
        boolean result = false;
        XSpreadsheet oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, (Object)this.oObj);
        XCellRangeAddressable oAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)this.oObj);
        short iSheet = oAddr.getRangeAddress().Sheet;
        try {
            oSheet.getCellByPosition(5, 0).setValue(333.0);
            oSheet.getCellByPosition(5, 1).setValue(444.0);
            CellRangeAddress sSrc = new CellRangeAddress(iSheet, 5, 0, 5, 1);
            this.oObj.removeRange(sSrc, CellDeleteMode.UP);
            double cntA = 0.0;
            double cntB = 0.0;
            cntA = oSheet.getCellByPosition(5, 0).getValue();
            cntB = oSheet.getCellByPosition(5, 1).getValue();
            if (cntA + cntB == 0.0) {
                result = true;
            }
            oSheet.getCellByPosition(5, 0).setValue(0.0);
            oSheet.getCellByPosition(5, 1).setValue(0.0);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("removeRange()", result);
    }
}

