/*
 * Decompiled with CFR 0.152.
 */
package ifc.sheet;

import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.sheet.XArrayFormulaRange;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XArrayFormulaRange
extends MultiMethodTest {
    public XArrayFormulaRange oObj = null;
    String formula = "=1 + 2 * 5";

    public void _setArrayFormula() {
        Object noArray = this.tEnv.getObjRelation("noArray");
        if (noArray != null) {
            this.log.println("Component " + noArray.toString() + " doesn't really support this Interface");
            this.log.println("It doesn't make sense to set an ArrayFormula over the whole sheet");
            this.tRes.tested("setArrayFormula()", true);
            return;
        }
        boolean result = true;
        double dresult = 11.0;
        this.log.println("setArrayFormula() ...");
        this.oObj.setArrayFormula(this.formula);
        this.log.println("checking that formula was set correctly...");
        XCellRangeAddressable crAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)this.oObj);
        CellRangeAddress addr = crAddr.getRangeAddress();
        XSpreadsheet oSheet = (XSpreadsheet)this.tEnv.getObjRelation("SHEET");
        if (oSheet == null) {
            throw new StatusException(Status.failed("Relation 'SHEET' not found"));
        }
        XCell oCell = null;
        block2: for (int i = addr.StartColumn; i <= addr.EndColumn; ++i) {
            for (int j = addr.StartRow; j <= addr.EndRow; ++j) {
                try {
                    oCell = oSheet.getCellByPosition(i, j);
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace(this.log);
                    result = false;
                    continue block2;
                }
                double value = oCell.getValue();
                result &= value == dresult;
            }
        }
        this.tRes.tested("setArrayFormula()", result);
    }

    public void _getArrayFormula() {
        Object noArray = this.tEnv.getObjRelation("noArray");
        if (noArray != null) {
            this.log.println("Component " + noArray.toString() + " doesn't really support this Interface");
            this.log.println("It doesn't make sense to set an ArrayFormula over the whole sheet");
            this.log.println("and therefore 'getArrayFormula()' won't work");
            this.tRes.tested("getArrayFormula()", true);
            return;
        }
        this.requiredMethod("setArrayFormula()");
        boolean result = true;
        this.log.println("Testing getArrayFormula() ...");
        String gFormula = this.oObj.getArrayFormula();
        if (!(result &= this.equalIgnoreSpaces("{" + this.formula + "}", gFormula))) {
            this.log.println("Method returned : '" + this.oObj.getArrayFormula() + "'");
        }
        this.tRes.tested("getArrayFormula()", result);
    }

    private boolean equalIgnoreSpaces(String s1, String s2) {
        int p2;
        int p1 = 0;
        s1 = s1.trim();
        s2 = s2.trim();
        for (p2 = 0; p1 < s1.length() && p2 < s2.length(); ++p1, ++p2) {
            while (s1.charAt(p1) == ' ') {
                ++p1;
            }
            while (s2.charAt(p2) == ' ') {
                ++p2;
            }
            if (s1.charAt(p1) == s2.charAt(p2)) continue;
            return false;
        }
        return p1 == s1.length() && p2 == s2.length();
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

