/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbc;

import com.sun.star.io.XDataInputStream;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XTextInputStream;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;
import com.sun.star.util.DateTime;
import com.sun.star.util.Time;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueComparer;

public class _XRowUpdate
extends MultiMethodTest {
    public XRowUpdate oObj = null;
    private Vector rowData = null;
    private XRow row = null;

    @Override
    public void before() {
        this.rowData = (Vector)this.tEnv.getObjRelation("CurrentRowData");
        if (this.rowData == null) {
            this.log.println("!!! 'CurrentRowData' relation not found !!!");
        }
        this.row = (XRow)this.tEnv.getObjRelation("XRowUpdate.XRow");
        if (this.rowData == null) {
            this.log.println("!!! 'XRowUpdate.XRow' relation not found !!!");
        }
    }

    public void _updateNull() {
        boolean result = true;
        for (int i = 0; i < this.rowData.size(); ++i) {
            if (this.rowData.get(i) == null) continue;
            this.log.print("  Setting NULL at column #" + (i + 1) + " ...");
            try {
                this.oObj.updateNull(i + 1);
                if (this.rowData.get(i) instanceof String) {
                    this.row.getString(i + 1);
                }
                if (this.rowData.get(i) instanceof Boolean) {
                    this.row.getBoolean(i + 1);
                }
                if (this.rowData.get(i) instanceof Byte) {
                    this.row.getByte(i + 1);
                }
                if (this.rowData.get(i) instanceof Short) {
                    this.row.getShort(i + 1);
                }
                if (this.rowData.get(i) instanceof Integer) {
                    this.row.getInt(i + 1);
                }
                if (this.rowData.get(i) instanceof Long) {
                    this.row.getLong(i + 1);
                }
                if (this.rowData.get(i) instanceof Float) {
                    this.row.getFloat(i + 1);
                }
                if (this.rowData.get(i) instanceof Double) {
                    this.row.getDouble(i + 1);
                }
                if (this.rowData.get(i) instanceof byte[]) {
                    this.row.getBytes(i + 1);
                }
                if (this.rowData.get(i) instanceof Date) {
                    this.row.getDate(i + 1);
                }
                if (this.rowData.get(i) instanceof Time) {
                    this.row.getTime(i + 1);
                }
                if (this.rowData.get(i) instanceof DateTime) {
                    this.row.getTimestamp(i + 1);
                }
                if (this.rowData.get(i) instanceof XDataInputStream) {
                    this.row.getBinaryStream(i + 1);
                }
                if (this.rowData.get(i) instanceof XTextInputStream) {
                    this.row.getCharacterStream(i + 1);
                }
                if (!this.row.wasNull()) {
                    this.log.println("FAILED");
                    this.log.println("Not NULL was returned !!!");
                    result = false;
                    continue;
                }
                this.log.println("OK");
                continue;
            }
            catch (SQLException e) {
                this.log.println("FAILED");
                e.printStackTrace(this.log);
                result = false;
            }
        }
        this.tRes.tested("updateNull()", result);
    }

    public void _updateBoolean() {
        boolean result = true;
        int idx = this.findColumnOfType(Boolean.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateBoolean()", Status.skipped(true));
            return;
        }
        try {
            boolean newVal = !this.row.getBoolean(idx);
            this.oObj.updateBoolean(idx, newVal);
            boolean getVal = this.row.getBoolean(idx);
            result = newVal == getVal;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateBoolean()", result);
    }

    public void _updateByte() {
        boolean result = true;
        int idx = this.findColumnOfType(Byte.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateByte()", Status.skipped(true));
            return;
        }
        try {
            byte newVal = (byte)(this.row.getByte(idx) + 1);
            this.oObj.updateByte(idx, newVal);
            byte getVal = this.row.getByte(idx);
            result = newVal == getVal;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateByte()", result);
    }

    public void _updateShort() {
        boolean result = true;
        int idx = this.findColumnOfType(Short.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateShort()", Status.skipped(true));
            return;
        }
        try {
            short newVal = (short)(this.row.getShort(idx) + 1);
            this.oObj.updateShort(idx, newVal);
            short getVal = this.row.getShort(idx);
            result = newVal == getVal;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateShort()", result);
    }

    public void _updateInt() {
        boolean result = true;
        int idx = this.findColumnOfType(Integer.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateInt()", Status.skipped(true));
            return;
        }
        try {
            int newVal = 1 + this.row.getInt(idx);
            this.oObj.updateInt(idx, newVal);
            int getVal = this.row.getInt(idx);
            result = newVal == getVal;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateInt()", result);
    }

    public void _updateLong() {
        boolean result = true;
        int idx = this.findColumnOfType(Long.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateLong()", Status.skipped(true));
            return;
        }
        try {
            long newVal = 1L + this.row.getLong(idx);
            this.oObj.updateLong(idx, newVal);
            long getVal = this.row.getLong(idx);
            result = newVal == getVal;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateLong()", result);
    }

    public void _updateFloat() {
        boolean result = true;
        int idx = this.findColumnOfType(Float.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateFloat()", Status.skipped(true));
            return;
        }
        try {
            float newVal = (float)(1.1 + (double)this.row.getFloat(idx));
            this.oObj.updateFloat(idx, newVal);
            float getVal = this.row.getFloat(idx);
            result = newVal == getVal;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateFloat()", result);
    }

    public void _updateDouble() {
        boolean result = true;
        int idx = this.findColumnOfType(Double.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateDouble()", Status.skipped(true));
            return;
        }
        try {
            double newVal = 1.1 + this.row.getDouble(idx);
            this.oObj.updateDouble(idx, newVal);
            double getVal = this.row.getDouble(idx);
            result = newVal == getVal;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateDouble()", result);
    }

    public void _updateString() {
        boolean result = true;
        int idx = this.findColumnOfType(String.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateString()", Status.skipped(true));
            return;
        }
        try {
            String newVal = "_" + this.row.getString(idx);
            this.oObj.updateString(idx, newVal);
            String getVal = this.row.getString(idx);
            result = newVal.equals(getVal);
            this.log.println("New value = '" + newVal + "', get value = '" + getVal + "'");
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateString()", result);
    }

    public void _updateBytes() {
        boolean result = true;
        int idx = this.findColumnOfType(byte[].class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateBytes()", Status.skipped(true));
            return;
        }
        try {
            byte[] newVal = this.row.getBytes(idx);
            newVal = newVal == null || newVal.length == 0 ? new byte[]{34, 111, 98} : new byte[]{(byte)(newVal[0] + 1), 111, 98};
            this.oObj.updateBytes(idx, newVal);
            byte[] getVal = this.row.getBytes(idx);
            result = ValueComparer.equalValue(newVal, getVal);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateBytes()", result);
    }

    public void _updateDate() {
        boolean result = true;
        int idx = this.findColumnOfType(Date.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateDate()", Status.skipped(true));
            return;
        }
        try {
            Date newVal = this.row.getDate(idx);
            newVal.Year = (short)(newVal.Year + 1);
            this.oObj.updateDate(idx, newVal);
            Date getVal = this.row.getDate(idx);
            result = ValueComparer.equalValue(newVal, getVal);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateDate()", result);
    }

    public void _updateTime() {
        boolean result = true;
        int idx = this.findColumnOfType(Time.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateTime()", Status.skipped(true));
            return;
        }
        try {
            Time newVal = this.row.getTime(idx);
            newVal.Seconds = (short)(newVal.Seconds + 1);
            this.oObj.updateTime(idx, newVal);
            Time getVal = this.row.getTime(idx);
            result = ValueComparer.equalValue(newVal, getVal);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateTime()", result);
    }

    public void _updateTimestamp() {
        boolean result = true;
        int idx = this.findColumnOfType(DateTime.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateTimestamp()", Status.skipped(true));
            return;
        }
        try {
            DateTime newVal = this.row.getTimestamp(idx);
            newVal.Year = (short)(newVal.Year + 1);
            this.oObj.updateTimestamp(idx, newVal);
            DateTime getVal = this.row.getTimestamp(idx);
            result = ValueComparer.equalValue(newVal, getVal);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateTimestamp()", result);
    }

    public void _updateBinaryStream() {
        boolean result = true;
        int idx = this.findColumnOfType(XDataInputStream.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateBinaryStream()", Status.skipped(true));
            return;
        }
        try {
            Object oStream = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.DataInputStream");
            XInputStream newVal = UnoRuntime.queryInterface(XInputStream.class, oStream);
            this.oObj.updateBinaryStream(idx, newVal, 0);
            XInputStream getVal = this.row.getBinaryStream(idx);
            result = UnoRuntime.areSame(newVal, getVal);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        catch (Exception e) {
            this.log.println("Unexpected exception:");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateBinaryStream()", result);
    }

    public void _updateCharacterStream() {
        boolean result = true;
        int idx = this.findColumnOfType(XTextInputStream.class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateCharacterStream()", Status.skipped(true));
            return;
        }
        try {
            Object oStream = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.TextInputStream");
            XInputStream newVal = UnoRuntime.queryInterface(XInputStream.class, oStream);
            this.oObj.updateCharacterStream(idx, newVal, 0);
            XInputStream getVal = this.row.getCharacterStream(idx);
            result = UnoRuntime.areSame(newVal, getVal);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        catch (Exception e) {
            this.log.println("Unexpected exception:");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateCharacterStream()", result);
    }

    public void _updateObject() {
        boolean result = true;
        int idx = this.findColumnOfType(Object[].class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateObject()", Status.skipped(true));
            return;
        }
        try {
            Object newVal = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.Pipe");
            this.oObj.updateObject(idx, newVal);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        catch (Exception e) {
            this.log.println("Unexpected exception:");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateObject()", result);
    }

    public void _updateNumericObject() {
        boolean result = true;
        int idx = this.findColumnOfType(Object[].class);
        if (idx < 0) {
            this.log.println("Required type not found");
            this.tRes.tested("updateNumericObject()", Status.skipped(true));
            return;
        }
        try {
            Object newVal = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.Pipe");
            this.oObj.updateNumericObject(idx, newVal, 0);
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        catch (Exception e) {
            this.log.println("Unexpected exception:");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateNumericObject()", result);
    }

    protected int findColumnOfType(Class clz) {
        for (int i = 0; i < this.rowData.size(); ++i) {
            if (!clz.isInstance(this.rowData.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }
}

