/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbc;

import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XResultSetUpdate
extends MultiMethodTest {
    public XResultSetUpdate oObj = null;
    private UpdateTester tester = null;

    @Override
    public void before() throws StatusException {
        this.tester = (UpdateTester)this.tEnv.getObjRelation("XResultSetUpdate.UpdateTester");
        if (this.tester == null) {
            this.log.println("Required relation not found !!!");
            throw new StatusException("Required relation not found !!!", new NullPointerException());
        }
    }

    public void _deleteRow() {
        this.executeMethod("moveToCurrentRow()");
        this.executeMethod("updateRow()");
        this.executeMethod("cancelRowUpdates()");
        boolean result = true;
        try {
            int rowsBefore = this.tester.rowCount();
            this.oObj.deleteRow();
            int rowsAfter = this.tester.rowCount();
            result = rowsBefore == rowsAfter + 1;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("deleteRow()", result);
    }

    public void _updateRow() {
        this.executeMethod("moveToCurrentRow()");
        boolean result = true;
        try {
            this.tester.update();
            this.oObj.updateRow();
            result = this.tester.wasUpdated();
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("updateRow()", result);
    }

    public void _cancelRowUpdates() {
        this.executeMethod("moveToCurrentRow()");
        boolean result = true;
        try {
            this.tester.update();
            this.oObj.cancelRowUpdates();
            result = !this.tester.wasUpdated();
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("cancelRowUpdates()", result);
    }

    public void _moveToInsertRow() {
        boolean result = true;
        try {
            this.oObj.moveToInsertRow();
            result = this.tester.currentRow() < 1;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("moveToInsertRow()", result);
    }

    public void _moveToCurrentRow() {
        boolean result = true;
        try {
            this.oObj.moveToCurrentRow();
            result = this.tester.currentRow() >= 1;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("moveToCurrentRow()", result);
    }

    public void _insertRow() {
        this.executeMethod("moveToInsertRow()");
        boolean result = true;
        try {
            this.oObj.moveToCurrentRow();
            int rowsBefore = this.tester.rowCount();
            this.oObj.moveToInsertRow();
            XRowUpdate rowU = UnoRuntime.queryInterface(XRowUpdate.class, (Object)this.oObj);
            rowU.updateString(1, "open");
            rowU.updateInt(2, 5);
            rowU.updateDouble(5, 3.4);
            rowU.updateBoolean(10, true);
            this.oObj.insertRow();
            this.oObj.moveToCurrentRow();
            int rowsAfter = this.tester.rowCount();
            result = rowsBefore + 1 == rowsAfter;
        }
        catch (SQLException e) {
            e.printStackTrace(this.log);
            this.log.println("******" + e.getMessage());
            result = false;
        }
        this.tRes.tested("insertRow()", result);
    }

    @Override
    public void after() {
    }

    public static interface UpdateTester {
        public int rowCount() throws SQLException;

        public void update() throws SQLException;

        public boolean wasUpdated() throws SQLException;

        public int currentRow() throws SQLException;
    }
}

