/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbc;

import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;

public class _XResultSet
extends MultiMethodTest {
    public XResultSet oObj = null;

    @Override
    public void before() {
        try {
            this.oObj.last();
            this.log.println("Totally number of rows is " + this.oObj.getRow());
            this.oObj.first();
        }
        catch (SQLException e) {
            this.log.println("Ignored exception :");
            e.printStackTrace(this.log);
        }
        this.executeMethod("isBeforeFirst()");
        this.executeMethod("isAfterLast()");
        this.executeMethod("isLast()");
        this.executeMethod("isFirst()");
        this.executeMethod("next()");
        this.executeMethod("previous()");
    }

    public void _beforeFirst() {
        try {
            this.oObj.beforeFirst();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("beforeFirst()", false);
            return;
        }
        this.tRes.tested("beforeFirst()", true);
    }

    public void _isBeforeFirst() {
        this.requiredMethod("beforeFirst()");
        boolean result = true;
        try {
            result = this.oObj.isBeforeFirst();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("isBeforeFirst()", result);
    }

    public void _afterLast() {
        try {
            this.oObj.afterLast();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("afterLast()", false);
            return;
        }
        this.tRes.tested("afterLast()", true);
    }

    public void _isAfterLast() {
        this.requiredMethod("afterLast()");
        boolean result = true;
        try {
            result = this.oObj.isAfterLast();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("isAfterLast()", result);
    }

    public void _first() {
        try {
            this.oObj.first();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("first()", false);
            return;
        }
        this.tRes.tested("first()", true);
    }

    public void _isFirst() {
        this.requiredMethod("first()");
        boolean result = true;
        try {
            result = this.oObj.isFirst();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("isFirst()", result);
    }

    public void _last() {
        try {
            this.oObj.last();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("last()", false);
            return;
        }
        this.tRes.tested("last()", true);
    }

    public void _isLast() {
        this.requiredMethod("last()");
        boolean result = true;
        try {
            result = this.oObj.isLast();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("isLast()", result);
    }

    public void _absolute() {
        boolean result = true;
        try {
            this.oObj.absolute(1);
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("absolute()", result);
    }

    public void _getRow() {
        this.requiredMethod("absolute()");
        boolean result = true;
        try {
            result &= this.oObj.getRow() == 1;
        }
        catch (SQLException e) {
            this.log.println("Exception occured:");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("getRow()", result);
    }

    public void _next() {
        boolean result = true;
        try {
            int prevRow = this.oObj.getRow();
            this.oObj.next();
            this.log.println("Row was : " + prevRow + ", row is : " + this.oObj.getRow());
            result &= prevRow + 1 == this.oObj.getRow();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("next()", result);
    }

    public void _previous() {
        boolean result = true;
        try {
            int prevRow = this.oObj.getRow();
            this.oObj.previous();
            this.log.println("Row was : " + prevRow + ", row is : " + this.oObj.getRow());
            result &= prevRow - 1 == this.oObj.getRow();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("previous()", result);
    }

    public void _relative() {
        boolean result = true;
        try {
            this.oObj.first();
            int prevRow = this.oObj.getRow();
            this.oObj.relative(2);
            this.log.println("Row was : " + prevRow + ", row is : " + this.oObj.getRow());
            result &= prevRow + 2 == this.oObj.getRow();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("relative()", result);
    }

    public void _refreshRow() {
        XRowUpdate xRowUpdate = UnoRuntime.queryInterface(XRowUpdate.class, (Object)this.oObj);
        XRow xRow = UnoRuntime.queryInterface(XRow.class, (Object)this.oObj);
        if (xRowUpdate == null || xRow == null) {
            this.log.println("Test must be modified because XRow or XRowUpdate is't supported");
            this.log.println("Only call method");
            try {
                this.oObj.refreshRow();
                this.tRes.tested("refreshRow()", true);
            }
            catch (SQLException e) {
                this.log.println("Exception occured :");
                e.printStackTrace(this.log);
                this.tRes.tested("refreshRow()", false);
            }
        } else {
            this.log.println("Testing of refreshRow()...");
            try {
                String oldValue = xRow.getString(1);
                this.log.println("Old value: " + oldValue);
                xRowUpdate.updateString(1, "Test method refreshRow");
                this.log.println("New value: " + xRow.getString(1));
                this.oObj.refreshRow();
                String valAfterRefresh = xRow.getString(1);
                this.log.println("Value after refresh: " + valAfterRefresh);
                this.tRes.tested("refreshRow()", valAfterRefresh.equals(oldValue));
            }
            catch (SQLException e) {
                this.log.println("Exception occured :");
                e.printStackTrace(this.log);
                this.tRes.tested("refreshRow()", false);
            }
        }
    }

    public void _rowUpdated() {
        try {
            boolean res = this.oObj.rowUpdated();
            this.tRes.tested("rowUpdated()", true);
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("rowUpdated()", false);
        }
    }

    public void _rowInserted() {
        try {
            boolean res = this.oObj.rowInserted();
            this.tRes.tested("rowInserted()", true);
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("rowInserted()", false);
        }
    }

    public void _rowDeleted() {
        try {
            boolean res = this.oObj.rowDeleted();
            this.tRes.tested("rowDeleted()", true);
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("rowDeleted()", false);
        }
    }

    public void _getStatement() {
        try {
            boolean hasStatement = this.tEnv.getObjRelation("XResultSet.hasStatement") != null;
            Object res = this.oObj.getStatement();
            this.tRes.tested("getStatement()", hasStatement && res != null || !hasStatement);
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
            this.tRes.tested("getStatement()", false);
        }
    }

    @Override
    public void after() {
        this.log.println("Finally moving cursor to the first row ...");
        try {
            this.oObj.first();
        }
        catch (SQLException e) {
            this.log.println("Exception occured :");
            e.printStackTrace(this.log);
        }
    }
}

