/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.sdbc.DriverPropertyInfo;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XDriver;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDriver
extends MultiMethodTest {
    public XDriver oObj = null;
    String url = null;
    String wrongUrl = null;
    String nbu = null;
    PropertyValue[] info = null;

    @Override
    protected void before() {
        this.nbu = (String)this.tEnv.getObjRelation("NoBadURL");
        this.url = (String)this.tEnv.getObjRelation("XDriver.URL");
        if (this.url == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.URL'"));
        }
        this.wrongUrl = (String)this.tEnv.getObjRelation("XDriver.UNSUITABLE_URL");
        if (this.wrongUrl == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.WRONG_URL'"));
        }
        this.info = (PropertyValue[])this.tEnv.getObjRelation("XDriver.INFO");
        if (this.info == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.INFO'"));
        }
    }

    public void _connect() {
        boolean res = true;
        try {
            this.log.println("Trying to connect to " + this.url);
            XConnection connection = this.oObj.connect(this.url, this.info);
            res = connection != null;
            this.log.println("Connected? " + res);
            this.log.println("Trying to connect to " + this.wrongUrl);
            connection = this.oObj.connect(this.wrongUrl, this.info);
            this.log.println("Connected? " + !(res &= connection == null));
        }
        catch (SQLException e) {
            this.log.println("Unexpected exception");
            res &= false;
        }
        if (this.nbu == null) {
            try {
                String badUrl = this.url + "bla";
                this.log.println("Trying to connect to " + badUrl);
                this.oObj.connect(badUrl, this.info);
                res &= false;
                this.log.println("Expected exception isn't thrown");
            }
            catch (SQLException e) {
                this.log.println("Expected exception");
                res &= true;
            }
        }
        this.tRes.tested("connect()", res);
    }

    public void _acceptsURL() {
        boolean res = false;
        try {
            res = this.oObj.acceptsURL(this.url);
            this.log.println("Accepts " + this.url + "? " + res);
            this.log.println("Accepts " + this.wrongUrl + "? " + !(res &= !this.oObj.acceptsURL(this.wrongUrl)));
        }
        catch (SQLException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("acceptsURL()", res);
    }

    public void _getPropertyInfo() {
        this.requiredMethod("acceptsURL()");
        boolean res = false;
        DriverPropertyInfo[] dpi = null;
        try {
            dpi = this.oObj.getPropertyInfo(this.url, this.info);
        }
        catch (SQLException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res = false;
        }
        if (dpi != null) {
            res = true;
            this.log.println("Driver properties info:");
            for (int i = 0; i < dpi.length; ++i) {
                this.log.println("Property: " + dpi[i].Name);
                this.log.println("Description: " + dpi[i].Description);
                this.log.println("IsRequired? " + dpi[i].IsRequired);
                this.log.println("Value: " + dpi[i].Value);
                this.log.println("Choices: ");
                for (int j = 0; j < dpi[i].Choices.length; ++j) {
                    this.log.println("\t" + dpi[i].Choices[j]);
                }
            }
        }
        this.tRes.tested("getPropertyInfo()", res);
    }

    public void _getMajorVersion() {
        int majorVer = this.oObj.getMajorVersion();
        boolean res = majorVer >= 1;
        this.log.println("Major version " + majorVer);
        this.tRes.tested("getMajorVersion()", res);
    }

    public void _getMinorVersion() {
        int minorVer = this.oObj.getMinorVersion();
        boolean res = minorVer >= 0;
        this.log.println("Minor version " + minorVer);
        this.tRes.tested("getMinorVersion()", res);
    }
}

