/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdb;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.sdb.XSingleSelectQueryAnalyzer;
import com.sun.star.sdb.XSingleSelectQueryComposer;
import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XSingleSelectQueryComposer
extends MultiMethodTest {
    public XSingleSelectQueryComposer oObj = null;
    private String queryString = "SELECT * FROM \"biblio\"";
    private XSingleSelectQueryAnalyzer xQueryAna = null;
    private XPropertySet xProp = null;
    private String colName = null;

    @Override
    protected void before() throws Exception {
        this.xQueryAna = UnoRuntime.queryInterface(XSingleSelectQueryAnalyzer.class, this.tEnv.getObjRelation("xQueryAna"));
        if (this.xQueryAna == null) {
            throw new StatusException(Status.failed("Couldn't get object relation 'xQueryAna'. Test must be modified"));
        }
        this.xProp = UnoRuntime.queryInterface(XPropertySet.class, this.tEnv.getObjRelation("xProp"));
        if (this.xProp == null) {
            throw new StatusException(Status.failed("Couldn't get object relation 'xProp'. Test must be modified"));
        }
        this.colName = AnyConverter.toString((Object)this.tEnv.getObjRelation("colName"));
        if (this.colName == null) {
            throw new StatusException(Status.failed("Couldn't get object relation 'colName'. Test must be modified"));
        }
    }

    public void _setFilter() {
        try {
            String filter = "\"Identifier\" = 'BOR02b'";
            this.oObj.setFilter(filter);
            this.tRes.tested("setFilter()", this.xQueryAna.getFilter().equals(filter));
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("setFilter()", false);
        }
    }

    public void _setStructuredFilter() {
        this.requiredMethod("setFilter()");
        try {
            this.xQueryAna.setQuery("SELECT \"Identifier\", \"Type\", \"Address\" FROM \"biblio\" \"biblio\"");
            String complexFilter = "( \"Identifier\" = '1' AND \"Type\" = '4' ) OR ( \"Identifier\" = '2' AND \"Type\" = '5' ) OR ( \"Identifier\" = '3' AND \"Type\" = '6' AND \"Address\" = '7' ) OR ( \"Address\" = '8' ) OR ( \"Type\" = '9' )";
            this.oObj.setFilter(complexFilter);
            PropertyValue[][] aStructuredFilter = this.xQueryAna.getStructuredFilter();
            this.oObj.setFilter("");
            this.oObj.setStructuredFilter(aStructuredFilter);
            this.tRes.tested("setStructuredFilter()", this.xQueryAna.getFilter().equals(complexFilter));
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("setStructuredFilter()", false);
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("setStructuredFilter()", false);
        }
    }

    public void _appendFilterByColumn() {
        boolean ok = true;
        try {
            this.oObj.appendFilterByColumn(this.xProp, true);
            this.log.println("appendFilterByColumn: " + this.xQueryAna.getFilter());
            ok = ok && this.xQueryAna.getFilter().indexOf(this.colName) > 0;
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("appendFilterByColumn()", false);
        }
        try {
            this.oObj.appendFilterByColumn(this.xProp, false);
            this.log.println("appendFilterByColumn: " + this.xQueryAna.getFilter());
            ok = ok && this.xQueryAna.getFilter().indexOf(this.colName) > 0;
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("appendFilterByColumn()", false);
        }
        try {
            XPropertySet dummy = null;
            this.oObj.appendFilterByColumn(dummy, true);
            this.log.println("unexpected Exception was not thorwn");
            this.tRes.tested("appendFilterByColumn()", false);
        }
        catch (SQLException e) {
            this.log.println("expected Exception");
            ok = ok;
        }
        this.tRes.tested("appendFilterByColumn()", ok);
    }

    public void _appendGroupByColumn() {
        boolean ok = true;
        try {
            this.oObj.appendGroupByColumn(this.xProp);
            this.log.println("appendGroupByColumn: " + this.xQueryAna.getFilter());
            ok = ok && this.xQueryAna.getFilter().indexOf(this.colName) > 0;
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("appendGroupByColumn()", false);
        }
        try {
            XPropertySet dummy = null;
            this.oObj.appendGroupByColumn(dummy);
            this.log.println("unexpected Exception was not thorwn");
            this.tRes.tested("appendGroupByColumn()", false);
        }
        catch (SQLException e) {
            this.log.println("expected Exception");
            ok = ok;
        }
        this.tRes.tested("appendGroupByColumn()", ok);
    }

    public void _setGroup() {
        try {
            String group = "\"Identifier\"";
            this.oObj.setGroup(group);
            this.tRes.tested("setGroup()", this.xQueryAna.getGroup().equals(group));
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("setGroup()", false);
        }
    }

    public void _setHavingClause() {
        try {
            String clause = "\"Identifier\" = 'BOR02b'";
            this.oObj.setHavingClause(clause);
            this.tRes.tested("setHavingClause()", this.xQueryAna.getHavingClause().equals(clause));
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("setHavingClause()", false);
        }
    }

    public void _setStructuredHavingClause() {
        this.requiredMethod("setHavingClause()");
        this.executeMethod("setStructuredFilter()");
        String complexFilter = "( \"Identifier\" = '1' AND \"Type\" = '4' ) OR ( \"Identifier\" = '2' AND \"Type\" = '5' ) OR ( \"Identifier\" = '3' AND \"Type\" = '6' AND \"Address\" = '7' ) OR ( \"Address\" = '8' ) OR ( \"Type\" = '9' )";
        try {
            this.oObj.setHavingClause(complexFilter);
            PropertyValue[][] aStructuredHaving = this.xQueryAna.getStructuredHavingClause();
            this.oObj.setHavingClause("");
            this.oObj.setStructuredHavingClause(aStructuredHaving);
            this.tRes.tested("setStructuredHavingClause()", this.xQueryAna.getHavingClause().equals(complexFilter));
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("setStructuredHavingClause()", false);
        }
    }

    public void _appendHavingClauseByColumn() {
        boolean ok = true;
        try {
            this.oObj.appendHavingClauseByColumn(this.xProp, true);
            this.log.println("appendHavingClauseByColumn: " + this.xQueryAna.getFilter());
            ok = ok && this.xQueryAna.getFilter().indexOf(this.colName) > 0;
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("appendHavingClauseByColumn()", false);
        }
        try {
            XPropertySet dummy = null;
            this.oObj.appendHavingClauseByColumn(dummy, true);
            this.log.println("unexpected Exception was not thorwn");
            this.tRes.tested("appendHavingClauseByColumn()", false);
        }
        catch (SQLException e) {
            this.log.println("expected Exception");
            ok = ok;
        }
        this.tRes.tested("appendHavingClauseByColumn()", ok);
    }

    public void _appendOrderByColumn() {
        boolean ok = true;
        try {
            this.oObj.appendOrderByColumn(this.xProp, true);
            this.log.println("appendOrderByColumn: " + this.xQueryAna.getFilter());
            ok = ok && this.xQueryAna.getFilter().indexOf(this.colName) > 0;
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("appendOrderByColumn()", false);
        }
        try {
            XPropertySet dummy = null;
            this.oObj.appendOrderByColumn(dummy, true);
            this.log.println("unexpected Exception was not thorwn");
            this.tRes.tested("appendOrderByColumn()", false);
        }
        catch (SQLException e) {
            this.log.println("expected Exception");
            ok = ok;
        }
        this.tRes.tested("appendOrderByColumn()", ok);
    }

    public void _setOrder() {
        try {
            String order = "\"Identifier\"";
            this.oObj.setOrder(order);
            this.tRes.tested("setOrder()", this.xQueryAna.getOrder().equals(order));
        }
        catch (SQLException e) {
            this.log.println("unexpected Exception: " + e.toString());
            this.tRes.tested("setOrder()", false);
        }
    }
}

