/*
 * Decompiled with CFR 0.152.
 */
package ifc.script;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.ServiceNotRegisteredException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.ScriptEvent;
import com.sun.star.script.ScriptEventDescriptor;
import com.sun.star.script.XEventAttacherManager;
import com.sun.star.script.XScriptListener;
import com.sun.star.uno.Exception;
import lib.MultiMethodTest;

public class _XEventAttacherManager
extends MultiMethodTest {
    public XEventAttacherManager oObj = null;
    int index;
    ScriptEventDescriptor desc;
    ScriptEventDescriptor[] descs;
    Object attachedObject;
    XScriptListener listener;

    public void _insertEntry() {
        this.index = 0;
        try {
            this.oObj.insertEntry(this.index);
            this.tRes.tested("insertEntry()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("insertEntry(" + this.index + ") throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("insertEntry()", false);
        }
    }

    public void _registerScriptEvent() {
        this.requiredMethod("insertEntry()");
        this.desc = new ScriptEventDescriptor("XEventListener1", "disposing", "", "Basic", "");
        try {
            this.oObj.registerScriptEvent(this.index, this.desc);
            this.tRes.tested("registerScriptEvent()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("registerScriptEvent() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("registerScriptEvent()", false);
        }
    }

    public void _registerScriptEvents() {
        this.requiredMethod("insertEntry()");
        this.descs = new ScriptEventDescriptor[]{new ScriptEventDescriptor("XEventListener2", "disposing", "", "Basic", ""), new ScriptEventDescriptor("XEventListener3", "disposing", "", "Basic", "")};
        try {
            this.oObj.registerScriptEvents(this.index, this.descs);
            this.tRes.tested("registerScriptEvents()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("registerScriptEvents() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("registerScriptEvents()", false);
        }
    }

    public void _getScriptEvents() {
        ScriptEventDescriptor[] res;
        this.requiredMethod("registerScriptEvent()");
        this.requiredMethod("registerScriptEvents()");
        try {
            res = this.oObj.getScriptEvents(this.index);
        }
        catch (IllegalArgumentException e) {
            this.log.println("registerScriptEvents() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("registerScriptEvents()", false);
            return;
        }
        this.tRes.tested("getScriptEvents()", this.contains(res, this.desc) && this.containsArray(res, this.descs));
        this.log.println("Script events :");
        this.printEvents(res);
    }

    boolean contains(ScriptEventDescriptor[] container, ScriptEventDescriptor evt) {
        for (int i = 0; i < container.length; ++i) {
            if (!this.equal(container[i], evt)) continue;
            return true;
        }
        return false;
    }

    boolean containsArray(ScriptEventDescriptor[] container, ScriptEventDescriptor[] events) {
        for (int i = 0; i < events.length; ++i) {
            if (this.contains(container, events[i])) continue;
            return false;
        }
        return true;
    }

    boolean equal(ScriptEventDescriptor evt1, ScriptEventDescriptor evt2) {
        return evt1.ListenerType.equals(evt2.ListenerType) && evt1.EventMethod.equals(evt2.EventMethod) && evt1.ScriptType.equals(evt2.ScriptType) && evt1.ScriptCode.equals(evt2.ScriptCode) && evt1.AddListenerParam.equals(evt2.AddListenerParam);
    }

    void printEvent(ScriptEventDescriptor evt) {
        if (evt == null) {
            this.log.println("null");
        } else {
            this.log.println("\"" + evt.ListenerType + "\",\"" + evt.EventMethod + "\",\"" + evt.ScriptType + "\",\"" + evt.ScriptCode + "\",\"" + evt.AddListenerParam + "\"");
        }
    }

    void printEvents(ScriptEventDescriptor[] events) {
        if (events == null) {
            this.log.println("null");
        } else {
            for (int i = 0; i < events.length; ++i) {
                this.printEvent(events[i]);
            }
        }
    }

    public void _attach() {
        this.requiredMethod("insertEntry()");
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)this.tParam.getMSF();
            this.attachedObject = xMSF.createInstance("com.sun.star.reflection.TypeDescriptionProvider");
        }
        catch (Exception e) {
            this.log.println("Service not available");
            e.printStackTrace(this.log);
            this.tRes.tested("attach()", false);
            return;
        }
        try {
            this.oObj.attach(this.index, this.attachedObject, "param");
            this.tRes.tested("attach()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("attach() throws exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("attach()", false);
        }
        catch (ServiceNotRegisteredException e) {
            this.log.println("attach() throws exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("attach()", false);
        }
    }

    public void _detach() {
        this.requiredMethod("attach()");
        try {
            this.oObj.detach(this.index, this.attachedObject);
            this.tRes.tested("detach()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("detach() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("detach()", false);
        }
    }

    public void _revokeScriptEvent() {
        this.requiredMethod("registerScriptEvent()");
        this.executeMethod("getScriptEvents()");
        try {
            this.oObj.revokeScriptEvent(this.index, this.desc.ListenerType, this.desc.EventMethod, "");
            ScriptEventDescriptor[] res = this.oObj.getScriptEvents(this.index);
            this.tRes.tested("revokeScriptEvent()", !this.contains(res, this.desc));
            this.printEvents(res);
        }
        catch (IllegalArgumentException e) {
            this.log.println("revokeScriptEvent() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("revokeScriptEvent()", false);
        }
    }

    public void _revokeScriptEvents() {
        this.requiredMethod("revokeScriptEvent()");
        this.executeMethod("getScriptEvents()");
        try {
            this.oObj.revokeScriptEvents(this.index);
            ScriptEventDescriptor[] res = this.oObj.getScriptEvents(this.index);
            this.tRes.tested("revokeScriptEvents()", res == null || res.length == 0);
        }
        catch (IllegalArgumentException e) {
            this.log.println("revokeScriptEvents() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("revokeScriptEvents()", false);
        }
    }

    public void _removeEntry() {
        this.requiredMethod("insertEntry()");
        try {
            this.oObj.removeEntry(this.index);
            this.tRes.tested("removeEntry()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("removeEntry(" + this.index + ") throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("removeEntry()", false);
        }
    }

    public void _addScriptListener() {
        this.listener = new MyScriptListener();
        try {
            this.oObj.addScriptListener(this.listener);
            this.tRes.tested("addScriptListener()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("addScriptListener() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("addScriptListener()", false);
        }
    }

    public void _removeScriptListener() {
        this.requiredMethod("addScriptListener()");
        try {
            this.oObj.removeScriptListener(this.listener);
            this.tRes.tested("removeScriptListener()", true);
        }
        catch (IllegalArgumentException e) {
            this.log.println("removeScriptListener() throws unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            this.tRes.tested("removeScriptListener()", false);
        }
    }

    class MyScriptListener
    implements XScriptListener {
        MyScriptListener() {
        }

        @Override
        public void firing(ScriptEvent evt) {
        }

        @Override
        public Object approveFiring(ScriptEvent evt) {
            return evt.Helper;
        }

        @Override
        public void disposing(EventObject evt) {
        }
    }
}

