/*
 * Decompiled with CFR 0.152.
 */
package ifc.registry;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.MergeConflictException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.RegistryTools;

public class _XSimpleRegistry
extends MultiMethodTest {
    public XSimpleRegistry oObj = null;
    protected String nr = null;
    protected boolean configuration = false;
    protected String openF = null;
    protected String destroyF = null;
    protected String mergeF = null;

    @Override
    protected void before() {
        if (this.tEnv.getObjRelation("configuration") != null) {
            this.configuration = true;
        }
        this.nr = (String)this.tEnv.getObjRelation("NR");
        this.openF = (String)this.tEnv.getObjRelation("XSimpleRegistry.open");
        if (this.openF == null) {
            throw new StatusException(Status.failed("Relation 'XSimpleRegistry.open' not found"));
        }
        this.destroyF = (String)this.tEnv.getObjRelation("XSimpleRegistry.destroy");
        if (this.destroyF == null) {
            throw new StatusException(Status.failed("Relation 'XSimpleRegistry.destroy' not found"));
        }
        this.mergeF = (String)this.tEnv.getObjRelation("XSimpleRegistry.merge");
        if (this.mergeF == null) {
            throw new StatusException(Status.failed("Relation 'XSimpleRegistry.merge' not found"));
        }
    }

    public void _open() {
        if (this.nr != null) {
            this.log.println("'open()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("open()", true);
            return;
        }
        this.log.println("Trying to open registry :" + this.openF);
        try {
            this.oObj.open(this.openF, false, true);
            this.oObj.close();
        }
        catch (InvalidRegistryException e) {
            e.printStackTrace(this.log);
            this.tRes.tested("open()", false);
            return;
        }
        this.tRes.tested("open()", true);
    }

    public void _isReadOnly() {
        boolean result = false;
        try {
            this.openReg(this.oObj, this.openF, false, true);
            result = !this.oObj.isReadOnly();
            this.closeReg(this.oObj);
        }
        catch (InvalidRegistryException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("isReadOnly()", result);
    }

    public void _getRootKey() {
        boolean result = false;
        try {
            this.openReg(this.oObj, this.openF, false, true);
            XRegistryKey rootKey = this.oObj.getRootKey();
            result = rootKey != null;
            this.closeReg(this.oObj);
        }
        catch (InvalidRegistryException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("getRootKey()", result);
    }

    public void _mergeKey() {
        if (this.configuration) {
            this.log.println("You can't merge into this registry. It's just a wrapper for a configuration node, which has a fixed structure which can not be modified");
            this.tRes.tested("mergeKey()", true);
            return;
        }
        if (this.nr != null) {
            this.log.println("'mergeKey()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("mergeKey()", true);
            return;
        }
        this.openReg(this.oObj, this.openF, false, true);
        try {
            RegistryTools.printRegistryInfo(this.oObj.getRootKey(), this.log);
            this.oObj.mergeKey("MergeKey", this.mergeF);
            RegistryTools.printRegistryInfo(this.oObj.getRootKey(), this.log);
        }
        catch (MergeConflictException e) {
            e.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        catch (InvalidRegistryException e) {
            e.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        boolean isEqual = false;
        XSimpleRegistry reg = null;
        try {
            reg = RegistryTools.createRegistryService((XMultiServiceFactory)this.tParam.getMSF());
        }
        catch (Exception e) {
            this.log.print("Can't create registry service: ");
            e.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        this.openReg(reg, this.mergeF, false, true);
        try {
            XRegistryKey key = this.oObj.getRootKey().openKey("MergeKey");
            XRegistryKey mergeKey = reg.getRootKey();
            isEqual = RegistryTools.compareKeyTrees(key, mergeKey);
        }
        catch (InvalidRegistryException e) {
            this.log.print("Can't get root key: ");
            e.printStackTrace(this.log);
            this.tRes.tested("mergeKey()", false);
            return;
        }
        this.closeReg(reg);
        this.closeReg(this.oObj);
        this.tRes.tested("mergeKey()", isEqual);
    }

    public void _getURL() {
        this.openReg(this.oObj, this.openF, false, true);
        String url = this.oObj.getURL();
        this.closeReg(this.oObj);
        this.log.println("Getting URL: " + url + ";");
        this.tRes.tested("getURL()", url != null);
    }

    public void _close() {
        if (this.nr != null) {
            this.log.println("'close()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("close()", true);
            return;
        }
        try {
            this.oObj.open(this.openF, false, true);
            this.oObj.close();
        }
        catch (InvalidRegistryException e) {
            e.printStackTrace(this.log);
            this.tRes.tested("close()", false);
            return;
        }
        this.tRes.tested("close()", !this.oObj.isValid());
    }

    public void _destroy() {
        if (this.configuration) {
            this.log.println("This registry is a wrapper for a configuration access. It can not be destroyed.");
            this.tRes.tested("destroy()", true);
            return;
        }
        if (this.nr != null) {
            this.log.println("'destroy()' isn't supported by '" + this.nr + "'");
            this.tRes.tested("destroy()", true);
            return;
        }
        try {
            this.oObj.open(this.destroyF, false, true);
            this.oObj.destroy();
        }
        catch (InvalidRegistryException e) {
            e.printStackTrace(this.log);
            this.tRes.tested("destroy()", false);
            return;
        }
        this.tRes.tested("destroy()", !this.oObj.isValid());
    }

    public void _isValid() {
        boolean valid = true;
        this.openReg(this.oObj, this.openF, false, true);
        valid = this.oObj.isValid();
        this.closeReg(this.oObj);
        this.tRes.tested("isValid()", valid);
    }

    public void openReg(XSimpleRegistry reg, String url, boolean arg1, boolean arg2) {
        if (this.nr == null) {
            try {
                reg.open(url, arg1, arg2);
            }
            catch (InvalidRegistryException e) {
                this.log.print("Couldn't open registry:");
                e.printStackTrace(this.log);
            }
        }
    }

    public void closeReg(XSimpleRegistry reg) {
        if (this.nr == null) {
            try {
                reg.close();
            }
            catch (InvalidRegistryException e) {
                this.log.print("Couldn't close registry:");
                e.printStackTrace(this.log);
            }
        }
    }
}

