/*
 * Decompiled with CFR 0.152.
 */
package ifc.registry;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.CannotRegisterImplementationException;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XImplementationRegistration;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import lib.MultiMethodTest;
import util.RegistryTools;
import util.utils;

public class _XImplementationRegistration
extends MultiMethodTest {
    public XImplementationRegistration oObj = null;
    private String url = null;
    private String loader = null;
    private XSimpleRegistry reg = null;

    public void _registerImplementation() throws CannotRegisterImplementationException, RuntimeException {
        this.url = utils.getFullTestURL("qadevlibs/MyPersistObjectImpl.jar");
        this.loader = "com.sun.star.loader.Java2";
        boolean result = false;
        String name = null;
        try {
            name = utils.getOfficeTempDir((XMultiServiceFactory)this.tParam.getMSF()) + "XImplementationRegistration_tmp.rdb";
            this.reg = RegistryTools.openRegistry(name, (XMultiServiceFactory)this.tParam.getMSF());
            this.oObj.registerImplementation(this.loader, this.url, this.reg);
            RegistryTools.printRegistryInfo(this.reg.getRootKey(), this.log);
            String[] subKeys = this.reg.getRootKey().getKeyNames();
            result = subKeys != null && subKeys.length > 0;
        }
        catch (Exception e) {
            this.log.println("Can't open registry file: " + name);
            e.printStackTrace(this.log);
        }
        this.tRes.tested("registerImplementation()", result);
    }

    public void _getImplementations() throws RuntimeException {
        this.requiredMethod("registerImplementation()");
        String[] impl = this.oObj.getImplementations(this.loader, this.url);
        if (impl.length == 0) {
            this.log.println("getImplementations() returns an empty array");
        }
        boolean result = false;
        this.log.println("Implementations found :");
        for (int i = 0; i < impl.length; ++i) {
            this.log.println(" '" + impl[i] + "'");
            if (!"com.sun.star.cmp.MyPersistObject".equals(impl[i])) continue;
            result = true;
            break;
        }
        this.tRes.tested("getImplementations()", result);
    }

    public void _checkInstantiation() throws RuntimeException {
        this.requiredMethod("registerImplementation()");
        String[] inst = this.oObj.checkInstantiation("com.sun.star.comp.stoc.JavaComponentLoader");
        this.tRes.tested("checkInstantiation()", inst != null);
    }

    public void _revokeImplementation() throws RuntimeException {
        boolean result = false;
        this.requiredMethod("registerImplementation()");
        this.executeMethod("getImplementations()");
        this.executeMethod("checkInstantiation()");
        this.oObj.revokeImplementation(this.url, this.reg);
        RegistryTools.printRegistryInfo(this.reg, this.log);
        try {
            String[] subKeys = this.reg.getRootKey().getKeyNames();
            result = subKeys == null || subKeys.length == 0;
        }
        catch (InvalidRegistryException e) {
            this.log.println("!!! Exception retrieving keys from registry :");
            e.printStackTrace(this.log);
        }
        this.tRes.tested("revokeImplementation()", true);
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }
}

