/*
 * Decompiled with CFR 0.152.
 */
package ifc.loader;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.loader.CannotActivateFactoryException;
import com.sun.star.loader.XImplementationLoader;
import com.sun.star.registry.CannotRegisterImplementationException;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.StatusException;
import util.RegistryTools;
import util.utils;

public class _XImplementationLoader
extends MultiMethodTest {
    public XImplementationLoader oObj = null;
    private String implLoader = null;
    private String implUrl = null;
    private String implName = null;

    @Override
    public void before() {
        this.implLoader = (String)this.tEnv.getObjRelation("ImplementationLoader");
        this.implUrl = (String)this.tEnv.getObjRelation("ImplementationUrl");
        this.implName = (String)this.tEnv.getObjRelation("ImplementationName");
        if (this.implLoader == null || this.implUrl == null || this.implName == null) {
            throw new StatusException("One of object relations not found", new NullPointerException());
        }
    }

    public void _writeRegistryInfo() {
        String[] keys;
        boolean rc;
        XRegistryKey key;
        XSimpleRegistry xReg = null;
        String tmpDir = utils.getOfficeTempDir((XMultiServiceFactory)this.tParam.getMSF());
        try {
            xReg = RegistryTools.createRegistryService((XMultiServiceFactory)this.tParam.getMSF());
            xReg.open(tmpDir + "XImpLoader_tmp.rdb", false, true);
            key = xReg.getRootKey();
        }
        catch (Exception e) {
            this.log.println("Can not create registry for writing");
            e.printStackTrace(this.log);
            this.tRes.tested("writeRegistryInfo()", false);
            return;
        }
        try {
            rc = this.oObj.writeRegistryInfo(key, this.implLoader, this.implUrl);
        }
        catch (CannotRegisterImplementationException e) {
            throw new StatusException("Can not register implementation", e);
        }
        if (!rc) {
            this.log.println("Method returned false value");
        }
        try {
            keys = key.getKeyNames();
        }
        catch (Exception e) {
            this.log.println("Error retrieving key names from registry");
            this.tRes.tested("writeRegistryInfo()", false);
            return;
        }
        try {
            xReg.close();
            xReg.destroy();
        }
        catch (InvalidRegistryException e) {
            this.log.println("Can't destroy registry file.");
        }
        this.tRes.tested("writeRegistryInfo()", rc && keys.length > 0);
    }

    public void _activate() {
        boolean ok = true;
        XInterface factory = null;
        try {
            factory = (XInterface)this.oObj.activate(this.implName, this.implLoader, this.implUrl, null);
        }
        catch (CannotActivateFactoryException e) {
            throw new StatusException("Can not activate factory", e);
        }
        XServiceInfo xServInf = UnoRuntime.queryInterface(XServiceInfo.class, (Object)factory);
        if (xServInf == null) {
            if (factory == null) {
                this.log.println("activate() returns null - FAILED.");
            } else {
                this.log.println("Activated impementation doesn't support XServiceInfo - FAILED.");
            }
            ok = false;
        } else {
            String gImpName = xServInf.getImplementationName();
            this.log.println("Implementation name returned :" + gImpName);
            if (!gImpName.equals(this.implName)) {
                this.log.println("!!! But other name was expected :" + this.implName);
                ok = false;
            }
        }
        this.tRes.tested("activate()", ok);
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }
}

