/*
 * Decompiled with CFR 0.152.
 */
package ifc.linguistic2;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.Locale;
import com.sun.star.linguistic2.DictionaryListEvent;
import com.sun.star.linguistic2.DictionaryType;
import com.sun.star.linguistic2.XDictionary;
import com.sun.star.linguistic2.XDictionaryList;
import com.sun.star.linguistic2.XDictionaryListEventListener;
import lib.MultiMethodTest;

public class _XDictionaryList
extends MultiMethodTest {
    public XDictionaryList oObj = null;
    public XDictionary addedDic = null;
    public boolean listenerCalled = false;
    XDictionaryListEventListener listener = new MyDictionaryListEventListener();
    short count = 0;

    public void _getCount() {
        this.count = this.oObj.getCount();
        this.tRes.tested("getCount()", this.count > 0);
    }

    public void _getDictionaries() {
        boolean res;
        this.requiredMethod("getCount()");
        XDictionary[] dics = this.oObj.getDictionaries();
        boolean bl = res = dics.length == this.count;
        if (!res) {
            this.log.println("Expected: " + this.oObj.getCount());
            this.log.println("Gained: " + dics.length);
        }
        this.tRes.tested("getDictionaries()", res);
    }

    public void _addDictionaryListEventListener() {
        this.listenerCalled = false;
        XDictionary xDic = this.oObj.createDictionary("ListenDic", new Locale("en", "US", "WIN"), DictionaryType.POSITIVE, "");
        boolean res = this.oObj.addDictionaryListEventListener(this.listener, false);
        this.oObj.flushEvents();
        this.oObj.addDictionary(xDic);
        xDic.add("Positiv", false, "");
        xDic.setActive(true);
        this.oObj.flushEvents();
        this.oObj.removeDictionary(xDic);
        this.oObj.removeDictionaryListEventListener(this.listener);
        this.tRes.tested("addDictionaryListEventListener()", this.listenerCalled && res);
    }

    public void _removeDictionaryListEventListener() {
        this.listenerCalled = false;
        XDictionary xDic = this.oObj.createDictionary("ListenDic", new Locale("en", "US", "WIN"), DictionaryType.POSITIVE, "");
        this.oObj.addDictionaryListEventListener(this.listener, false);
        this.oObj.flushEvents();
        this.oObj.addDictionary(xDic);
        xDic.add("Positiv", false, "");
        xDic.setActive(true);
        this.listenerCalled = false;
        boolean res = this.oObj.removeDictionaryListEventListener(this.listener);
        this.oObj.flushEvents();
        this.oObj.removeDictionary(xDic);
        this.tRes.tested("removeDictionaryListEventListener()", !this.listenerCalled && res);
    }

    public void _addDictionary() {
        short previous = this.oObj.getCount();
        this.addedDic = this.oObj.createDictionary("AddedDic", new Locale("en", "US", "WIN"), DictionaryType.POSITIVE, "");
        this.addedDic.add("Positiv", false, "");
        this.oObj.addDictionary(this.addedDic);
        short after = this.oObj.getCount();
        this.tRes.tested("addDictionary()", after > previous);
    }

    public void _removeDictionary() {
        short previous = this.oObj.getCount();
        this.oObj.removeDictionary(this.addedDic);
        short after = this.oObj.getCount();
        this.tRes.tested("removeDictionary()", after < previous);
    }

    public void _getDictionaryByName() {
        XDictionary getting = this.oObj.getDictionaryByName("NegativDic");
        this.tRes.tested("getDictionaryByName()", getting != null);
    }

    public void _createDictionary() {
        XDictionary tmpDic = this.oObj.createDictionary("AddedDic", new Locale("en", "US", "WIN"), DictionaryType.POSITIVE, "");
        this.tRes.tested("createDictionary()", tmpDic != null);
    }

    public void _beginCollectEvents() {
        this.listenerCalled = false;
        XDictionary xDic = this.oObj.createDictionary("ListenDic", new Locale("en", "US", "WIN"), DictionaryType.POSITIVE, "");
        this.oObj.addDictionaryListEventListener(this.listener, false);
        this.oObj.beginCollectEvents();
        this.oObj.addDictionary(xDic);
        xDic.add("Positiv", false, "");
        xDic.setActive(true);
        this.oObj.removeDictionary(xDic);
        this.oObj.endCollectEvents();
        this.oObj.removeDictionaryListEventListener(this.listener);
        this.tRes.tested("beginCollectEvents()", this.listenerCalled);
    }

    public void _flushEvents() {
        this.requiredMethod("addDictionaryListEventListener()");
        this.tRes.tested("flushEvents()", true);
    }

    public void _endCollectEvents() {
        this.requiredMethod("beginCollectEvents()");
        this.tRes.tested("endCollectEvents()", true);
    }

    public class MyDictionaryListEventListener
    implements XDictionaryListEventListener {
        @Override
        public void disposing(EventObject oEvent) {
            _XDictionaryList.this.log.println("Listener has been disposed");
        }

        @Override
        public void processDictionaryListEvent(DictionaryListEvent aDicEvent) {
            _XDictionaryList.this.listenerCalled = true;
        }
    }
}

