/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.io.IOException;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XObjectInputStream;
import com.sun.star.io.XObjectOutputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XPersistObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import util.ValueComparer;
import util.dbg;
import util.utils;

public class _XPersistObject
extends MultiMethodTest {
    public XPersistObject oObj = null;
    XObjectInputStream iStream = null;
    XObjectOutputStream oStream = null;
    String sname = null;
    boolean result = true;

    public void _getServiceName() {
        this.result = true;
        this.sname = this.oObj.getServiceName();
        this.log.println("Method returned '" + this.sname + "'");
        String objName = (String)this.tEnv.getObjRelation("OBJNAME");
        if (objName == null) {
            this.log.println("No OBJNAME relation!");
            this.result = false;
        } else {
            this.result &= this.sname.equals(objName);
            if (!this.result) {
                this.log.println("Name of object must be '" + objName + "' but returned name is '" + this.sname + "'");
            }
        }
        this.tRes.tested("getServiceName()", this.result);
    }

    public void _read() {
        this.requiredMethod("getServiceName()");
        this.requiredMethod("write()");
        boolean bResult = true;
        try {
            Object noPS = this.tEnv.getObjRelation("noPS");
            if (noPS == null) {
                XPropertySet objps = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oObj);
                XPropertySetInfo objpsi = objps.getPropertySetInfo();
                Property[] objprops = objpsi.getProperties();
                Object oCopy = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance(this.sname);
                XPersistObject persCopy = UnoRuntime.queryInterface(XPersistObject.class, oCopy);
                persCopy.read(this.iStream);
                XPropertySet copyps = UnoRuntime.queryInterface(XPropertySet.class, oCopy);
                XPropertySetInfo copypsi = copyps.getPropertySetInfo();
                Property[] copyprops = copypsi.getProperties();
                for (int i = 0; i < copyprops.length; ++i) {
                    Object pseudo;
                    Object ops;
                    boolean locRes;
                    Object cps = copyps.getPropertyValue(copyprops[i].Name);
                    boolean bl = locRes = ValueComparer.equalValue(cps, ops = objps.getPropertyValue(objprops[i].Name)) || utils.isVoid(cps) && utils.isVoid(ops);
                    if (_XPersistObject.isTransient(objprops[i])) {
                        locRes = true;
                    }
                    if ((pseudo = this.tEnv.getObjRelation("PSEUDOPERSISTENT")) != null && !locRes) {
                        String str = copyprops[i].Name;
                        boolean bl2 = locRes = str.equals("Time") || str.equals("Date") || str.equals("FormatsSupplier") || str.equals("Text") || str.equals("Value") || str.indexOf("UserDefined") > 0;
                    }
                    if (!locRes) {
                        this.log.println("Property '" + copyprops[i].Name + "' failed");
                        dbg.printPropertyInfo(objps, objprops[i].Name, this.log);
                        dbg.printPropertyInfo(copyps, copyprops[i].Name, this.log);
                    }
                    bResult &= locRes;
                }
            } else {
                Object oCopy = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance(this.sname);
                XPersistObject persCopy = UnoRuntime.queryInterface(XPersistObject.class, oCopy);
                persCopy.read(this.iStream);
                bResult = persCopy.getServiceName().equals(this.sname);
            }
        }
        catch (Exception e) {
            this.log.println("Exception occured : ");
            e.printStackTrace(this.log);
            bResult = false;
        }
        this.tRes.tested("read()", bResult);
    }

    public void _write() {
        boolean bResult = true;
        try {
            this.initPipe();
            this.oObj.write(this.oStream);
        }
        catch (IOException e) {
            this.log.println("Exception occured while test. " + e);
            bResult = false;
        }
        this.tRes.tested("write()", bResult);
    }

    protected void initPipe() {
        try {
            Object aPipe = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.Pipe");
            Object istream = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.ObjectInputStream");
            Object ostream = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.ObjectOutputStream");
            Object mistream = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.MarkableInputStream");
            Object mostream = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.io.MarkableOutputStream");
            XActiveDataSink xdSi = UnoRuntime.queryInterface(XActiveDataSink.class, istream);
            XActiveDataSource xdSo = UnoRuntime.queryInterface(XActiveDataSource.class, ostream);
            XActiveDataSink xdSmi = UnoRuntime.queryInterface(XActiveDataSink.class, mistream);
            XActiveDataSource xdSmo = UnoRuntime.queryInterface(XActiveDataSource.class, mostream);
            XInputStream miStream = UnoRuntime.queryInterface(XInputStream.class, mistream);
            XOutputStream moStream = UnoRuntime.queryInterface(XOutputStream.class, mostream);
            XInputStream PipeIn = UnoRuntime.queryInterface(XInputStream.class, aPipe);
            XOutputStream PipeOut = UnoRuntime.queryInterface(XOutputStream.class, aPipe);
            xdSi.setInputStream(miStream);
            xdSo.setOutputStream(moStream);
            xdSmi.setInputStream(PipeIn);
            xdSmo.setOutputStream(PipeOut);
            this.iStream = UnoRuntime.queryInterface(XObjectInputStream.class, istream);
            this.oStream = UnoRuntime.queryInterface(XObjectOutputStream.class, ostream);
        }
        catch (Exception e) {
            System.out.println("exc " + e);
        }
    }

    public static boolean isTransient(Property prop) {
        short attr = prop.Attributes;
        return (attr & 8) != 0;
    }
}

