/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XOutputStream
extends MultiMethodTest {
    public XOutputStream oObj = null;
    StreamChecker checker = null;
    byte[] data = null;

    @Override
    protected void before() {
        this.checker = (StreamChecker)this.tEnv.getObjRelation("XOutputStream.StreamChecker");
        if (this.checker == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XOutputStream.StreamChecker'"));
        }
        this.data = (byte[])this.tEnv.getObjRelation("ByteData");
        if (this.data == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'ByteData'"));
        }
    }

    public void _writeBytes() {
        boolean res = true;
        try {
            this.oObj.writeBytes(this.data);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            res = false;
        }
        XInputStream xInStream = this.checker.getInStream();
        byte[][] readData = new byte[1][this.data.length];
        int iReadBytes = 0;
        try {
            iReadBytes = xInStream.readBytes(readData, this.data.length);
        }
        catch (IOException e) {
            this.log.println("Couldn't read data:" + e);
            res = false;
        }
        for (int i = 0; i < readData[0].length; ++i) {
            this.log.println("Expected: " + this.data[i] + ", actual is " + readData[0][i]);
            res &= readData[0][i] == this.data[i];
        }
        this.tRes.tested("writeBytes()", res);
    }

    public void _flush() {
        boolean res;
        this.requiredMethod("writeBytes()");
        try {
            this.oObj.flush();
            res = true;
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("flush()", res);
    }

    public void _closeOutput() {
        boolean res;
        this.requiredMethod("writeBytes()");
        this.executeMethod("flush()");
        try {
            this.oObj.closeOutput();
            res = true;
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            res = false;
        }
        this.log.println("This method is called in main module");
        this.tRes.tested("closeOutput()", res);
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }

    public static interface StreamChecker {
        public XInputStream getInStream();

        public void resetStreams();
    }
}

