/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.beans.Property;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.io.IOException;
import com.sun.star.io.XObjectInputStream;
import com.sun.star.io.XObjectOutputStream;
import com.sun.star.io.XPersistObject;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueComparer;

public class _XObjectInputStream
extends MultiMethodTest {
    public XObjectInputStream oObj = null;
    private Object objRead = null;
    private Object objWrite = null;

    public void _readObject() {
        this.objWrite = this.tEnv.getObjRelation("PersistObject");
        if (this.objWrite == null) {
            this.log.println("PersistObject not found in relations");
            this.tRes.tested("readObject()", false);
            return;
        }
        try {
            XObjectOutputStream oStream = (XObjectOutputStream)this.tEnv.getObjRelation("StreamWriter");
            oStream.writeObject((XPersistObject)this.objWrite);
        }
        catch (IOException e) {
            this.log.println("Couldn't write object to stream");
            e.printStackTrace(this.log);
            this.tRes.tested("readObject()", Status.skipped(false));
            return;
        }
        try {
            this.objRead = this.oObj.readObject();
        }
        catch (IOException e) {
            this.log.println("Couldn't read object from stream");
            e.printStackTrace(this.log);
            this.tRes.tested("readObject()", false);
            return;
        }
        if (this.objRead == null) {
            this.log.println("No object was read.");
            this.tRes.tested("readObject()", false);
            return;
        }
        XPropertySet props1 = null;
        XPropertySet props2 = null;
        props1 = UnoRuntime.queryInterface(XPropertySet.class, this.objRead);
        props2 = UnoRuntime.queryInterface(XPropertySet.class, this.objWrite);
        if (props1 == null) {
            this.log.println("Object read doesn't implement XPropertySet");
            this.tRes.tested("readObject()", false);
            return;
        }
        if (props2 == null) {
            this.log.println("Object written doesn't implement XPropertySet");
            this.tRes.tested("readObject()", false);
            return;
        }
        this.tRes.tested("readObject()", this.compareProperties(props1, props2));
    }

    protected boolean compareProperties(XPropertySet props1, XPropertySet props2) {
        Property[] p2;
        Property[] p1 = props1.getPropertySetInfo().getProperties();
        if (p1.length != (p2 = props2.getPropertySetInfo().getProperties()).length) {
            this.log.println("Number of properties differs");
            return false;
        }
        boolean result = true;
        for (int i = 0; i < p1.length; ++i) {
            String propName = p1[i].Name;
            this.log.print("Comparing property '" + propName + "' ...");
            boolean res = false;
            try {
                res = ValueComparer.equalValue(props1.getPropertyValue(propName), props2.getPropertyValue(propName));
            }
            catch (UnknownPropertyException e) {
                this.log.println("Not found !");
            }
            catch (WrappedTargetException e) {
                this.log.println(e);
            }
            if (res) {
                this.log.println("OK.");
            } else {
                this.log.println("Different !");
            }
            result &= res;
        }
        return result;
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }
}

