/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.Status;

public class _XInputStream
extends MultiMethodTest {
    public XInputStream oObj = null;
    public XOutputStream oStream = null;
    byte[] bytes = null;
    int bytesReady = 0;

    @Override
    public void before() {
        XInterface x = (XInterface)this.tEnv.getObjRelation("StreamWriter");
        this.oStream = UnoRuntime.queryInterface(XOutputStream.class, (Object)x);
        this.bytes = (byte[])this.tEnv.getObjRelation("ByteData");
        try {
            this.oStream.writeBytes(this.bytes);
        }
        catch (NotConnectedException e) {
        }
        catch (BufferSizeExceededException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void after() {
        try {
            this.oStream.flush();
            this.oStream.closeOutput();
        }
        catch (NotConnectedException e) {
        }
        catch (BufferSizeExceededException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disposeEnvironment();
    }

    public void _available() {
        boolean result = true;
        try {
            this.bytesReady = this.oObj.available();
            this.log.println("Bytes available :" + this.bytesReady);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("available()", result);
    }

    public void _readBytes() {
        this.requiredMethod("available()");
        if (this.bytesReady-- > 0) {
            boolean result;
            try {
                byte[][] data = new byte[1][1];
                int read = this.oObj.readBytes(data, 1);
                result = read == 1 && data != null && data.length == 1;
            }
            catch (IOException e) {
                e.printStackTrace(this.log);
                result = false;
            }
            this.tRes.tested("readBytes()", result);
        } else {
            this.log.println("No more bytes available in the stream");
            this.tRes.tested("readBytes()", Status.skipped(false));
        }
    }

    public void _readSomeBytes() {
        this.requiredMethod("available()");
        if (this.bytesReady-- > 0) {
            boolean result;
            try {
                byte[][] data = new byte[1][1];
                int read = this.oObj.readSomeBytes(data, 1);
                result = read == 1 && data != null && data.length == 1;
            }
            catch (IOException e) {
                e.printStackTrace(this.log);
                result = false;
            }
            this.tRes.tested("readSomeBytes()", result);
        } else {
            this.log.println("No more bytes available in the stream");
            this.tRes.tested("readBytes()", Status.skipped(false));
        }
    }

    public void _skipBytes() {
        this.requiredMethod("available()");
        if (this.bytesReady-- > 0) {
            boolean result;
            try {
                this.oObj.skipBytes(1);
                result = true;
            }
            catch (IOException e) {
                e.printStackTrace(this.log);
                result = false;
            }
            this.tRes.tested("skipBytes()", result);
        } else {
            this.log.println("No more bytes available in the stream");
            this.tRes.tested("readBytes()", Status.skipped(false));
        }
    }

    public void _closeInput() {
        this.executeMethod("available()");
        this.executeMethod("readBytes()");
        this.executeMethod("readSomeBytes()");
        this.executeMethod("skipBytes()");
        boolean result = true;
        try {
            this.oObj.closeInput();
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("closeInput()", result);
        this.disposeEnvironment();
    }
}

