/*
 * Decompiled with CFR 0.152.
 */
package ifc.io;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XDataInputStream;
import com.sun.star.io.XDataOutputStream;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDataInputStream
extends MultiMethodTest {
    public XDataInputStream oObj = null;
    public XDataOutputStream oStream = null;
    private boolean writeBoolean;
    private byte writeByte;
    private char writeChar;
    private double writeDouble;
    private float writeFloat;
    private long writeHyper;
    private int writeLong;
    private short writeShort;
    private String writeUTF;

    @Override
    public void before() {
        XInterface x = (XInterface)this.tEnv.getObjRelation("StreamWriter");
        this.oStream = UnoRuntime.queryInterface(XDataOutputStream.class, (Object)x);
        Vector data = (Vector)this.tEnv.getObjRelation("StreamData");
        if (data == null || this.oStream == null) {
            throw new StatusException(Status.failed("Object relation not found."));
        }
        Object dataElem = null;
        for (int i = 0; i < data.size(); ++i) {
            dataElem = data.get(i);
            if (dataElem instanceof Boolean) {
                this.writeBoolean = dataElem;
                continue;
            }
            if (dataElem instanceof Byte) {
                this.writeByte = dataElem;
                continue;
            }
            if (dataElem instanceof Character) {
                this.writeChar = ((Character)dataElem).charValue();
                continue;
            }
            if (dataElem instanceof Short) {
                this.writeShort = dataElem;
                continue;
            }
            if (dataElem instanceof Integer) {
                this.writeLong = dataElem;
                continue;
            }
            if (dataElem instanceof Long) {
                this.writeHyper = dataElem;
                continue;
            }
            if (dataElem instanceof Float) {
                this.writeFloat = ((Float)dataElem).floatValue();
                continue;
            }
            if (dataElem instanceof Double) {
                this.writeDouble = dataElem;
                continue;
            }
            if (!(dataElem instanceof String)) continue;
            this.writeUTF = dataElem;
        }
    }

    public void _readBoolean() {
        boolean res = true;
        try {
            this.oStream.writeBoolean(this.writeBoolean);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            byte readElem = this.oObj.readBoolean();
            boolean bl = res = readElem != 0 == this.writeBoolean;
            if (!res) {
                this.log.println("Must be read " + this.writeBoolean + " but was read " + (readElem != 0));
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't  read Boolean from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readBoolean()", res);
    }

    public void _readByte() {
        boolean res = true;
        try {
            this.oStream.writeByte(this.writeByte);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            byte readElem = this.oObj.readByte();
            boolean bl = res = readElem == this.writeByte;
            if (!res) {
                this.log.println("Must be read " + this.writeByte + " but was read " + readElem);
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read Byte from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readByte()", res);
    }

    public void _readChar() {
        boolean res = true;
        try {
            this.oStream.writeChar(this.writeChar);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            char readElem = this.oObj.readChar();
            boolean bl = res = readElem == this.writeChar;
            if (!res) {
                this.log.println("Must be read " + this.writeChar + " but was read " + readElem);
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read Char from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readChar()", res);
    }

    public void _readShort() {
        boolean res = true;
        try {
            this.oStream.writeShort(this.writeShort);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            short readElem = this.oObj.readShort();
            boolean bl = res = readElem == this.writeShort;
            if (!res) {
                this.log.println("Must be read " + this.writeShort + " but was read " + readElem);
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read Short from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readShort()", res);
    }

    public void _readLong() {
        try {
            this.oStream.writeLong(this.writeLong);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        boolean res = true;
        try {
            int readElem = this.oObj.readLong();
            boolean bl = res = readElem == this.writeLong;
            if (!res) {
                this.log.println("Must be read " + this.writeLong + " but was read " + readElem);
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read Long from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readLong()", res);
    }

    public void _readHyper() {
        boolean res = true;
        try {
            this.oStream.writeHyper(this.writeHyper);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            long readElem = this.oObj.readHyper();
            boolean bl = res = readElem == this.writeHyper;
            if (!res) {
                this.log.println("Must be read " + this.writeHyper + " but was read " + readElem);
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read Hyper from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readHyper()", res);
    }

    public void _readFloat() {
        boolean res = true;
        try {
            this.oStream.writeFloat(this.writeFloat);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            float readElem = this.oObj.readFloat();
            boolean bl = res = readElem == this.writeFloat;
            if (!res) {
                this.log.println("Must be read " + this.writeFloat + " but was read " + readElem);
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read Float from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readFloat()", res);
    }

    public void _readDouble() {
        boolean res = true;
        try {
            this.oStream.writeDouble(this.writeDouble);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            double readElem = this.oObj.readDouble();
            boolean bl = res = readElem == this.writeDouble;
            if (!res) {
                this.log.println("Must be read " + this.writeDouble + " but was read " + readElem);
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read Double from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readDouble()", res);
    }

    public void _readUTF() {
        boolean res = true;
        try {
            this.oStream.writeUTF(this.writeUTF);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't write data to the stream", e);
        }
        try {
            String readElem = this.oObj.readUTF();
            res = this.writeUTF.equals(readElem);
            if (!res) {
                this.log.println("Must be read '" + this.writeUTF + "' but was read '" + readElem + "'");
            }
        }
        catch (IOException e) {
            this.log.println("Couldn't read String from stream");
            e.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("readUTF()", res);
    }

    @Override
    public void after() {
        try {
            this.oStream.flush();
        }
        catch (NotConnectedException e) {
            e.printStackTrace(this.log);
        }
        catch (BufferSizeExceededException e) {
            e.printStackTrace(this.log);
        }
        catch (IOException e) {
            e.printStackTrace(this.log);
        }
        this.disposeEnvironment();
    }
}

