/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.TransliterationModules;
import com.sun.star.i18n.TransliterationModulesNew;
import com.sun.star.i18n.XTransliteration;
import com.sun.star.lang.Locale;
import lib.MultiMethodTest;

public class _XTransliteration
extends MultiMethodTest {
    public XTransliteration oObj = null;
    private String[] mod = null;
    private Locale loc = new Locale("en", "EN", "");

    public void _getAvailableModules() {
        this.mod = this.oObj.getAvailableModules(this.loc, (short)1);
        if (this.mod != null) {
            this.log.println("Available modules :");
            for (int i = 0; i < this.mod.length; ++i) {
                this.log.println("  '" + this.mod[i] + "'");
            }
        } else {
            this.log.println("!!! NULL returned !!!");
        }
        this.tRes.tested("getAvailableModules()", this.mod != null && this.mod.length > 0);
    }

    public void _loadModule() {
        this.log.println("Load module IGNORE_CASE");
        this.oObj.loadModule(TransliterationModules.IGNORE_CASE, this.loc);
        String name = this.oObj.getName();
        boolean res = name.equals("case ignore (generic)");
        this.log.println("getName return: " + name);
        this.tRes.tested("loadModule()", res);
    }

    public void _loadModuleNew() {
        boolean result = true;
        this.oObj.loadModuleNew(new TransliterationModulesNew[]{TransliterationModulesNew.LOWERCASE_UPPERCASE}, this.loc);
        String name = this.oObj.getName();
        result = name.equals("lower_to_upper(generic)");
        this.log.println("getName return: " + name);
        this.tRes.tested("loadModuleNew()", result);
    }

    public void _loadModuleByImplName() {
        this.log.println("Load module LOWERCASE_UPPERCASE");
        this.oObj.loadModuleByImplName("LOWERCASE_UPPERCASE", this.loc);
        String name = this.oObj.getName();
        boolean res = name.equals("lower_to_upper(generic)");
        this.log.println("getName return: " + name);
        this.tRes.tested("loadModuleByImplName()", res);
    }

    public void _loadModulesByImplNames() {
        this.log.println("Load module UPPERCASE_LOWERCASE");
        this.oObj.loadModulesByImplNames(new String[]{"UPPERCASE_LOWERCASE"}, this.loc);
        String name = this.oObj.getName();
        boolean res = name.equals("upper_to_lower(generic)");
        this.log.println("getName return: " + name);
        this.tRes.tested("loadModulesByImplNames()", res);
    }

    public void _getType() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        boolean result = this.oObj.getType() == 1;
        this.tRes.tested("getType()", result);
    }

    public void _getName() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        String name = this.oObj.getName();
        boolean res = name.equals("lower_to_upper(generic)");
        this.log.println("getName return: " + name);
        this.tRes.tested("getName()", res);
    }

    public void _transliterate() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        int[][] offs = new int[1][];
        String out = this.oObj.transliterate("AaBbCc", 1, 4, offs);
        boolean result = "ABBC".equals(out) && offs[0].length == 4 && offs[0][0] == 1 && offs[0][1] == 2 && offs[0][2] == 3 && offs[0][3] == 4;
        this.tRes.tested("transliterate()", result);
    }

    public void _transliterateRange() {
        boolean bOK;
        this.oObj.loadModule(TransliterationModules.IGNORE_CASE, this.loc);
        String[] out = this.oObj.transliterateRange("a", "i");
        this.log.println("transliterateRange return:");
        for (int i = 0; i < out.length; ++i) {
            this.log.println(out[i]);
        }
        boolean bl = bOK = out != null && out.length == 4 && "A".equals(out[0]) && "I".equals(out[1]) && "a".equals(out[2]) && "i".equals(out[3]) || "a".equals(out[0]) && "i".equals(out[1]) && "A".equals(out[2]) && "I".equals(out[3]);
        if (!bOK) {
            this.log.println("Unexpected range returned :");
            for (int i = 0; i < out.length; ++i) {
                this.log.print("'" + out[i] + "', ");
            }
            this.log.println();
        }
        this.tRes.tested("transliterateRange()", bOK);
    }

    public void _folding() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        int[][] offs = new int[1][];
        String out = this.oObj.folding("AaBbCc", 1, 4, offs);
        boolean result = "ABBC".equals(out) && offs[0].length == 4 && offs[0][0] == 1 && offs[0][1] == 2 && offs[0][2] == 3 && offs[0][3] == 4;
        this.tRes.tested("folding()", result);
    }

    public void _equals() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        int[] match1 = new int[1];
        int[] match2 = new int[1];
        boolean res = this.oObj.equals("aAbBcC", 1, 3, match1, "aAbBcC", 1, 3, match2);
        this.log.println("Returned : " + res + " Match1 = " + match1[0] + " Match2 = " + match2[0]);
        this.tRes.tested("equals()", res);
    }

    public void _compareSubstring() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        boolean result = true;
        result &= this.testSubstring("", 0, 0, "", 0, 0, 0);
        result &= this.testSubstring("aa", 1, 0, "", 0, 0, 0);
        result &= this.testSubstring("aa", 1, 0, "aa", 2, 0, 0);
        result &= this.testSubstring("a", 0, 1, "a", 0, 1, 0);
        result &= this.testSubstring("ab", 0, 2, "ab", 0, 2, 0);
        result &= this.testSubstring("abc", 1, 2, "abc", 1, 2, 0);
        result &= this.testSubstring("abcdef", 0, 3, "123abc", 3, 3, 0);
        result &= this.testSubstring("abcdef", 1, 1, "123abc", 4, 1, 0);
        result &= this.testSubstring("a", 0, 1, "a", 0, 0, 1);
        result &= this.testSubstring("aaa", 1, 1, "", 0, 0, 1);
        result &= this.testSubstring("bbb", 2, 1, "aaa", 2, 1, 1);
        result &= this.testSubstring("abc", 0, 3, "abc", 0, 2, 1);
        this.tRes.tested("compareSubstring()", result &= this.testSubstring("bbc", 1, 2, "bbc", 0, 2, 1));
    }

    private boolean testSubstring(String str1, int p1, int len1, String str2, int p2, int len2, int expRes) {
        boolean ret = true;
        int res = -666;
        try {
            res = this.oObj.compareSubstring(str1, p1, len1, str2, p2, len2);
        }
        catch (NullPointerException e) {
            this.log.println("Exception while method calling occurs :" + e);
        }
        if (res != expRes) {
            this.log.print("Comparing FAILED; return: " + res + ", expected: " + expRes + " ");
            ret = false;
        } else {
            this.log.print("Comparing OK : ");
        }
        this.log.println("('" + str1 + "', " + p1 + ", " + len1 + ", '" + str2 + "', " + p2 + ", " + len2 + ")");
        res = -666;
        try {
            res = this.oObj.compareSubstring(str2, p2, len2, str1, p1, len1);
        }
        catch (NullPointerException e) {
            this.log.println("Exception while method calling occurs :" + e);
        }
        if (res != -expRes) {
            this.log.print("Comparing FAILED; return: " + res + ", expected: " + -expRes + " ");
            ret = false;
        } else {
            this.log.print("Comparing OK :");
        }
        this.log.println("('" + str2 + "', " + p2 + ", " + len2 + ", '" + str1 + "', " + p1 + ", " + len1 + ")");
        return ret;
    }

    public void _compareString() {
        this.oObj.loadModule(TransliterationModules.LOWERCASE_UPPERCASE, this.loc);
        boolean result = true;
        result &= this.testString("", "", 0);
        result &= this.testString("a", "", 1);
        result &= this.testString("a", "a", 0);
        result &= this.testString("A", "a", 0);
        result &= this.testString("b", "a", 1);
        result &= this.testString("\n", "\n", 0);
        result &= this.testString("\n", "\t", 1);
        result &= this.testString("aaa", "aaa", 0);
        result &= this.testString("aaA", "aaa", 0);
        result &= this.testString("aaa", "aa", 1);
        result &= this.testString("ab", "aaa", 1);
        result &= this.testString("aba", "aa", 1);
        result &= this.testString("aaa\t\na", "aaa\t\na", 0);
        this.tRes.tested("compareString()", result &= this.testString("aaa\t\nb", "aaa\t\na", 1));
    }

    protected boolean testString(String str1, String str2, int expRes) {
        if (expRes == 0) {
            return this.testString(str1, str2, expRes, false);
        }
        return this.testString(str1, str2, expRes, true);
    }

    private boolean testString(String str1, String str2, int expRes, boolean testReverse) {
        boolean ret = true;
        int res = -666;
        try {
            res = this.oObj.compareString(str1, str2);
        }
        catch (NullPointerException e) {
            this.log.println("Exception while method calling occurs :" + e);
        }
        if (res == expRes) {
            this.log.println("Comparing of '" + str1 + "' and '" + str2 + "' OK");
        } else {
            this.log.println("Comparing of '" + str1 + "' and '" + str2 + "' FAILED; return: " + res + ", expected: " + expRes);
            ret = false;
        }
        if (!testReverse) {
            return ret;
        }
        res = -666;
        try {
            res = this.oObj.compareString(str2, str1);
        }
        catch (NullPointerException e) {
            this.log.println("Exception while method calling occurs :" + e);
        }
        if (res == -expRes) {
            this.log.println("Comparing of '" + str2 + "' and '" + str1 + "' OK");
        } else {
            this.log.println("Comparing of '" + str2 + "' and '" + str1 + "' FAILED; return: " + res + ", expected: " + -expRes);
            ret = false;
        }
        return ret;
    }
}

