/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.Calendar;
import com.sun.star.i18n.Currency;
import com.sun.star.i18n.ForbiddenCharacters;
import com.sun.star.i18n.FormatElement;
import com.sun.star.i18n.Implementation;
import com.sun.star.i18n.LanguageCountryInfo;
import com.sun.star.i18n.LocaleDataItem;
import com.sun.star.i18n.XLocaleData;
import com.sun.star.lang.Locale;
import lib.MultiMethodTest;

public class _XLocaleData
extends MultiMethodTest {
    public XLocaleData oObj = null;
    public String[] languages = new String[]{"de", "en", "es", "fr", "ja", "ko", "ko"};
    public String[] countries = new String[]{"DE", "US", "ES", "FR", "JP", "KR", "KR"};

    public void _getLanguageCountryInfo() {
        boolean res = true;
        LanguageCountryInfo lci = null;
        for (int i = 0; i < 7; ++i) {
            lci = this.oObj.getLanguageCountryInfo(this.getLocale(i));
            res &= lci.Language.equals(this.languages[i]) && lci.Country.equals(this.countries[i]);
        }
        this.tRes.tested("getLanguageCountryInfo()", res);
    }

    public void _getLocaleItem() {
        boolean res = true;
        LocaleDataItem ldi = null;
        for (int i = 0; i < 7; ++i) {
            ldi = this.oObj.getLocaleItem(this.getLocale(i));
            boolean locRes = true;
            locRes &= !ldi.dateSeparator.equals("");
            locRes &= !ldi.decimalSeparator.equals("");
            locRes &= !ldi.doubleQuotationEnd.equals("");
            locRes &= !ldi.doubleQuotationStart.equals("");
            locRes &= !ldi.listSeparator.equals("");
            locRes &= !ldi.LongDateDayOfWeekSeparator.equals("");
            locRes &= !ldi.LongDateDaySeparator.equals("");
            locRes &= !ldi.LongDateMonthSeparator.equals("");
            locRes &= !ldi.LongDateYearSeparator.equals("");
            locRes &= !ldi.measurementSystem.equals("");
            locRes &= !ldi.quotationEnd.equals("");
            locRes &= !ldi.quotationStart.equals("");
            locRes &= !ldi.thousandSeparator.equals("");
            locRes &= !ldi.time100SecSeparator.equals("");
            locRes &= !ldi.timeAM.equals("");
            locRes &= !ldi.timePM.equals("");
            locRes &= !ldi.timeSeparator.equals("");
            if (locRes &= !ldi.unoID.equals("")) continue;
        }
        this.tRes.tested("getLocaleItem()", res);
    }

    public void _getAllCalendars() {
        boolean res = true;
        boolean printit = false;
        Calendar[] calendar = new Calendar[1];
        for (int i = 0; i < 7; ++i) {
            calendar = this.oObj.getAllCalendars(this.getLocale(i));
            for (int j = 0; j < calendar.length; ++j) {
                if (!this.goodCalendar(calendar[j])) {
                    printit = true;
                }
                res &= this.goodCalendar(calendar[j]);
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getAllCalendars()", res);
    }

    public void _getAllCurrencies() {
        boolean res = true;
        boolean printit = false;
        Currency[] currency = new Currency[1];
        for (int i = 0; i < 7; ++i) {
            currency = this.oObj.getAllCurrencies(this.getLocale(i));
            for (int j = 0; j < currency.length; ++j) {
                if (!this.goodCurrency(currency[j])) {
                    printit = true;
                }
                res &= this.goodCurrency(currency[j]);
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getAllCurrencies()", res);
    }

    public void _getAllFormats() {
        boolean res = true;
        boolean printit = false;
        FormatElement[] format = new FormatElement[1];
        for (int i = 0; i < 7; ++i) {
            format = this.oObj.getAllFormats(this.getLocale(i));
            for (int j = 0; j < format.length; ++j) {
                if (!this.goodFormat(format[j])) {
                    printit = true;
                }
                res &= this.goodFormat(format[j]);
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getAllFormats()", res);
    }

    public void _getCollatorImplementations() {
        boolean res = true;
        boolean printit = false;
        Implementation[] impl = new Implementation[1];
        for (int i = 0; i < 7; ++i) {
            impl = this.oObj.getCollatorImplementations(this.getLocale(i));
            for (int j = 0; j < impl.length; ++j) {
                if (impl[j].unoID.equals("")) {
                    printit = true;
                }
                res &= !impl[j].unoID.equals("");
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getCollatorImplementations()", res);
    }

    public void _getSearchOptions() {
        boolean res = true;
        boolean printit = false;
        String[] str = new String[1];
        for (int i = 0; i < 7; ++i) {
            str = this.oObj.getSearchOptions(this.getLocale(i));
            for (int j = 0; j < str.length; ++j) {
                if (str[j].equals("")) {
                    printit = true;
                }
                res &= !str.equals("");
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getSearchOptions()", res);
    }

    public void _getCollationOptions() {
        boolean res = true;
        boolean printit = false;
        String[] str = new String[1];
        for (int i = 0; i < 7; ++i) {
            str = this.oObj.getCollationOptions(this.getLocale(i));
            for (int j = 0; j < str.length; ++j) {
                if (str[j].equals("")) {
                    printit = true;
                }
                res &= !str.equals("");
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getCollationOptions()", res);
    }

    public void _getTransliterations() {
        boolean res = true;
        boolean printit = false;
        String[] str = new String[1];
        for (int i = 0; i < 7; ++i) {
            str = this.oObj.getTransliterations(this.getLocale(i));
            for (int j = 0; j < str.length; ++j) {
                if (str[j].equals("")) {
                    printit = true;
                }
                res &= !str.equals("");
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getTransliterations()", res);
    }

    public void _getForbiddenCharacters() {
        boolean res = true;
        ForbiddenCharacters fc = null;
        for (int i = 4; i < 7; ++i) {
            fc = this.oObj.getForbiddenCharacters(this.getLocale(i));
            if (res &= !fc.beginLine.equals("") && !fc.endLine.equals("")) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
        }
        this.tRes.tested("getForbiddenCharacters()", res);
    }

    public void _getReservedWord() {
        boolean res = true;
        boolean printit = false;
        String[] str = new String[1];
        for (int i = 0; i < 7; ++i) {
            str = this.oObj.getReservedWord(this.getLocale(i));
            for (int j = 0; j < str.length; ++j) {
                if (str[j].equals("")) {
                    printit = true;
                }
                res &= !str.equals("");
            }
            if (printit) {
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            }
            printit = false;
        }
        this.tRes.tested("getReservedWord()", res);
    }

    public void _getAllInstalledLocaleNames() {
        boolean res = true;
        Locale[] locs = this.oObj.getAllInstalledLocaleNames();
        for (int i = 0; i < 7; ++i) {
            res &= this.contains(locs, this.getLocale(i));
        }
        this.tRes.tested("getAllInstalledLocaleNames()", res);
    }

    public Locale getLocale(int k) {
        return new Locale(this.languages[k], this.countries[k], "");
    }

    public boolean goodCalendar(Calendar calendar) {
        int i;
        boolean good = true;
        for (i = 0; i < calendar.Days.length; ++i) {
            good &= !calendar.Days[i].AbbrevName.equals("");
            good &= !calendar.Days[i].FullName.equals("");
            good &= !calendar.Days[i].ID.equals("");
        }
        for (i = 0; i < calendar.Months.length; ++i) {
            good &= !calendar.Months[i].AbbrevName.equals("");
            good &= !calendar.Months[i].FullName.equals("");
            good &= !calendar.Months[i].ID.equals("");
        }
        for (i = 0; i < calendar.Eras.length; ++i) {
            good &= !calendar.Eras[i].AbbrevName.equals("");
            good &= !calendar.Eras[i].FullName.equals("");
            good &= !calendar.Eras[i].ID.equals("");
        }
        good &= !calendar.StartOfWeek.equals("");
        return good &= !calendar.Name.equals("");
    }

    public boolean goodCurrency(Currency currency) {
        boolean good = true;
        good &= !currency.BankSymbol.equals("");
        good &= !currency.Name.equals("");
        return good &= !currency.Symbol.equals("");
    }

    public boolean goodFormat(FormatElement format) {
        boolean good = true;
        good &= !format.formatCode.equals("");
        good &= !format.formatKey.equals("");
        good &= !format.formatType.equals("");
        return good &= !format.formatUsage.equals("");
    }

    public boolean contains(Locale[] locs, Locale oneLoc) {
        boolean cont = false;
        for (int j = 0; j < locs.length; ++j) {
            if (!locs[j].Country.equals(oneLoc.Country) || !locs[j].Language.equals(oneLoc.Language)) continue;
            cont = true;
            break;
        }
        if (!cont) {
            this.log.println("Not contained: " + oneLoc.Language);
        }
        return cont;
    }
}

