/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.XExtendedCalendar;
import com.sun.star.i18n.XLocaleData;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import lib.MultiMethodTest;

public class _XExtendedCalendar
extends MultiMethodTest {
    public XExtendedCalendar oObj = null;
    boolean useUSENLocale = false;

    @Override
    public void before() {
        Locale[] installed_locales = null;
        XLocaleData locData = null;
        try {
            locData = UnoRuntime.queryInterface(XLocaleData.class, ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.i18n.LocaleData"));
        }
        catch (Exception e) {
            // empty catch block
        }
        installed_locales = locData.getAllInstalledLocaleNames();
        Locale lo = installed_locales[0];
        for (int i = 0; i < installed_locales.length; ++i) {
            if (!installed_locales[i].Language.equals("en") || !installed_locales[i].Country.equals("US")) continue;
            lo = installed_locales[i];
            this.useUSENLocale = true;
        }
        this.log.println("Choose Locale: '" + lo.Language + "', '" + lo.Country + "'");
        this.oObj.loadDefaultCalendar(lo);
    }

    public void _getDisplayString() {
        boolean result = true;
        String[] displayString = new String[6];
        String[] expectedStringResult = new String[6];
        GregorianCalendar cal = new GregorianCalendar();
        Date actualDate = cal.getTime();
        SimpleDateFormat sdf = this.getSDF("yy");
        expectedStringResult[0] = "AD" + sdf.format(actualDate);
        sdf = this.getSDF("yyyy");
        expectedStringResult[1] = "AD" + sdf.format(actualDate);
        sdf = this.getSDF("MM");
        expectedStringResult[2] = sdf.format(actualDate);
        int month = cal.get(2) + 1;
        String quarter = "Q1";
        String longQuarter = "1st quarter";
        if (month > 3 && month < 7) {
            quarter = "Q2";
            longQuarter = "2nd quarter";
        } else if (month > 6 && month < 10) {
            quarter = "Q3";
            longQuarter = "3rd quarter";
        } else if (month > 10 && month < 13) {
            quarter = "Q4";
            longQuarter = "4th quarter";
        }
        expectedStringResult[3] = quarter;
        expectedStringResult[4] = longQuarter;
        sdf = this.getSDF("MMMM");
        expectedStringResult[5] = sdf.format(actualDate);
        displayString[0] = this.oObj.getDisplayString(13, (short)0);
        displayString[1] = this.oObj.getDisplayString(14, (short)0);
        displayString[2] = this.oObj.getDisplayString(6, (short)0);
        displayString[3] = this.oObj.getDisplayString(15, (short)0);
        displayString[4] = this.oObj.getDisplayString(16, (short)0);
        displayString[5] = this.oObj.getDisplayString(8, (short)0);
        for (int i = 0; i < displayString.length; ++i) {
            boolean locResult = false;
            if (this.useUSENLocale) {
                locResult = displayString[i].equals(expectedStringResult[i]);
                if (!locResult) {
                    this.log.println("getDisplayString() result " + i + ": '" + displayString[i] + "', expected: '" + expectedStringResult[i] + "'");
                }
                result &= locResult;
                continue;
            }
            if (!(locResult &= displayString[i] != null)) {
                this.log.println("getDisplayString() result " + i + " was 'null'");
            }
            result &= locResult;
        }
        this.tRes.tested("getDisplayString()", result);
    }

    private SimpleDateFormat getSDF(String format) {
        if (this.useUSENLocale) {
            return new SimpleDateFormat(format, java.util.Locale.US);
        }
        return new SimpleDateFormat(format);
    }
}

