/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.XCollator;
import com.sun.star.lang.Locale;
import java.text.Collator;
import lib.MultiMethodTest;

public class _XCollator
extends MultiMethodTest {
    public XCollator oObj = null;
    private String[] alg = null;
    private int[] opt = null;
    Locale loc = new Locale("en", "EN", "");

    public void _listCollatorAlgorithms() {
        this.alg = this.oObj.listCollatorAlgorithms(this.loc);
        this.log.println("Collator algorithms :");
        if (this.alg != null) {
            for (int i = 0; i < this.alg.length; ++i) {
                this.log.println("  '" + this.alg[i] + "'");
            }
            this.tRes.tested("listCollatorAlgorithms()", this.alg.length > 0);
        } else {
            this.tRes.tested("listCollatorAlgorithms()", false);
        }
    }

    public void _listCollatorOptions() {
        this.requiredMethod("listCollatorAlgorithms()");
        this.opt = this.oObj.listCollatorOptions(this.alg[0]);
        this.log.println("Collator '" + this.alg[0] + "' options :");
        if (this.opt != null) {
            for (int i = 0; i < this.opt.length; ++i) {
                this.log.println("  " + this.opt[i]);
            }
            this.tRes.tested("listCollatorOptions()", true);
        } else {
            this.tRes.tested("listCollatorOptions()", false);
        }
    }

    public void _loadDefaultCollator() {
        this.oObj.loadDefaultCollator(this.loc, 0);
        boolean res = this.oObj.compareString("A", "a") != 0;
        this.oObj.loadDefaultCollator(this.loc, 1);
        this.tRes.tested("loadDefaultCollator()", res &= this.oObj.compareString("a", "A") == 0);
    }

    public void _loadCollatorAlgorithm() {
        this.requiredMethod("listCollatorAlgorithms()");
        this.oObj.loadCollatorAlgorithm(this.alg[0], this.loc, 1);
        boolean res = this.oObj.compareString("A", "a") == 0;
        this.oObj.loadCollatorAlgorithm(this.alg[0], this.loc, 0);
        this.tRes.tested("loadCollatorAlgorithm()", res &= this.oObj.compareString("a", "A") != 0);
    }

    public void _loadCollatorAlgorithmWithEndUserOption() {
        this.requiredMethod("listCollatorAlgorithms()");
        this.oObj.loadCollatorAlgorithmWithEndUserOption(this.alg[0], this.loc, new int[]{0});
        boolean res = this.oObj.compareString("A", "a") != 0;
        this.oObj.loadCollatorAlgorithmWithEndUserOption(this.alg[0], this.loc, new int[]{1});
        res = this.oObj.compareString("A", "a") == 0;
        this.tRes.tested("loadCollatorAlgorithmWithEndUserOption()", res);
    }

    public void _compareSubstring() {
        int ch;
        boolean result = true;
        char[] chars = new char[2];
        Collator col = null;
        this.log.println(" #### Testing English locale ####");
        this.oObj.loadDefaultCollator(this.loc, 0);
        col = Collator.getInstance(new java.util.Locale("en", "EN"));
        for (ch = 32; ch < 127; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareSubstring(chars, col);
        }
        this.log.println(" #### Testing Russian locale ####");
        this.oObj.loadDefaultCollator(new Locale("ru", "RU", ""), 0);
        col = Collator.getInstance(new java.util.Locale("ru", "RU"));
        for (ch = 1040; ch < 1104; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareSubstring(chars, col);
        }
        this.log.println(" #### Testing Japan locale ####");
        this.oObj.loadDefaultCollator(new Locale("ja", "JP", ""), 0);
        col = Collator.getInstance(new java.util.Locale("ja", "JP"));
        for (ch = 19968; ch < 20221; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareSubstring(chars, col);
        }
        this.log.println(" #### Testing China locale ####");
        this.oObj.loadDefaultCollator(new Locale("zh", "CN", ""), 0);
        col = Collator.getInstance(new java.util.Locale("zh", "CN"));
        for (ch = 19968; ch < 20221; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareSubstring(chars, col);
        }
        this.log.println(" #### Testing Korean locale ####");
        this.oObj.loadDefaultCollator(new Locale("ko", "KR", ""), 0);
        col = Collator.getInstance(new java.util.Locale("ko", "KR"));
        for (ch = 19968; ch < 20221; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareSubstring(chars, col);
        }
        this.tRes.tested("compareSubstring()", result);
    }

    public void _compareString() {
        int ch;
        boolean result = true;
        char[] chars = new char[2];
        Collator col = null;
        this.log.println(" #### Testing English locale ####");
        this.oObj.loadDefaultCollator(new Locale("en", "EN", ""), 0);
        col = Collator.getInstance(new java.util.Locale("en", "EN"));
        for (ch = 32; ch < 127; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareString(chars, col);
        }
        this.log.println(" #### Testing Russian locale ####");
        this.oObj.loadDefaultCollator(new Locale("ru", "RU", ""), 0);
        col = Collator.getInstance(new java.util.Locale("ru", "RU"));
        for (ch = 1040; ch < 1104; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareString(chars, col);
        }
        this.log.println(" #### Testing Japan locale ####");
        this.oObj.loadDefaultCollator(new Locale("ja", "JP", ""), 0);
        col = Collator.getInstance(new java.util.Locale("ja", "JP"));
        for (ch = 19968; ch < 20221; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareString(chars, col);
        }
        this.log.println(" #### Testing China locale ####");
        this.oObj.loadDefaultCollator(new Locale("zh", "CN", ""), 0);
        col = Collator.getInstance(new java.util.Locale("zh", "CN"));
        for (ch = 19968; ch < 20221; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareString(chars, col);
        }
        this.log.println(" #### Testing Korean locale ####");
        this.oObj.loadDefaultCollator(new Locale("ko", "KR", ""), 0);
        col = Collator.getInstance(new java.util.Locale("ko", "KR"));
        for (ch = 19968; ch < 20221; ch = (int)((char)(ch + 1))) {
            chars[0] = ch;
            chars[1] = (char)(ch + 1);
            result &= this.testCompareString(chars, col);
        }
        this.tRes.tested("compareString()", result);
    }

    public boolean testCompareString(char[] locChar, Collator col) {
        boolean result = true;
        String msg = "";
        String char0 = "_" + new String(new char[]{locChar[0]});
        String char1 = "_" + new String(new char[]{locChar[1]});
        int res = this.oObj.compareString(char0, char0);
        if (res != 0) {
            msg = msg + "  Testing collation of single equal characters (" + this.toUnicode(char0) + ") ... FAILED\n";
        }
        result &= res == 0;
        res = this.oObj.compareString(char0, char1);
        if (res == 0) {
            msg = msg + "  Testing collation of single different characters (" + this.toUnicode(char0 + char1) + ") ... FAILED (0 returned)\n";
            msg = msg + "  Java collator returned " + col.compare(char0, char1) + "\n";
            result = false;
        } else {
            if ((res += this.oObj.compareString(char1, char0)) != 0) {
                msg = msg + "  Testing collation of single different characters (" + this.toUnicode(char0 + char1) + ") ... FAILED\n";
            }
            result &= res == 0;
        }
        String str1 = new String(new char[]{locChar[0], locChar[0], locChar[1], locChar[1], locChar[1]});
        String str2 = new String(new char[]{locChar[0], locChar[0], locChar[0], locChar[1], locChar[1]});
        res = this.oObj.compareString(str1, str1);
        if (res != 0) {
            msg = msg + "  Testing collation of equal strings (" + this.toUnicode(str1) + ") ... FAILED\n";
        }
        result &= res == 0;
        res = this.oObj.compareString(str1, str2);
        if (res == 0) {
            msg = msg + "  Testing collation of different strings ((" + this.toUnicode(str1) + "),(" + this.toUnicode(str2) + ")) ... FAILED (0 returned)\n";
            msg = msg + "  Java collator returned " + col.compare(str1, str2) + "\n";
            result = false;
        } else {
            if ((res += this.oObj.compareString(str2, str1)) != 0) {
                msg = msg + "  Testing collation of different strings ((" + this.toUnicode(str1) + "),(" + this.toUnicode(str2) + ")) ... FAILED\n";
            }
            result &= res == 0;
        }
        if (!result) {
            this.log.println(msg);
        }
        return result;
    }

    public boolean testCompareSubstring(char[] locChar, Collator col) {
        boolean result = true;
        String msg = "";
        String str1 = new String(new char[]{locChar[0], locChar[0], locChar[1], locChar[1], locChar[1]});
        String str2 = new String(new char[]{locChar[0], locChar[0], locChar[0], locChar[1], locChar[1]});
        int res = this.oObj.compareSubstring(str1, 1, 2, str2, 2, 2);
        if (res != 0) {
            msg = msg + "  Testing collation of equal substrings (" + this.toUnicode(str1) + ") ... FAILED\n";
        }
        result &= res == 0;
        res = this.oObj.compareSubstring(str1, 1, 2, str2, 1, 2);
        if (res == 0) {
            msg = msg + "  Testing collation of different strings ((" + this.toUnicode(str1.substring(1, 3)) + "),(" + this.toUnicode(str2.substring(1, 3)) + ")) ... FAILED (0 returned)\n";
            msg = msg + "  Java collator returned " + col.compare(str1.substring(1, 3), str2.substring(1, 3)) + "\n";
            result = false;
        } else {
            if ((res += this.oObj.compareSubstring(str2, 1, 2, str1, 1, 2)) != 0) {
                msg = msg + "  Testing collation of different strings ((" + this.toUnicode(str1) + "),(" + this.toUnicode(str2) + ")) ... FAILED\n";
            }
            result &= res == 0;
        }
        if (!result) {
            this.log.println(msg);
        }
        return result;
    }

    public String toUnicode(String str) {
        char[] chars = str.toCharArray();
        String res = "";
        for (int i = 0; i < chars.length; ++i) {
            if (i != 0) {
                res = res + ",";
            }
            res = res + Integer.toHexString(chars[i]);
        }
        return res;
    }
}

