/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.ParseResult;
import com.sun.star.i18n.XCharacterClassification;
import java.util.Locale;
import lib.MultiMethodTest;

public class _XCharacterClassification
extends MultiMethodTest {
    public XCharacterClassification oObj = null;
    public String[] languages = new String[]{"de", "en", "es", "fr", "ja", "ko", "zh"};
    public String[] countries = new String[]{"DE", "US", "ES", "FR", "JP", "KR", "CN"};
    public String[] charstyles_java = new String[]{"UNASSIGNED", "UPPERCASE_LETTER", "LOWERCASE_LETTER", "TITLECASE_LETTER", "MODIFIER_LETTER", "OTHER_LETTER", "NON_SPACING_MARK", "ENCLOSING_MARK", "COMBINING_SPACING_MARK", "DECIMAL_DIGIT_NUMBER", "LETTER_NUMBER", "OTHER_NUMBER", "SPACE_SEPARATOR", "LINE_SEPARATOR", "PARAGRAPH_SEPARATOR", "CONTROL", "FORMAT", "none17", "PRIVATE_USE", "none19", "DASH_PUNCTUATION", "START_PUNCTUATION", "END_PUNCTUATION", "CONNECTOR_PUNCTUATION", "OTHER_PUNCTUATION", "MATH_SYMBOL", "CURRENCY_SYMBOL", "MODIFIER_SYMBOL", "OTHER_SYMBOL"};
    public String[] charstyles_office = new String[]{"UNASSIGNED", "UPPERCASE_LETTER", "LOWERCASE_LETTER", "TITLECASE_LETTER", "MODIFIER_LETTER", "OTHER_LETTER", "NON_SPACING_MARK", "ENCLOSING_MARK", "COMBINING_SPACING_MARK", "DECIMAL_DIGIT_NUMBER", "LETTER_NUMBER", "OTHER_NUMBER", "SPACE_SEPARATOR", "LINE_SEPARATOR", "PARAGRAPH_SEPARATOR", "CONTROL", "FORMAT", "PRIVATE_USE", "OTHER_PUNCTUATION", "DASH_PUNCTUATION", "START_PUNCTUATION", "END_PUNCTUATION", "CONNECTOR_PUNCTUATION", "OTHER_PUNCTUATION", "MATH_SYMBOL", "CURRENCY_SYMBOL", "MODIFIER_SYMBOL", "OTHER_SYMBOL", "INITIAL_PUNCTUATION", "FINAL_PUNCTUATION", "GENERAL_TYPES_COUNT"};
    public String[] unicode_script = new String[]{"U_BASIC_LATIN", "U_LATIN_1_SUPPLEMENT", "U_LATIN_EXTENDED_A", "U_LATIN_EXTENDED_B", "U_IPA_EXTENSIONS", "U_SPACING_MODIFIER_LETTERS", "U_COMBINING_DIACRITICAL_MARKS", "U_GREEK", "U_CYRILLIC", "U_ARMENIAN", "U_HEBREW", "U_ARABIC", "U_SYRIAC", "U_THAANA", "U_DEVANAGARI", "U_BENGALI", "U_GURMUKHI", "U_GUJARATI", "U_ORIYA", "U_TAMIL", "U_TELUGU", "U_KANNADA", "U_MALAYALAM", "U_SINHALA", "U_THAI", "U_LAO", "U_TIBETAN", "U_MYANMAR", "U_GEORGIAN", "U_HANGUL_JAMO", "U_ETHIOPIC", "U_CHEROKEE", "U_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", "U_OGHAM", "U_RUNIC", "U_KHMER", "U_MONGOLIAN", "U_LATIN_EXTENDED_ADDITIONAL", "U_GREEK_EXTENDED", "U_GENERAL_PUNCTUATION", "U_SUPERSCRIPTS_AND_SUBSCRIPTS", "U_CURRENCY_SYMBOLS", "U_COMBINING_MARKS_FOR_SYMBOLS", "U_LETTERLIKE_SYMBOLS", "U_NUMBER_FORMS", "U_ARROWS", "U_MATHEMATICAL_OPERATORS", "U_MISCELLANEOUS_TECHNICAL", "U_CONTROL_PICTURES", "U_OPTICAL_CHARACTER_RECOGNITION", "U_ENCLOSED_ALPHANUMERICS", "U_BOX_DRAWING", "U_BLOCK_ELEMENTS", "U_GEOMETRIC_SHAPES", "U_MISCELLANEOUS_SYMBOLS", "U_DINGBATS", "U_BRAILLE_PATTERNS", "U_CJK_RADICALS_SUPPLEMENT", "U_KANGXI_RADICALS", "U_IDEOGRAPHIC_DESCRIPTION_CHARACTERS", "U_CJK_SYMBOLS_AND_PUNCTUATION", "U_HIRAGANA", "U_KATAKANA", "U_BOPOMOFO", "U_HANGUL_COMPATIBILITY_JAMO", "U_KANBUN", "U_BOPOMOFO_EXTENDED", "U_ENCLOSED_CJK_LETTERS_AND_MONTHS", "U_CJK_COMPATIBILITY", "U_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", "U_CJK_UNIFIED_IDEOGRAPHS", "U_YI_SYLLABLES", "U_YI_RADICALS", "U_HANGUL_SYLLABLES", "U_HIGH_SURROGATES", "U_HIGH_PRIVATE_USE_SURROGATES", "U_LOW_SURROGATES", "U_PRIVATE_USE_AREA", "U_CJK_COMPATIBILITY_IDEOGRAPHS", "U_ALPHABETIC_PRESENTATION_FORMS", "U_ARABIC_PRESENTATION_FORMS_A", "U_COMBINING_HALF_MARKS", "U_CJK_COMPATIBILITY_FORMS", "U_SMALL_FORM_VARIANTS", "U_ARABIC_PRESENTATION_FORMS_B", "U_SPECIALS", "U_HALFWIDTH_AND_FULLWIDTH_FORMS", "U_CHAR_SCRIPT_COUNT", "U_NO_SCRIPT"};

    public void _toUpper() {
        boolean res = true;
        char[] characters = new char[]{'\u024a', 'A', 'a', '\u01f2', '\u02d1', '\u11ec', '\u0304', '\u20dd', '\u0d4c'};
        String toCheck = new String(characters);
        String get = "";
        String exp = "";
        for (int i = 0; i < 7; ++i) {
            get = this.oObj.toUpper(toCheck, 0, toCheck.length(), this.getLocale(i));
            if (res &= get.equals(exp = toCheck.toUpperCase(new Locale(this.languages[i], this.countries[i])))) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            this.log.println("Expected: " + exp);
            this.log.println("Gained : " + get);
        }
        this.tRes.tested("toUpper()", res);
    }

    public void _toLower() {
        boolean res = true;
        char[] characters = new char[]{'\u024a', 'A', 'a', '\u01f2', '\u02d1', '\u11ec', '\u0304', '\u20dd', '\u0d4c'};
        String toCheck = new String(characters);
        String get = "";
        String exp = "";
        for (int i = 0; i < 7; ++i) {
            get = this.oObj.toLower(toCheck, 0, toCheck.length(), this.getLocale(i));
            if (res &= get.equals(exp = toCheck.toLowerCase(new Locale(this.languages[i], this.countries[i])))) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            this.log.println("Expected: " + exp);
            this.log.println("Gained : " + get);
        }
        this.tRes.tested("toLower()", res);
    }

    public void _toTitle() {
        boolean res = true;
        String toCheck = new String(new char[]{'\u1fb0'});
        String get = "";
        String exp = "";
        for (int i = 0; i < 7; ++i) {
            get = this.oObj.toTitle(toCheck, 0, 1, this.getLocale(i));
            exp = new String(new char[]{Character.toTitleCase(toCheck.toCharArray()[0])});
            if (res &= get.equals(exp)) continue;
            this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
            this.log.println("Expected: " + exp);
            this.log.println("Gained : " + get);
        }
        this.tRes.tested("toTitle()", res);
    }

    public void _getType() {
        boolean res = true;
        char[] characters = new char[]{'\u024a', 'A', 'a', '\u01f2', '\u02d1', '\u11ec', '\u0304', '\u20dd', '\u0d4c', '0', '\u2160', '\u00b3', ' ', '\u2028', '\u2029', '\u0090', '\u200c', '\ue000', '\udc00', '\u00ad', '(', ')', '_', '\u0f0c', '\u00f7', '\u0e3f', '\u0385', '\u0f38', '\u00ab', '\u00bb'};
        int[] charsInt = new int[]{586, 65, 97, 498, 721, 4588, 772, 8413, 3404, 48, 8544, 179, 32, 8232, 8233, 144, 8204, 57344, 56320, 173, 40, 41, 95, 3852, 247, 3647, 901, 3896, 171, 187};
        String toCheck = new String(characters);
        for (int i = 0; i < characters.length; ++i) {
            short get = this.oObj.getType(toCheck, i);
            if (res &= this.charstyles_office[get] == this.charstyles_office[i]) continue;
            this.log.println("Code :" + Integer.toHexString(charsInt[i]));
            this.log.println("Gained: " + this.charstyles_office[get]);
            this.log.println("Expected : " + this.charstyles_office[i]);
        }
        this.tRes.tested("getType()", res);
    }

    public void _getCharacterType() {
        boolean res = true;
        String toCheck = "Ab0)";
        int[] expected = new int[]{226, 228, 97, 32};
        for (int i = 0; i < toCheck.length(); ++i) {
            for (int j = 1; j < 7; ++j) {
                int get = this.oObj.getCharacterType(toCheck, i, this.getLocale(j));
                if (res &= get == expected[i]) continue;
                this.log.println("FAILED for: language=" + this.languages[j] + " ; country=" + this.countries[j]);
                this.log.println("Sysmbol :" + toCheck.toCharArray()[i]);
                this.log.println("Gained: " + get);
                this.log.println("Expected : " + expected[i]);
            }
        }
        this.tRes.tested("getCharacterType()", res);
    }

    public void _getStringType() {
        boolean res = true;
        String[] toCheck = new String[]{"01234", "AAAAA", "bbbbb", "AA()bb"};
        int[] exp = new int[]{97, 226, 228, 230};
        for (int j = 0; j < toCheck.length; ++j) {
            for (int i = 0; i < 7; ++i) {
                int get = this.oObj.getStringType(toCheck[j], 0, toCheck[j].length(), this.getLocale(i));
                if (res &= get == exp[j]) continue;
                this.log.println("FAILED for: language=" + this.languages[i] + " ; country=" + this.countries[i]);
                this.log.println("Expected: " + exp[j]);
                this.log.println("Gained : " + get);
            }
        }
        this.tRes.tested("getStringType()", res);
    }

    public void _getCharacterDirection() {
        boolean res = true;
        String toCheck = new String(new char[]{'A', '\u05be', '0', '/', '#', '\u0660', ',', '\n', '\t', '\f', '!', '\u202a', '\u202d', '\u061b', '\u202b', '\u202e', '\u202c', '\u0300', '\u0001'});
        for (short i = 0; i < 19; i = (short)(i + 1)) {
            short get = this.oObj.getCharacterDirection(toCheck, i);
            if (res &= get == i) continue;
            this.log.println("Code :" + toCheck.toCharArray()[i]);
            this.log.println("Gained: " + get);
            this.log.println("Expected: " + i);
        }
        this.tRes.tested("getCharacterDirection()", res);
    }

    public void _getScript() {
        boolean res = true;
        char[] characters = new char[]{'A', '\u0080', '\u0100', '\u0180', '\u0250', '\u02ee', '\u0305', '\u039c', '\u0406', '\u0533', '\u05a8', '\u0621', '\u0700', '\u0790', '\u0909', '\u09a1', '\u0a0a', '\u0a93', '\u0b06', '\u0b9c', '\u0c07', '\u0ca8', '\u0d09', '\u0d88', '\u0e06', '\u0ea1', '\u0f42', '\u1001', '\u10b2', '\u1105', '\u120d', '\u13b0', '\u1450', '\u1690', '\u16ae', '\u178e', '\u180b', '\u1e03', '\u1f07', '\u200a', '\u207f', '\u20a0', '\u20dd', '\u2104', '\u2161', '\u21a8', '\u220b', '\u2305', '\u2401', '\u2441', '\u2478', '\u2502', '\u2588', '\u25f7', '\u2606', '\u270f', '\u2807', '\u2e87', '\u2f02', '\u2ff2', '\u3006', '\u3046', '\u30a8', '\u3108', '\u313d', '\u3190', '\u31b7', '\u3206', '\u3309', '\u3400', '\u4e00', '\ua004', '\ua4a8', '\uac00', '\ud800', '\udb80', '\udc00', '\ue000', '\uf900', '\ufb01', '\ufb72', '\ufe20', '\ufe31', '\ufe6b', '\ufe7a', '\ufffc', '\uff08'};
        int[] charsInt = new int[]{65, 128, 256, 384, 592, 750, 773, 924, 1030, 1331, 1448, 1569, 1792, 1936, 2313, 2465, 2570, 2707, 2822, 2972, 3079, 3240, 3337, 3464, 3590, 3745, 3906, 4097, 4274, 4357, 4621, 5040, 5200, 5776, 5806, 6030, 6155, 7683, 7943, 8202, 8319, 8352, 8413, 8452, 8545, 8616, 8715, 8965, 9217, 9281, 9336, 9474, 9608, 9719, 9734, 9999, 10247, 11911, 12034, 12274, 12294, 12358, 12456, 12552, 12605, 12688, 12727, 12806, 13065, 13312, 19968, 40964, 42152, 44032, 55296, 56192, 56320, 57344, 63744, 64257, 64370, 65056, 65073, 65131, 65146, 65532, 65288};
        String toCheck = new String(characters);
        for (int i = 0; i < characters.length; ++i) {
            short get = this.oObj.getScript(toCheck, i);
            res &= get == i;
            if (toCheck.substring(i, i + 1).hashCode() == 55296) {
                res = true;
            }
            if (res) continue;
            this.log.println("-- " + toCheck.substring(i, i + 1).hashCode());
            this.log.println("Code: " + Integer.toHexString(charsInt[i]));
            this.log.println("Gained: " + this.unicode_script[get]);
            this.log.println("Expected: " + this.unicode_script[i]);
        }
        this.tRes.tested("getScript()", res);
    }

    public void _parseAnyToken() {
        int nStartFlags = 45067;
        int nContFlags = 61487;
        String toCheck = " 18 i18n ^";
        ParseResult pRes = null;
        boolean res = true;
        for (int i = 0; i < 7; ++i) {
            pRes = this.oObj.parseAnyToken(toCheck, 1, this.getLocale(i), nStartFlags, "", nContFlags, "");
            res = pRes.CharLen == 2 && pRes.TokenType == 32 && pRes.Value == 18.0;
            pRes = this.oObj.parseAnyToken(toCheck, 4, this.getLocale(i), nStartFlags, "", nContFlags, "");
            res &= pRes.CharLen == 4 && pRes.TokenType == 4 && pRes.Value == 0.0;
            pRes = this.oObj.parseAnyToken(toCheck, 9, this.getLocale(i), nStartFlags, "", nContFlags, "");
            res &= pRes.CharLen == 1 && pRes.TokenType == 1 && pRes.Value == 0.0;
        }
        this.tRes.tested("parseAnyToken()", res);
    }

    public void _parsePredefinedToken() {
        int nStartFlags;
        int nContFlags = nStartFlags = 45067;
        String toCheck = " 18 int";
        ParseResult pRes = null;
        boolean res = true;
        for (int i = 0; i < 7; ++i) {
            pRes = this.oObj.parsePredefinedToken(4, toCheck, 1, this.getLocale(i), nStartFlags, "", nContFlags, "");
            res = pRes.CharLen == 0;
            pRes = this.oObj.parsePredefinedToken(4, toCheck, 4, this.getLocale(i), nStartFlags, "", nContFlags, "");
            res &= pRes.CharLen == 3 && pRes.TokenType == 4 && pRes.Value == 0.0;
        }
        this.tRes.tested("parsePredefinedToken()", res);
    }

    private com.sun.star.lang.Locale getLocale(int k) {
        return new com.sun.star.lang.Locale(this.languages[k], this.countries[k], "");
    }
}

