/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.CalendarItem;
import com.sun.star.i18n.XCalendar;
import com.sun.star.i18n.XLocaleData;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;

public class _XCalendar
extends MultiMethodTest {
    private boolean debug = false;
    public XCalendar oObj = null;
    public String[][] calendars;
    public int[] count;
    public double newDTime = 1000.75;
    public short newValue = (short)2;
    public short firstDay = (short)2;
    public short mdfw = (short)3;
    double aOriginalDTime = 0.0;
    Locale[] installed_locales;

    @Override
    public void before() {
        XLocaleData locData = null;
        try {
            locData = UnoRuntime.queryInterface(XLocaleData.class, ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.i18n.LocaleData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.installed_locales = locData.getAllInstalledLocaleNames();
        this.calendars = new String[this.installed_locales.length][];
        this.count = new int[this.installed_locales.length];
        this.oObj.loadDefaultCalendar(this.installed_locales[0]);
        this.aOriginalDTime = this.oObj.getDateTime();
        this.debug = this.tParam.getBool("DebugIsActive");
    }

    @Override
    public void after() {
        this.oObj.loadDefaultCalendar(this.installed_locales[0]);
        this.oObj.setDateTime(this.aOriginalDTime);
    }

    public void _loadDefaultCalendar() {
        boolean res = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadDefaultCalendar(this.installed_locales[i]);
            if (!this.oObj.getLoadedCalendar().Default) {
                this.log.println(lang + " ... FAILED");
            }
            res &= this.oObj.getLoadedCalendar().Default;
        }
        this.tRes.tested("loadDefaultCalendar()", res);
    }

    public void _getAllCalendars() {
        boolean res = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.calendars[i] = this.oObj.getAllCalendars(this.installed_locales[i]);
            this.count[i] = this.calendars[i].length - 1;
            if (this.calendars[i].length <= 0) {
                this.log.println(lang + " ... FAILED");
            }
            res &= this.calendars[i].length > 0;
        }
        this.tRes.tested("getAllCalendars()", res);
    }

    public void _loadCalendar() {
        boolean res = true;
        this.requiredMethod("getAllCalendars()");
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadCalendar(this.calendars[i][0], this.installed_locales[i]);
            if (!this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name)) {
                this.log.println(lang + " ... FAILED");
            }
            res &= this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name);
        }
        this.tRes.tested("loadCalendar()", res);
    }

    public void _getLoadedCalendar() {
        boolean res = true;
        this.requiredMethod("loadCalendar()");
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadCalendar(this.calendars[i][0], this.installed_locales[i]);
            if (!this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name)) {
                this.log.println(lang + " ... FAILED");
            }
            res &= this.calendars[i][0].equals(this.oObj.getLoadedCalendar().Name);
        }
        this.tRes.tested("getLoadedCalendar()", res);
    }

    public void _getUniqueID() {
        boolean res = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.loadCalendar(this.calendars[i][0], this.installed_locales[i]);
            String uID = this.oObj.getUniqueID();
            if (!uID.equals(this.calendars[i][0])) {
                this.log.println(lang + " ... FAILED");
            }
            res &= uID.equals(this.calendars[i][0]);
        }
        this.tRes.tested("getUniqueID()", res);
    }

    public void _setDateTime() {
        boolean res = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.setDateTime(this.newDTime);
            double aDTime = this.oObj.getDateTime();
            if (aDTime != this.newDTime) {
                this.log.println(lang + " ... FAILED");
            }
            res &= aDTime == this.newDTime;
        }
        this.tRes.tested("setDateTime()", res);
    }

    public void _getDateTime() {
        boolean res = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Country;
            this.oObj.setDateTime(this.newDTime);
            double aDTime = this.oObj.getDateTime();
            if (aDTime != this.newDTime) {
                this.log.println(lang + " ... FAILED");
            }
            res &= aDTime == this.newDTime;
        }
        this.tRes.tested("getDateTime()", res);
    }

    public void _setValue() {
        boolean res = true;
        for (int i = 0; i < this.installed_locales.length; ++i) {
            String error = "";
            String lang = "Language: " + this.installed_locales[i].Language + ", Country: " + this.installed_locales[i].Country + ", Variant: " + this.installed_locales[i].Variant + ", Name: " + this.calendars[i][this.count[i]];
            String[] names = new String[]{"DAY_OF_MONTH", "HOUR", "MINUTE", "SECOND", "MILLISECOND", "YEAR", "MONTH"};
            this.oObj.loadCalendar(this.calendars[i][this.count[i]], this.installed_locales[i]);
            short[] fields = new short[]{1, 5, 6, 7, 8, 11, 12};
            for (int k = 0; k < fields.length; ++k) {
                int n;
                this.oObj.setDateTime(0.0);
                short[] oldValues = new short[fields.length];
                for (int n2 = 0; n2 < oldValues.length; ++n2) {
                    oldValues[n2] = this.oObj.getValue(fields[n2]);
                }
                short set = this.oObj.getValue(fields[k]);
                if (fields[k] == 12) {
                    set = this.newValue;
                }
                this.oObj.setValue(fields[k], set);
                short get = this.oObj.getValue(fields[k]);
                if (get == set) continue;
                if (this.debug) {
                    this.log.println("ERROR occure: tried to set " + names[k] + " to value " + set);
                }
                this.log.println("list of values BEFORE set " + names[k] + " to value " + set + ":");
                for (n = 0; n < oldValues.length; ++n) {
                    this.log.println(names[n] + ":" + oldValues[n]);
                }
                this.log.println("list of values AFTER set " + names[k] + " to value " + set + ":");
                for (n = 0; n < fields.length; ++n) {
                    this.log.println(names[n] + ":" + this.oObj.getValue(fields[n]));
                }
                error = error + "failed for " + names[k] + " expected " + set + " gained " + get + " ; \n";
            }
            if (error.equals("")) {
                this.log.println(lang + " ... OK");
            } else {
                this.log.println("*** " + lang + " ... FAILED ***");
                this.log.println(error);
            }
            res &= error.equals("");
        }
        this.tRes.tested("setValue()", res);
    }

    public void _getValue() {
        boolean res = true;
        this.requiredMethod("setValue()");
        short aValue = this.oObj.getValue((short)12);
        if (!(res &= aValue == this.newValue)) {
            this.log.println("the returned value is not the expected value:");
            this.log.println("expexted: " + this.newValue + "  returned value: " + aValue);
        }
        this.tRes.tested("getValue()", res);
    }

    public void _addValue() {
        boolean res = true;
        this.requiredMethod("getValue()");
        this.oObj.addValue((short)12, 1);
        short aValue = this.oObj.getValue((short)12);
        if (!(res &= aValue > this.newValue)) {
            this.log.println("the returned value is not the expected value:");
            this.log.println("expexted: " + this.newValue + "  returned value: " + aValue);
        }
        this.tRes.tested("addValue()", res);
    }

    public void _setFirstDayOfWeek() {
        boolean res = true;
        this.oObj.setFirstDayOfWeek(this.firstDay);
        this.tRes.tested("setFirstDayOfWeek()", res &= true);
    }

    public void _getFirstDayOfWeek() {
        boolean res = true;
        this.requiredMethod("setFirstDayOfWeek()");
        short aFirstDayOfWeek = this.oObj.getFirstDayOfWeek();
        this.tRes.tested("getFirstDayOfWeek()", res &= aFirstDayOfWeek == this.firstDay);
    }

    public void _setMinimumNumberOfDaysForFirstWeek() {
        boolean res = true;
        this.oObj.setMinimumNumberOfDaysForFirstWeek(this.mdfw);
        this.tRes.tested("setMinimumNumberOfDaysForFirstWeek()", res &= true);
    }

    public void _getMinimumNumberOfDaysForFirstWeek() {
        boolean res = true;
        this.requiredMethod("setMinimumNumberOfDaysForFirstWeek()");
        short aShort = this.oObj.getMinimumNumberOfDaysForFirstWeek();
        this.tRes.tested("getMinimumNumberOfDaysForFirstWeek()", res &= aShort == this.mdfw);
    }

    public void _getNumberOfMonthsInYear() {
        boolean res = true;
        short aShort = this.oObj.getNumberOfMonthsInYear();
        this.tRes.tested("getNumberOfMonthsInYear()", res &= aShort == 12);
    }

    public void _getNumberOfDaysInWeek() {
        boolean res = true;
        short aShort = this.oObj.getNumberOfDaysInWeek();
        this.tRes.tested("getNumberOfDaysInWeek()", res &= aShort == 7);
    }

    public void _getMonths() {
        boolean res = true;
        CalendarItem[] months = this.oObj.getMonths();
        this.tRes.tested("getMonths()", res &= months.length == 12);
    }

    public void _getDays() {
        boolean res = true;
        CalendarItem[] Days = this.oObj.getDays();
        this.tRes.tested("getDays()", res &= Days.length == 7);
    }

    public void _getDisplayName() {
        boolean res = true;
        this.oObj.loadCalendar(this.calendars[0][0], this.installed_locales[0]);
        String DisplayName = this.oObj.getDisplayName((short)2, this.newValue, (short)0);
        this.tRes.tested("getDisplayName()", res &= DisplayName.length() == 3);
    }

    public void _isValid() {
        boolean res = true;
        this.oObj.loadDefaultCalendar(this.installed_locales[0]);
        this.oObj.setValue((short)12, (short)37);
        res &= !this.oObj.isValid();
        this.oObj.setValue((short)12, (short)10);
        this.tRes.tested("isValid()", res &= this.oObj.isValid());
    }
}

