/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.Boundary;
import com.sun.star.i18n.LineBreakHyphenationOptions;
import com.sun.star.i18n.LineBreakResults;
import com.sun.star.i18n.LineBreakUserOptions;
import com.sun.star.i18n.XBreakIterator;
import com.sun.star.lang.Locale;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XBreakIterator
extends MultiMethodTest {
    public XBreakIterator oObj = null;
    Locale locale = null;
    String UnicodeString = null;
    short wordType = 1;
    Vector vBounds = new Vector();
    Vector vSentenceStart = new Vector();
    private static String katakana = new String(new char[]{'\u30a1', '\u30a2'});
    private static String arrows = new String(new char[]{'\u2190', '\u2191'});
    private static String arabic = new String(new char[]{'\u0641', '\u0642'});
    boolean bCharBlockRes = true;
    Vector vCharBlockBounds = new Vector();
    Vector vCharBlockTypes = new Vector();

    @Override
    protected void before() {
        this.locale = (Locale)this.tEnv.getObjRelation("Locale");
        if (this.locale == null) {
            throw new StatusException(Status.failed("Relation 'Locale' not found"));
        }
        this.UnicodeString = (String)this.tEnv.getObjRelation("UnicodeString");
        if (this.UnicodeString == null) {
            throw new StatusException(Status.failed("Relation 'UnicodeString' not found"));
        }
    }

    public void _nextCharacters() {
        short nCharacterIteratorMode = 0;
        int strLength = this.UnicodeString.length();
        int[][] nextCharacters = new int[][]{{1, 5000, strLength, strLength - 1}, {10, 6, 16, 6}};
        boolean bRes = true;
        for (int i = 0; i < nextCharacters.length; ++i) {
            int[] lDone = new int[1];
            long lRes = this.oObj.nextCharacters(this.UnicodeString, nextCharacters[i][0], this.locale, nCharacterIteratorMode, nextCharacters[i][1], lDone);
            this.log.println("Expected result is: lRes = " + nextCharacters[i][2] + "; lDone = " + nextCharacters[i][3]);
            this.log.println("Actual result is: lRes = " + lRes + "; lDone = " + lDone[0]);
            bRes = bRes && lRes == (long)nextCharacters[i][2];
            bRes = bRes && lDone[0] == nextCharacters[i][3];
        }
        this.tRes.tested("nextCharacters()", bRes);
    }

    public void _previousCharacters() {
        short nCharacterIteratorMode = 0;
        int[][] previousCharacters = new int[][]{{5, 5000, 0, 5}, {10, 6, 4, 6}};
        boolean bRes = true;
        for (int i = 0; i < previousCharacters.length; ++i) {
            int[] lDone = new int[1];
            int lRes = this.oObj.previousCharacters(this.UnicodeString, previousCharacters[i][0], this.locale, nCharacterIteratorMode, previousCharacters[i][1], lDone);
            this.log.println("Expected result is: lRes = " + previousCharacters[i][2] + "; lDone = " + previousCharacters[i][3]);
            this.log.println("Actual result is: lRes = " + lRes + "; lDone = " + lDone[0]);
            bRes = bRes && lRes == previousCharacters[i][2];
            bRes = bRes && lDone[0] == previousCharacters[i][3];
        }
        this.tRes.tested("previousCharacters()", bRes);
    }

    public void _nextWord() {
        int i = 0;
        while (i < this.UnicodeString.length() - 1) {
            Boundary bounds = this.oObj.nextWord(this.UnicodeString, i, this.locale, this.wordType);
            if (bounds.endPos - bounds.startPos > 3) {
                this.vBounds.add(bounds);
                this.log.println("Word " + this.vBounds.size() + "(" + bounds.startPos + "," + bounds.endPos + "): '" + this.UnicodeString.substring(bounds.startPos, bounds.endPos) + "'");
            }
            i = bounds.endPos - 1;
        }
        this.log.println("In text there are " + this.vBounds.size() + " words, if count from left to right");
        this.tRes.tested("nextWord()", true);
    }

    public void _previousWord() {
        this.requiredMethod("nextWord()");
        int i = this.UnicodeString.length() - 1;
        Vector<Boundary> vPrevBounds = new Vector<Boundary>();
        while (i > 0) {
            Boundary bounds = this.oObj.previousWord(this.UnicodeString, i, this.locale, this.wordType);
            if (bounds.endPos - bounds.startPos > 3) {
                vPrevBounds.add(bounds);
                this.log.println("Word " + vPrevBounds.size() + "(" + bounds.startPos + "," + bounds.endPos + "): '" + this.UnicodeString.substring(bounds.startPos, bounds.endPos) + "'");
            }
            i = bounds.startPos;
        }
        this.log.println("In text there are " + vPrevBounds.size() + " words, if count from right to left");
        this.tRes.tested("previousWord()", vPrevBounds.size() == this.vBounds.size());
    }

    public void _getWordBoundary() {
        this.requiredMethod("nextWord()");
        boolean bRes = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary iBounds = (Boundary)this.vBounds.get(i);
            int iPos = (iBounds.endPos - iBounds.startPos) / 2 + iBounds.startPos;
            Boundary bounds = this.oObj.getWordBoundary(this.UnicodeString, iPos, this.locale, this.wordType, true);
            this.log.println("Expected result is: startPos = " + iBounds.startPos + "; endPos = " + iBounds.endPos);
            this.log.println("Actual result is: startPos = " + bounds.startPos + "; endPos = " + bounds.endPos + " Word is: '" + this.UnicodeString.substring(bounds.startPos, bounds.endPos) + "'");
            bRes = bRes && iBounds.startPos == bounds.startPos;
            bRes = bRes && iBounds.endPos == bounds.endPos;
        }
        this.tRes.tested("getWordBoundary()", bRes);
    }

    public void _getWordType() {
        this.requiredMethod("nextWord()");
        boolean bRes = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary iBounds = (Boundary)this.vBounds.get(i);
            int iPos = (iBounds.endPos - iBounds.startPos) / 2 + iBounds.startPos;
            short type = this.oObj.getWordType(this.UnicodeString, iPos, this.locale);
            bRes = bRes && type == 0;
        }
        this.tRes.tested("getWordType()", bRes);
    }

    public void _isBeginWord() {
        this.requiredMethod("nextWord()");
        boolean bRes = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary iBounds = (Boundary)this.vBounds.get(i);
            boolean isBegin = this.oObj.isBeginWord(this.UnicodeString, iBounds.startPos, this.locale, (short)0);
            bRes = bRes && isBegin;
            boolean isNotBegin = !this.oObj.isBeginWord(this.UnicodeString, iBounds.startPos + 1, this.locale, (short)0);
            bRes = bRes && isNotBegin;
            this.log.println("At position + " + iBounds.startPos + " isBeginWord? " + isBegin);
            this.log.println("At position + " + (iBounds.startPos + 1) + " isBeginWord? " + !isNotBegin);
        }
        this.tRes.tested("isBeginWord()", bRes);
    }

    public void _isEndWord() {
        this.requiredMethod("nextWord()");
        boolean bRes = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary iBounds = (Boundary)this.vBounds.get(i);
            boolean isEnd = this.oObj.isEndWord(this.UnicodeString, iBounds.endPos, this.locale, (short)0);
            bRes = bRes && isEnd;
            boolean isNotEnd = !this.oObj.isEndWord(this.UnicodeString, iBounds.endPos - 1, this.locale, (short)0);
            bRes = bRes && isNotEnd;
            this.log.println("At position + " + iBounds.endPos + " isEndWord? " + isEnd);
            this.log.println("At position + " + (iBounds.endPos - 1) + " isEndWord? " + !isNotEnd);
        }
        this.tRes.tested("isEndWord()", bRes);
    }

    public void _beginOfSentence() {
        for (int iPos = 0; iPos < this.UnicodeString.length(); ++iPos) {
            Integer start = new Integer(this.oObj.beginOfSentence(this.UnicodeString, iPos, this.locale));
            if (start < 0 || this.vSentenceStart.contains(start)) continue;
            this.vSentenceStart.add(start);
            this.log.println("Sentence " + this.vSentenceStart.size() + " : start from position " + start);
        }
        boolean bRes = this.oObj.beginOfSentence(this.UnicodeString, -10, this.locale) == -1;
        if (!(bRes &= this.oObj.beginOfSentence(this.UnicodeString, this.UnicodeString.length() + 1, this.locale) == -1)) {
            this.log.println("When invalid position, returned value isn't equal to -1");
        }
        this.tRes.tested("beginOfSentence()", bRes);
    }

    public void _endOfSentence() {
        boolean bRes = true;
        for (int i = 0; i < this.vSentenceStart.size(); ++i) {
            int start = (Integer)this.vSentenceStart.get(i);
            int end = this.oObj.endOfSentence(this.UnicodeString, start, this.locale);
            bRes &= end > start;
            this.log.println("Sentence " + i + " range is [" + start + ", " + end + "]");
        }
        boolean bInvRes = this.oObj.endOfSentence(this.UnicodeString, -10, this.locale) == -1;
        if (!(bInvRes &= this.oObj.endOfSentence(this.UnicodeString, this.UnicodeString.length() + 1, this.locale) == -1)) {
            this.log.println("When invalid position, returned value isn't equal to -1");
        }
        this.tRes.tested("endOfSentence()", bRes && bInvRes);
    }

    public void _getLineBreak() {
        int pos;
        boolean bRes = true;
        LineBreakHyphenationOptions lineBreakHyphenationOptions = new LineBreakHyphenationOptions();
        LineBreakUserOptions lineBreakUserOptions = new LineBreakUserOptions();
        lineBreakUserOptions.applyForbiddenRules = false;
        lineBreakUserOptions.allowHyphenateEnglish = false;
        int breakPos = 0;
        for (pos = 0; breakPos == 0 && pos < this.UnicodeString.length(); ++pos) {
            LineBreakResults lineBreakResults = this.oObj.getLineBreak(this.UnicodeString, pos, this.locale, 0, lineBreakHyphenationOptions, lineBreakUserOptions);
            breakPos = lineBreakResults.breakIndex;
        }
        boolean bl = bRes = breakPos <= pos && breakPos > 0;
        if (!bRes) {
            this.log.println("The last position was: " + pos + ", and the break position was: " + breakPos);
        }
        this.tRes.tested("getLineBreak()", bRes);
    }

    public void _beginOfScript() {
        String multiScript = "ab" + katakana;
        int pos = this.oObj.beginOfScript(multiScript, 3, (short)2);
        this.log.println("Position = " + pos);
        this.tRes.tested("beginOfScript()", pos == 2);
    }

    public void _endOfScript() {
        String multiScript = "ab" + katakana + "cd";
        int pos = this.oObj.endOfScript(multiScript, 2, (short)2);
        this.log.println("Position = " + pos);
        this.tRes.tested("endOfScript()", pos == 4);
    }

    public void _nextScript() {
        String multiScript = "ab" + katakana + "cd";
        int pos = this.oObj.nextScript(multiScript, 0, (short)1);
        this.log.println("Position = " + pos);
        this.tRes.tested("nextScript()", pos == 4);
    }

    public void _previousScript() {
        String multiScript = "ab" + katakana + "cd";
        int pos = this.oObj.previousScript(multiScript, 5, (short)2);
        this.log.println("Position = " + pos);
        this.tRes.tested("previousScript()", pos == 2);
    }

    public void _getScriptType() {
        boolean res = true;
        res &= this.oObj.getScriptType("abcd", 0) == 1;
        res &= this.oObj.getScriptType(katakana, 0) == 2;
        res &= this.oObj.getScriptType(arabic, 0) == 3;
        this.tRes.tested("getScriptType()", res &= this.oObj.getScriptType(arrows, 0) == 4);
    }

    protected short getCharBlockType(int pos) {
        int cType = 0;
        for (int i = 1; i < 31; i = (int)((short)(i + 1))) {
            if (this.oObj.beginOfCharBlock(this.UnicodeString, pos, this.locale, (short)i) == -1) continue;
            cType = i;
            i = 100;
        }
        return (short)cType;
    }

    public void _beginOfCharBlock() {
        int endPos;
        int iPos = 0;
        while (iPos < this.UnicodeString.length() && iPos > -1) {
            int endPos2;
            short charType = this.getCharBlockType(iPos);
            int startPos = this.oObj.beginOfCharBlock(this.UnicodeString, iPos, this.locale, charType);
            iPos = endPos2 = this.oObj.endOfCharBlock(this.UnicodeString, iPos, this.locale, charType);
            this.vCharBlockBounds.add(new Boundary(startPos, endPos2));
            this.log.println("" + this.vCharBlockBounds.size() + "). Bounds: [" + startPos + "," + endPos2 + "]; Type = " + charType);
            this.vCharBlockTypes.add(new Short(charType));
        }
        for (int i = 0; i < this.vCharBlockBounds.size() - 1; ++i) {
            endPos = ((Boundary)this.vCharBlockBounds.get((int)i)).endPos;
            int startPos = ((Boundary)this.vCharBlockBounds.get((int)(i + 1))).startPos;
            this.bCharBlockRes &= endPos == startPos;
        }
        this.log.println("Testing for no intersections : " + this.bCharBlockRes);
        int startPos = ((Boundary)this.vCharBlockBounds.get((int)0)).startPos;
        this.bCharBlockRes &= startPos == 0;
        endPos = ((Boundary)this.vCharBlockBounds.get((int)(this.vCharBlockBounds.size() - 1))).endPos;
        this.bCharBlockRes &= endPos == this.UnicodeString.length();
        this.log.println("Regions should starts with 0 and ends with " + this.UnicodeString.length());
        this.tRes.tested("beginOfCharBlock()", this.bCharBlockRes);
    }

    public void _endOfCharBlock() {
        this.requiredMethod("beginOfCharBlock()");
        this.tRes.tested("endOfCharBlock()", this.bCharBlockRes);
    }

    public void _nextCharBlock() {
        this.requiredMethod("beginOfCharBlock()");
        boolean bRes = true;
        for (int i = 0; i < this.vCharBlockBounds.size(); ++i) {
            int iPos;
            Boundary bounds = (Boundary)this.vCharBlockBounds.get(i);
            Short type = (Short)this.vCharBlockTypes.get(i);
            if (bounds.startPos - 1 < 0 || (iPos = this.oObj.nextCharBlock(this.UnicodeString, bounds.startPos - 1, this.locale, type)) == bounds.startPos) continue;
            bRes = false;
            this.log.println("nextCharBlock(UnicodeString, " + (bounds.startPos - 1) + ", locale, " + type + ") should return " + bounds.startPos);
            this.log.println("... and actual value is " + iPos);
        }
        this.tRes.tested("nextCharBlock()", bRes);
    }

    public void _previousCharBlock() {
        this.requiredMethod("beginOfCharBlock()");
        boolean bRes = true;
        for (int i = 0; i < this.vCharBlockBounds.size(); ++i) {
            Boundary bounds = (Boundary)this.vCharBlockBounds.get(i);
            Short type = (Short)this.vCharBlockTypes.get(i);
            int iPos = this.oObj.previousCharBlock(this.UnicodeString, bounds.endPos + 1, this.locale, type);
            if (iPos == bounds.startPos) continue;
            bRes = false;
            this.log.println("previousCharBlock(UnicodeString, " + (bounds.endPos + 1) + ", locale, " + type + ") should return " + bounds.startPos);
            this.log.println("... and actual value is " + iPos);
        }
        this.tRes.tested("previousCharBlock()", bRes);
    }
}

