/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import lib.MultiMethodTest;

public class _XFramesSupplier
extends MultiMethodTest {
    public static XFramesSupplier oObj = null;
    protected XIndexAccess frames = null;
    protected XFrame active = null;
    protected int activeIdx = -1;

    public void _getActiveFrame() {
        boolean result = true;
        this.requiredMethod("getFrames()");
        this.active = oObj.getActiveFrame();
        if (this.active == null) {
            result = oObj.getFrames().getCount() == 0;
            this.log.println("getActiveFrame() returned null");
        } else {
            boolean hasActiveFrame = false;
            for (int i = 0; i < this.frames.getCount(); ++i) {
                XFrame fr = null;
                try {
                    fr = null;
                    try {
                        fr = (XFrame)AnyConverter.toObject((Type)new Type(XFrame.class), (Object)this.frames.getByIndex(i));
                    }
                    catch (IllegalArgumentException iae) {
                        this.log.println("Can't convert any");
                    }
                }
                catch (WrappedTargetException e) {
                    this.log.println("Exception occured while calling getByIndex() method :");
                    e.printStackTrace(this.log);
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    this.log.println("Exception occured while calling getByIndex() method :");
                    e.printStackTrace(this.log);
                    return;
                }
                if (!this.active.equals(fr)) continue;
                hasActiveFrame = true;
                this.activeIdx = i;
            }
            if (!hasActiveFrame) {
                this.log.println("getActiveFrame() isn't contained in getFrames() collection");
                result = false;
            }
        }
        this.tRes.tested("getActiveFrame()", result);
    }

    public void _getFrames() {
        boolean result = true;
        int cnt = 0;
        this.frames = oObj.getFrames();
        if (this.frames != null) {
            cnt = this.frames.getCount();
            this.log.println("There are " + cnt + " frames.");
        } else {
            this.log.println("getFrames() returned null !!!");
            result = false;
        }
        for (int i = 0; i < cnt; ++i) {
            try {
                if (this.frames.getByIndex(i) != null) continue;
                this.log.println("Frame(" + i + ") == null");
                result = false;
                continue;
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while calling getByIndex() method :");
                e.printStackTrace(this.log);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Exception occured while calling getByIndex() method :");
                e.printStackTrace(this.log);
                return;
            }
        }
        this.tRes.tested("getFrames()", result);
    }

    public void _setActiveFrame() {
        boolean result = true;
        XFrame sFrame = null;
        this.requiredMethod("getActiveFrame()");
        if (this.frames.getCount() > 1) {
            try {
                if (this.activeIdx != 0) {
                    try {
                        sFrame = (XFrame)AnyConverter.toObject((Type)new Type(XFrame.class), (Object)this.frames.getByIndex(0));
                    }
                    catch (IllegalArgumentException iae) {
                        this.log.println("Can't convert any");
                    }
                }
                try {
                    sFrame = (XFrame)AnyConverter.toObject((Type)new Type(XFrame.class), (Object)this.frames.getByIndex(1));
                }
                catch (IllegalArgumentException iae) {
                    this.log.println("Can't convert any");
                }
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while calling getByIndex() method :");
                e.printStackTrace(this.log);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Exception occured while calling getByIndex() method :");
                e.printStackTrace(this.log);
                return;
            }
        } else {
            sFrame = this.frames.getCount() > 0 ? this.active : null;
        }
        oObj.setActiveFrame(sFrame);
        XFrame gFrame = oObj.getActiveFrame();
        if (!(gFrame == null && sFrame == null || sFrame.equals(gFrame))) {
            this.log.println("Active frame set is not equal frame get: FAILED");
            result = false;
        }
        this.tRes.tested("setActiveFrame()", result);
    }
}

