/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrameLoader;
import com.sun.star.frame.XLoadEventListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.SOfficeFactory;

public class _XFrameLoader
extends MultiMethodTest {
    public XFrameLoader oObj = null;
    private String url = null;
    private XFrame frame = null;
    private PropertyValue[] args = new PropertyValue[0];
    TestListener listener = new TestListener();
    XComponent frameSup = null;
    private boolean loaded = false;

    @Override
    public void before() {
        Object args;
        this.url = (String)this.tEnv.getObjRelation("FrameLoader.URL");
        this.frame = (XFrame)this.tEnv.getObjRelation("FrameLoader.Frame");
        if (this.frame == null) {
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)this.tParam.getMSF());
            try {
                this.log.println("creating a textdocument");
                this.frameSup = SOF.createTextDoc(null);
                Object oDsk = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.frame.Desktop");
                XDesktop dsk = UnoRuntime.queryInterface(XDesktop.class, oDsk);
                this.shortWait();
                this.frame = dsk.getCurrentFrame();
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
                throw new StatusException("Couldn't create a frame.", e);
            }
        }
        if ((args = this.tEnv.getObjRelation("FrameLoader.args")) != null) {
            this.args = (PropertyValue[])args;
        }
        if (this.url == null) {
            throw new StatusException(Status.failed("Some relations not found"));
        }
    }

    public void _load() {
        this.executeMethod("cancel()");
        if (!this.loaded) {
            this.oObj.load(this.frame, this.url, this.args, this.listener);
            this.shortWait();
            this.loaded = this.listener.finished;
        }
        this.tRes.tested("load()", this.loaded);
    }

    public void _cancel() {
        boolean result = true;
        this.oObj.load(this.frame, this.url, this.args, this.listener);
        this.oObj.cancel();
        this.shortWait();
        if (this.listener.cancelled) {
            this.log.println("Loading was canceled.");
        }
        if (this.listener.finished) {
            this.log.println("Loading was finished.");
            this.loaded = true;
        }
        if (!this.listener.cancelled && !this.listener.finished) {
            this.log.println("Loading was not canceled and not finished");
            result = false;
        }
        this.tRes.tested("cancel()", result);
    }

    @Override
    public void after() {
        if (this.frameSup != null) {
            this.frameSup.dispose();
        }
        this.frame.dispose();
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected class TestListener
    implements XLoadEventListener {
        public boolean finished = false;
        public boolean cancelled = false;

        protected TestListener() {
        }

        @Override
        public void loadFinished(XFrameLoader l) {
            this.finished = true;
        }

        @Override
        public void loadCancelled(XFrameLoader l) {
            this.cancelled = true;
        }

        @Override
        public void disposing(EventObject e) {
        }
    }
}

