/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.awt.XWindow;
import com.sun.star.frame.FrameAction;
import com.sun.star.frame.FrameActionEvent;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrameActionListener;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.RuntimeException;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.TestEnvironment;

public class _XFrame
extends MultiMethodTest {
    final FrameAction[] actionEvent = new FrameAction[1];
    final boolean[] listenerCalled = new boolean[]{false};
    final boolean[] activatedCalled = new boolean[]{false};
    final boolean[] deactivatedCalled = new boolean[]{false};
    final TestFrameActionListener listener = new TestFrameActionListener();
    public static XFrame oObj = null;

    public void _getName() {
        String name = oObj.getName();
        if (name == null) {
            this.log.println("getName() returned null: FAILED");
        }
        this.tRes.tested("getName()", name != null);
    }

    public void _setName() {
        String sName = "XFrame";
        oObj.setName(sName);
        String gName = oObj.getName();
        boolean res = sName.equals(gName);
        if (!res) {
            this.log.println("setName('" + sName + "'), but getName() return '" + gName + "'");
        }
        this.tRes.tested("setName()", res);
    }

    public void _activate() {
        oObj.activate();
        this.tRes.tested("activate()", true);
    }

    public void _deactivate() {
        oObj.deactivate();
        oObj.activate();
        this.tRes.tested("deactivate()", true);
    }

    public void _isActive() {
        boolean res;
        boolean result = true;
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop is always active");
            this.tRes.tested("isActive()", oObj.isActive());
            return;
        }
        oObj.deactivate();
        result &= !oObj.isActive();
        if (oObj.isActive()) {
            this.log.println("after deactivate() method call, isActive() returned true");
        }
        oObj.activate();
        result &= oObj.isActive();
        if (!oObj.isActive()) {
            this.log.println("after activate() method call, isActive() returned false");
        }
        if (res = _XFrame.isDesktop(this.log, this.tEnv, "isActive()")) {
            result = res;
        }
        this.tRes.tested("isActive()", result);
    }

    public void _addFrameActionListener() {
        boolean result = true;
        oObj.addFrameActionListener(this.listener);
        oObj.activate();
        oObj.deactivate();
        oObj.activate();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("No actions supported by Desktop");
            this.tRes.tested("addFrameActionListener()", true);
            return;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!this.listenerCalled[0]) {
            this.log.println("listener was not called.");
            result = false;
        } else {
            if (!this.activatedCalled[0]) {
                this.log.println("Listener was called, FRAME_ACTIVATED was not");
                result = false;
            }
            if (!this.deactivatedCalled[0]) {
                this.log.println("Listener was called, FRAME_DEACTIVATING was not");
                result = false;
            }
        }
        boolean res = _XFrame.isDesktop(this.log, this.tEnv, "addFrameActionListener()");
        if (res) {
            result = res;
        }
        this.tRes.tested("addFrameActionListener()", result);
    }

    public void _removeFrameActionListener() {
        boolean res;
        boolean result = true;
        this.requiredMethod("addFrameActionListener()");
        this.listenerCalled[0] = false;
        oObj.removeFrameActionListener(this.listener);
        oObj.activate();
        oObj.deactivate();
        oObj.activate();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("No actions supported by Desktop");
            this.tRes.tested("removeFrameActionListener()", true);
            return;
        }
        if (this.listenerCalled[0]) {
            this.log.println("Listener wasn't removed, and was called");
        }
        result = (res = _XFrame.isDesktop(this.log, this.tEnv, "removeFrameActionListener()")) ? res : !this.listenerCalled[0];
        this.tRes.tested("removeFrameActionListener()", result);
    }

    public void _getCreator() {
        boolean res;
        boolean result = true;
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no creator");
            this.tRes.tested("getCreator()", true);
            return;
        }
        XFramesSupplier creator = oObj.getCreator();
        if (creator == null) {
            this.log.println("getCreator() returns null");
        }
        result = (res = _XFrame.isDesktop(this.log, this.tEnv, "getCreator()")) ? res : creator != null;
        this.tRes.tested("getCreator()", result);
    }

    public void _getComponentWindow() {
        boolean res;
        boolean result = true;
        XWindow win = oObj.getComponentWindow();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no component window");
            this.tRes.tested("getComponentWindow()", true);
            return;
        }
        if (win == null) {
            this.log.println("getComponentWindow() returns null");
        }
        result = (res = _XFrame.isDesktop(this.log, this.tEnv, "getComponentWindow()")) ? res : win != null;
        this.tRes.tested("getComponentWindow()", result);
    }

    public void _getContainerWindow() {
        boolean res;
        boolean result = true;
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no container window");
            this.tRes.tested("getContainerWindow()", true);
            return;
        }
        XWindow win = oObj.getContainerWindow();
        if (win == null) {
            this.log.println("getContainerWindow() returns null");
        }
        result = (res = _XFrame.isDesktop(this.log, this.tEnv, "getContainerWindow()")) ? res : win != null;
        this.tRes.tested("getContainerWindow()", result);
    }

    public void _getController() {
        boolean result = true;
        XController ctrl = oObj.getController();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no controller");
            this.tRes.tested("getController()", true);
            return;
        }
        if (ctrl == null) {
            this.log.println("getController() returns null");
            result = false;
        } else {
            XFrame frm = ctrl.getFrame();
            if (!oObj.equals(frm)) {
                this.log.println("Frame returned by controller not equals to frame testing");
                result = false;
            }
        }
        boolean res = _XFrame.isDesktop(this.log, this.tEnv, "getController()");
        if (res) {
            result = res;
        }
        this.tRes.tested("getController()", result);
    }

    public void _isTop() {
        this.log.println("isTop() = " + oObj.isTop());
        this.tRes.tested("isTop()", true);
    }

    public void _findFrame() {
        XFrame frame;
        boolean result = true;
        XFrame aFrame = (XFrame)this.tEnv.getObjRelation("XFrame");
        if (aFrame != null) {
            this.log.println("Trying to find a frame with name 'XFrame' ...");
            frame = oObj.findFrame("XFrame", 55);
            if (frame == null) {
                this.log.println("findFrame(\"XFrame,com.sun.star.frame.FrameSearchFlag.GLOBAL\") returns null");
                result = false;
            } else if (!aFrame.equals(frame)) {
                this.log.println("findFrame(\"XFrame,com.sun.star.frame.FrameSearchFlag.GLOBAL\")  returns frame which is not equal to passed in relation");
                result = false;
            }
        }
        this.log.println("Trying to find a frame with name '_self' ...");
        frame = oObj.findFrame("_self", 0);
        if (frame == null) {
            this.log.println("findFrame(\"_self\") returns null");
            result = false;
        } else if (!oObj.equals(frame)) {
            this.log.println("findFrame(\"_self\")  returns frame which is not equal to tested");
            result = false;
        }
        this.tRes.tested("findFrame()", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _contextChanged() {
        boolean result = true;
        TestFrameActionListener listener = new TestFrameActionListener();
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop cann't change context");
            this.tRes.tested("contextChanged()", true);
            return;
        }
        this.listenerCalled[0] = false;
        oObj.addFrameActionListener(listener);
        try {
            oObj.contextChanged();
            if (!this.listenerCalled[0]) {
                this.log.println("listener was not called on contextChanged() call.");
                result = false;
            } else if (this.actionEvent[0] != FrameAction.CONTEXT_CHANGED) {
                this.log.println("listener was called, but Action != CONTEXT_CHANGED");
                result = false;
            }
        }
        finally {
            oObj.removeFrameActionListener(listener);
        }
        boolean res = _XFrame.isDesktop(this.log, this.tEnv, "contextChanged()");
        if (res) {
            result = res;
        }
        this.tRes.tested("contextChanged()", result);
    }

    public void _setCreator() {
        if (this.tEnv.getTestCase().getObjectName().equals("Desktop")) {
            this.log.println("Desktop has no creator");
            this.tRes.tested("setCreator()", true);
            return;
        }
        XFramesSupplier oldCreator = oObj.getCreator();
        oObj.setCreator(null);
        this.tRes.tested("setCreator()", oObj.getCreator() == null);
        oObj.setCreator(oldCreator);
    }

    public void _setComponent() {
        this.requiredMethod("getName()");
        this.requiredMethod("setName()");
        this.requiredMethod("activate()");
        this.requiredMethod("deactivate()");
        this.requiredMethod("isActive()");
        this.requiredMethod("addFrameActionListener()");
        this.requiredMethod("getComponentWindow()");
        this.requiredMethod("getContainerWindow()");
        this.requiredMethod("getController()");
        this.requiredMethod("isTop()");
        this.requiredMethod("findFrame()");
        this.requiredMethod("contextChanged()");
        this.requiredMethod("setCreator()");
        boolean result = true;
        XWindow oldWindow = oObj.getComponentWindow();
        XController oldController = oObj.getController();
        boolean rs = oObj.setComponent(null, null);
        if (rs) {
            result &= oObj.getComponentWindow() == null;
            if (!(result &= oObj.getController() == null)) {
                this.log.println("setComponent() returns true, but component is not changed.");
            }
        } else {
            result &= oObj.getComponentWindow() == oldWindow;
            if (!(result &= oObj.getController() == oldController)) {
                this.log.println("setComponent() returns false, but component ischanged.");
            }
        }
        this.tRes.tested("setComponent()", result);
    }

    public void _initialize() {
        this.requiredMethod("setComponent()");
        XWindow win = oObj.getContainerWindow();
        boolean bOK = true;
        try {
            oObj.initialize(win);
        }
        catch (RuntimeException e) {
            String message = "Frame::initialized() is called more then once, which isnt usefull nor allowed.";
            if (e.toString().indexOf(message) != -1) {
                this.log.println(e.toString());
                this.log.println("methods throws exception, but it's OK");
            }
            this.log.println(e.toString());
            bOK = false;
        }
        this.tRes.tested("initialize()", bOK);
    }

    public static boolean isDesktop(PrintWriter log, TestEnvironment env, String method) {
        Object isD = env.getObjRelation("Desktop");
        if (isD != null) {
            log.println("The Desktop doesn't support the method " + method);
            log.println("It will always return true");
            return true;
        }
        return false;
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }

    private class TestFrameActionListener
    implements XFrameActionListener {
        private TestFrameActionListener() {
        }

        @Override
        public void frameAction(FrameActionEvent e) {
            _XFrame.this.listenerCalled[0] = true;
            _XFrame.this.activatedCalled[0] = _XFrame.this.activatedCalled[0] | e.Action == FrameAction.FRAME_ACTIVATED;
            _XFrame.this.deactivatedCalled[0] = _XFrame.this.deactivatedCalled[0] | e.Action == FrameAction.FRAME_DEACTIVATING;
            _XFrame.this.actionEvent[0] = e.Action;
        }

        @Override
        public void disposing(EventObject e) {
        }
    }
}

