/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XDispatchRecorder;
import com.sun.star.frame.XDispatchRecorderSupplier;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import lib.MultiMethodTest;
import lib.StatusException;
import util.SOfficeFactory;
import util.utils;

public class _XDispatchRecorderSupplier
extends MultiMethodTest {
    public static XDispatchRecorderSupplier oObj = null;
    XComponent xTextDoc = null;
    XDispatchRecorder recorder = null;
    XDesktop desktop = null;

    @Override
    protected void before() {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)this.tParam.getMSF());
        try {
            this.log.println("creating a text document");
            this.xTextDoc = SOF.createTextDoc(null);
            XInterface inst = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.frame.Desktop");
            this.desktop = UnoRuntime.queryInterface(XDesktop.class, (Object)inst);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(this.log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    public void _setDispatchRecorder() {
        this.requiredMethod("getDispatchRecorder()");
        boolean res = true;
        boolean locRes = true;
        this.log.print("Setting custom macro recorder ...");
        oObj.setDispatchRecorder(new MyRecorder());
        XDispatchRecorder rec = oObj.getDispatchRecorder();
        boolean bl = locRes = rec != null && "MyRecorder implementation".equals(rec.getRecordedMacro());
        if (locRes) {
            this.log.println("OK");
        } else {
            this.log.println("FAILED");
        }
        res &= locRes;
        this.log.print("Setting null dispatch recorder ...");
        oObj.setDispatchRecorder(null);
        boolean bl2 = locRes = oObj.getDispatchRecorder() == null;
        if (locRes) {
            this.log.println("OK");
        } else {
            this.log.println("FAILED");
        }
        this.log.println("Setting old macro recorder ...");
        oObj.setDispatchRecorder(this.recorder);
        this.tRes.tested("setDispatchRecorder()", res &= locRes);
    }

    public void _getDispatchRecorder() {
        this.recorder = oObj.getDispatchRecorder();
        this.tRes.tested("getDispatchRecorder()", true);
    }

    public void _dispatchAndRecord() {
        boolean locRes;
        this.requiredMethod("getDispatchRecorder()");
        boolean res = true;
        if (this.recorder == null) {
            try {
                Object inst = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.comp.framework.DispatchRecorder");
                this.recorder = UnoRuntime.queryInterface(XDispatchRecorder.class, inst);
                oObj.setDispatchRecorder(this.recorder);
            }
            catch (com.sun.star.uno.Exception e) {
                throw new StatusException("Couldn't create recorder", e);
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        XModel model = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XFrame fr = model.getCurrentController().getFrame();
        XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)fr);
        URL dispURL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        XDispatch xDisp = xDispProv.queryDispatch(dispURL, "", 0);
        PropertyValue[] args = new PropertyValue[]{new PropertyValue()};
        args[0].Name = "Text";
        args[0].Value = "XDispatchRecorderSupplier";
        this.log.print("Dispatching and recording ...");
        oObj.dispatchAndRecord(dispURL, args, xDisp);
        String macro = this.recorder.getRecordedMacro();
        boolean bl = locRes = macro != null && macro.indexOf("XDispatchRecorderSupplier") > -1 && macro.indexOf(".uno:InsertText") > -1;
        if (locRes) {
            this.log.println("OK");
        } else {
            this.log.println("FAILED");
        }
        res &= locRes;
        this.log.println("Recorder macro :\n" + macro);
        this.log.print("Trying to set dispatch with null Dispatcher ...");
        try {
            oObj.dispatchAndRecord(dispURL, args, null);
            this.log.println("OK");
        }
        catch (Exception e) {
            this.log.println("Exception is OK: " + e);
        }
        this.log.print("Trying to set dispatch recorder to null and record ...");
        oObj.setDispatchRecorder(null);
        try {
            oObj.dispatchAndRecord(dispURL, args, xDisp);
            this.log.println("OK");
        }
        catch (Exception e) {
            this.log.println("Exception is OK: " + e);
        }
        oObj.setDispatchRecorder(this.recorder);
        this.tRes.tested("dispatchAndRecord()", res);
    }

    @Override
    protected void after() {
        this.xTextDoc.dispose();
    }

    private static class MyRecorder
    implements XDispatchRecorder {
        private MyRecorder() {
        }

        @Override
        public void startRecording(XFrame p0) {
        }

        @Override
        public void recordDispatch(URL p0, PropertyValue[] p1) {
        }

        @Override
        public void recordDispatchAsComment(URL p0, PropertyValue[] p1) {
        }

        @Override
        public void endRecording() {
        }

        @Override
        public String getRecordedMacro() {
            return "MyRecorder implementation";
        }
    }
}

